/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.adminconsole.LocalServerManagementPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.adminconsole.places.advanced.UserGroupManagementPlace;
import com.sap.sailing.gwt.ui.adminconsole.places.advanced.UserManagementPlace;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.ServerConfigurationDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.ServerInfoDTO;
import com.sap.sse.gwt.client.controls.listedit.ListEditorUiStrategy;
import com.sap.sse.gwt.client.controls.listedit.StringListEditorComposite;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedUserDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;

/*
 * Exception performing whole class analysis ignored.
 */
public class LocalServerManagementPanel
extends SimplePanel {
    private final SailingServiceWriteAsync sailingService;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final AccessControlledButtonPanel buttonPanel;
    private Label serverNameInfo;
    private Label buildVersionInfo;
    private Anchor groupOwnerInfo;
    private Anchor userOwnerInfo;
    private CheckBox isStandaloneServerCheckbox;
    private CheckBox isPublicServerCheckbox;
    private CheckBox isSelfServiceServerCheckbox;
    private CheckBox isCORSWildcardCheckbox;
    private Label activeBrandingIdLabel;
    private StringListEditorComposite corsAllowedOriginsTextArea;
    private ServerInfoDTO currentServerInfo;
    private final UserService userService;
    private final UserStatusEventHandler userStatusEventHandler = new /* Unavailable Anonymous Inner Class!! */;

    public LocalServerManagementPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.sailingService = presenter.getSailingService();
        this.userService = presenter.getUserService();
        this.errorReporter = presenter.getErrorReporter();
        this.stringMessages = stringMessages;
        VerticalPanel mainPanel = new VerticalPanel();
        this.setWidget((Widget)mainPanel);
        mainPanel.setWidth("100%");
        this.buttonPanel = this.createServerActionsUi(this.userService);
        mainPanel.add((Widget)this.buttonPanel);
        mainPanel.add(this.createServerInfoUI());
        mainPanel.add(this.createServerConfigurationUI());
        this.refreshServerConfiguration();
        if (this.userService.hasServerPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.CONFIGURE_CORS_FILTER)) {
            mainPanel.add(this.createCORSFilterConfigurationUI());
            this.refreshCORSConfiguration();
        }
        this.refreshBrandingConfiguration();
        mainPanel.add(this.createDebrandingConfigurationUI());
    }

    protected void onLoad() {
        super.onLoad();
        this.userService.addUserStatusEventHandler(this.userStatusEventHandler, true);
    }

    protected void onUnload() {
        super.onUnload();
        this.userService.removeUserStatusEventHandler(this.userStatusEventHandler);
    }

    private AccessControlledButtonPanel createServerActionsUi(UserService userService) {
        HasPermissions type = SecuredSecurityTypes.SERVER;
        Consumer<ServerInfoDTO> updateCallback = event -> userService.updateUser(false);
        EditOwnershipDialog.DialogConfig configOwner = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, updateCallback, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, updateCallback, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        Predicate<HasPermissions.DefaultActions> permissionCheck = action -> this.currentServerInfo != null && userService.hasPermission(type.getPermission(new HasPermissions.Action[]{action}), this.currentServerInfo.getOwnership());
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(userService, type);
        buttonPanel.addAction(this.stringMessages.actionChangeOwnership(), () -> permissionCheck.test(HasPermissions.DefaultActions.CHANGE_OWNERSHIP), () -> configOwner.openOwnershipDialog((SecuredDTO)this.currentServerInfo));
        buttonPanel.addAction(this.stringMessages.actionChangeACL(), () -> permissionCheck.test(HasPermissions.DefaultActions.CHANGE_ACL), () -> configACL.openDialog((SecuredDTO)this.currentServerInfo));
        return buttonPanel;
    }

    private Widget createDebrandingConfigurationUI() {
        ServerDataCaptionPanel captionPanel = new ServerDataCaptionPanel(this, this.stringMessages.debrandingConfiguration(), 1, null);
        VerticalPanel brandingPanel = new VerticalPanel();
        brandingPanel.setSpacing(4);
        this.activeBrandingIdLabel = new Label();
        brandingPanel.add((Widget)this.activeBrandingIdLabel);
        ServerDataCaptionPanel.access$1((ServerDataCaptionPanel)captionPanel, (String)this.stringMessages.activeBranding(), (Widget)brandingPanel);
        return captionPanel;
    }

    private Widget createServerInfoUI() {
        ServerDataCaptionPanel captionPanel = new ServerDataCaptionPanel(this, this.stringMessages.serverInformation(), 4, null);
        this.serverNameInfo = ServerDataCaptionPanel.access$2((ServerDataCaptionPanel)captionPanel, (String)(String.valueOf(this.stringMessages.name()) + ":"));
        this.buildVersionInfo = ServerDataCaptionPanel.access$2((ServerDataCaptionPanel)captionPanel, (String)(String.valueOf(this.stringMessages.buildVersion()) + ":"));
        this.groupOwnerInfo = ServerDataCaptionPanel.access$3((ServerDataCaptionPanel)captionPanel, (String)(String.valueOf(this.stringMessages.ownership()) + " - " + this.stringMessages.group() + ":"));
        this.userOwnerInfo = ServerDataCaptionPanel.access$3((ServerDataCaptionPanel)captionPanel, (String)(String.valueOf(this.stringMessages.ownership()) + " - " + this.stringMessages.user() + ":"));
        return captionPanel;
    }

    private Widget createServerConfigurationUI() {
        ServerDataCaptionPanel captionPanel = new ServerDataCaptionPanel(this, this.stringMessages.serverConfiguration(), 3, null);
        Command callback = () -> this.serverConfigurationChanged();
        this.isStandaloneServerCheckbox = ServerDataCaptionPanel.access$4((ServerDataCaptionPanel)captionPanel, (String)(String.valueOf(this.stringMessages.standaloneServer()) + ":"), (Command)callback);
        this.isStandaloneServerCheckbox.ensureDebugId("isStandaloneServerCheckbox");
        this.isPublicServerCheckbox = ServerDataCaptionPanel.access$4((ServerDataCaptionPanel)captionPanel, (String)(String.valueOf(this.stringMessages.publicServer()) + ":"), (Command)callback);
        this.isPublicServerCheckbox.ensureDebugId("isPublicServerCheckbox");
        this.isSelfServiceServerCheckbox = ServerDataCaptionPanel.access$4((ServerDataCaptionPanel)captionPanel, (String)(String.valueOf(this.stringMessages.selfServiceServer()) + ":"), (Command)callback);
        this.isSelfServiceServerCheckbox.ensureDebugId("isSelfServiceServerCheckbox");
        return captionPanel;
    }

    private Widget createCORSFilterConfigurationUI() {
        ServerDataCaptionPanel captionPanel = new ServerDataCaptionPanel(this, this.stringMessages.corsAndCSPFilterConfiguration(), 4, null);
        ServerDataCaptionPanel.access$1((ServerDataCaptionPanel)captionPanel, (String)"", (Widget)new Label(this.stringMessages.corsAndCSPFilterConfigurationHint()));
        HorizontalPanel buttonPanel = (HorizontalPanel)ServerDataCaptionPanel.access$1((ServerDataCaptionPanel)captionPanel, (String)"", (Widget)new HorizontalPanel());
        Button refreshButton = new Button(this.stringMessages.refresh());
        buttonPanel.add((Widget)refreshButton);
        refreshButton.addClickHandler(e -> this.refreshCORSConfiguration());
        this.isCORSWildcardCheckbox = ServerDataCaptionPanel.access$4((ServerDataCaptionPanel)captionPanel, (String)this.stringMessages.isCORSWildcard(), () -> {
            if (this.isCORSWildcardCheckbox.getValue().booleanValue()) {
                this.userService.getUserManagementWriteService().setCORSFilterConfigurationToWildcard((AsyncCallback)new RefreshAsyncCallback(this, v -> {
                    this.corsAllowedOriginsTextArea.setEnabled(false);
                    this.corsAllowedOriginsTextArea.setValue(Collections.emptyList(), false);
                    Notification.notify((String)this.stringMessages.successfullyUpdatedCORSAllowedOrigins(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                }, null));
            } else {
                this.userService.getUserManagementWriteService().setCORSFilterConfigurationAllowedOrigins(new ArrayList(this.corsAllowedOriginsTextArea.getValue()), (AsyncCallback)new RefreshAsyncCallback(this, v -> {
                    this.corsAllowedOriginsTextArea.setEnabled(true);
                    Notification.notify((String)this.stringMessages.successfullyUpdatedCORSAllowedOrigins(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                }, null));
            }
        });
        this.isCORSWildcardCheckbox.setEnabled(true);
        IconResources iconResources = (IconResources)GWT.create(IconResources.class);
        this.corsAllowedOriginsTextArea = (StringListEditorComposite)ServerDataCaptionPanel.access$1((ServerDataCaptionPanel)captionPanel, (String)this.stringMessages.corsAllowedOrigins(), (Widget)new StringListEditorComposite(Collections.emptyList(), (ListEditorUiStrategy)new /* Unavailable Anonymous Inner Class!! */));
        this.corsAllowedOriginsTextArea.addValueChangeHandler(e -> {
            this.isCORSWildcardCheckbox.setValue(Boolean.valueOf(false), true);
            this.userService.getUserManagementWriteService().setCORSFilterConfigurationAllowedOrigins(new ArrayList(Util.asList((Iterable)((Iterable)e.getValue()))), (AsyncCallback)new RefreshAsyncCallback(this, v -> Notification.notify((String)this.stringMessages.successfullyUpdatedCORSAllowedOrigins(), (Notification.NotificationType)Notification.NotificationType.SUCCESS), null));
        });
        return captionPanel;
    }

    private void serverConfigurationChanged() {
        Boolean publicServer = this.isPublicServerCheckbox.isEnabled() ? this.isPublicServerCheckbox.getValue() : null;
        Boolean selfServiceServer = this.isSelfServiceServerCheckbox.isEnabled() ? this.isSelfServiceServerCheckbox.getValue() : null;
        ServerConfigurationDTO serverConfig = new ServerConfigurationDTO(this.isStandaloneServerCheckbox.getValue().booleanValue(), publicServer, selfServiceServer, null);
        this.isSelfServiceServerCheckbox.getElement().setAttribute("updating", "true");
        this.sailingService.updateServerConfiguration(serverConfig, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refreshServerConfiguration() {
        this.sailingService.getServerConfiguration((AsyncCallback)new RefreshAsyncCallback(this, arg_0 -> this.updateServerConfiguration(arg_0), null));
    }

    public void refreshBrandingConfiguration() {
        this.userService.getUserManagementService().getBrandingConfigurationId((AsyncCallback)new RefreshAsyncCallback(this, arg_0 -> this.updateBrandingConfiguration(arg_0), null));
    }

    public void refreshCORSConfiguration() {
        if (this.userService.hasServerPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.CONFIGURE_CORS_FILTER)) {
            this.userService.getUserManagementService().getCORSFilterConfiguration((AsyncCallback)new RefreshAsyncCallback(this, arg_0 -> this.updateCORSFilterConfiguration(arg_0), null));
        }
    }

    private void updateServerInfo(ServerInfoDTO serverInfo) {
        this.currentServerInfo = serverInfo;
        this.buttonPanel.updateVisibility();
        this.serverNameInfo.setText(serverInfo.getName());
        this.buildVersionInfo.setText(serverInfo.getBuildVersion() != null ? serverInfo.getBuildVersion() : "Unknown");
        OwnershipDTO ownership = serverInfo.getOwnership();
        boolean hasGroupOwner = ownership != null && ownership.getTenantOwner() != null;
        boolean hasUserOwner = ownership != null && ownership.getUserOwner() != null;
        this.groupOwnerInfo.setText(hasGroupOwner ? ((StrippedUserGroupDTO)ownership.getTenantOwner()).getName() : "---");
        if (hasGroupOwner) {
            this.groupOwnerInfo.setHref(UriUtils.fromString((String)("#" + UserGroupManagementPlace.class.getSimpleName() + ":" + "filter" + "=" + ((StrippedUserGroupDTO)ownership.getTenantOwner()).getName() + "&" + "selectExact" + "=" + ((StrippedUserGroupDTO)ownership.getTenantOwner()).getId().toString())));
        } else {
            this.groupOwnerInfo.setHref("javascript:;");
        }
        this.userOwnerInfo.setText(hasUserOwner ? ((StrippedUserDTO)ownership.getUserOwner()).getName() : "---");
        if (hasUserOwner) {
            this.userOwnerInfo.setHref(UriUtils.fromString((String)("#" + UserManagementPlace.class.getSimpleName() + ":" + "filter" + "=" + ((StrippedUserDTO)ownership.getUserOwner()).getName() + "&" + "selectExact" + "=" + ((StrippedUserDTO)ownership.getUserOwner()).getName())));
        } else {
            this.userOwnerInfo.setHref("javascript:;");
        }
        this.isSelfServiceServerCheckbox.setEnabled(this.userService.hasServerPermission((HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL));
        this.isPublicServerCheckbox.setEnabled(true);
    }

    private void updateServerConfiguration(ServerConfigurationDTO result) {
        this.isStandaloneServerCheckbox.setValue(Boolean.valueOf(result.isStandaloneServer()), false);
        this.isStandaloneServerCheckbox.setEnabled(true);
        this.isPublicServerCheckbox.setValue(result.isPublic(), false);
        this.isSelfServiceServerCheckbox.setValue(result.isSelfService(), false);
    }

    private void updateBrandingConfiguration(String brandingConfigurationId) {
        this.activeBrandingIdLabel.setText(brandingConfigurationId == null ? this.stringMessages.none() : brandingConfigurationId);
    }

    private void updateCORSFilterConfiguration(Util.Pair<Boolean, ArrayList<String>> corsFilterConfiguration) {
        if (corsFilterConfiguration == null) {
            this.isCORSWildcardCheckbox.setValue(Boolean.valueOf(false));
            this.corsAllowedOriginsTextArea.setValue(Collections.emptyList(), false);
            this.corsAllowedOriginsTextArea.setEnabled(true);
        } else {
            this.isCORSWildcardCheckbox.setValue((Boolean)corsFilterConfiguration.getA());
            this.corsAllowedOriginsTextArea.setValue((Iterable)corsFilterConfiguration.getB(), false);
            this.corsAllowedOriginsTextArea.setEnabled(this.isCORSWildcardCheckbox.getValue() == false);
        }
    }

    static /* synthetic */ UserService access$0(LocalServerManagementPanel localServerManagementPanel) {
        return localServerManagementPanel.userService;
    }

    static /* synthetic */ void access$1(LocalServerManagementPanel localServerManagementPanel, ServerInfoDTO serverInfoDTO) {
        localServerManagementPanel.updateServerInfo(serverInfoDTO);
    }

    static /* synthetic */ ErrorReporter access$2(LocalServerManagementPanel localServerManagementPanel) {
        return localServerManagementPanel.errorReporter;
    }

    static /* synthetic */ StringMessages access$3(LocalServerManagementPanel localServerManagementPanel) {
        return localServerManagementPanel.stringMessages;
    }

    static /* synthetic */ CheckBox access$4(LocalServerManagementPanel localServerManagementPanel) {
        return localServerManagementPanel.isSelfServiceServerCheckbox;
    }
}

