/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.LeaderboardType;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.PairingListTemplateDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.common.client.help.HelpButton;
import com.sap.sailing.gwt.common.client.help.HelpButtonResources;
import com.sap.sailing.gwt.settings.client.EntryPointWithSettingsLinkFactory;
import com.sap.sailing.gwt.settings.client.leaderboard.AbstractLeaderboardPerspectiveLifecycle;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardContextDefinition;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardPerspectiveLifecycle;
import com.sap.sailing.gwt.settings.client.leaderboard.MetaLeaderboardPerspectiveLifecycle;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardConfigPanel;
import com.sap.sailing.gwt.ui.adminconsole.CopyPairingListDialog;
import com.sap.sailing.gwt.ui.adminconsole.EditCompetitorsDialog;
import com.sap.sailing.gwt.ui.adminconsole.FlexibleLeaderboardCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.FlexibleLeaderboardEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardConfigPanel;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardDescriptor;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardRaceConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.NameBasedStrippedLeaderboardDTOEntityIdentityComparator;
import com.sap.sailing.gwt.ui.adminconsole.PairingListCreationDialog;
import com.sap.sailing.gwt.ui.adminconsole.PairingListCreationSetupDialog;
import com.sap.sailing.gwt.ui.adminconsole.RaceColumnsInLeaderboardDialog;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLeaderboardCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLeaderboardWithEliminationsCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLeaderboardWithOtherTieBreakingLeaderboardCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.SelectedLeaderboardProvider;
import com.sap.sailing.gwt.ui.adminconsole.SetFinishingAndFinishedTimeDialog;
import com.sap.sailing.gwt.ui.adminconsole.SetStartTimeDialog;
import com.sap.sailing.gwt.ui.adminconsole.ShowCompetitorToBoatMappingsDialog;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRaceChangedListener;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.EntryPointLinkFactory;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.ComponentLifecycle;
import com.sap.sse.gwt.client.shared.components.LinkWithSettingsGenerator;
import com.sap.sse.gwt.client.shared.components.SettingsDialogForLinkSharing;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.NamedDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class LeaderboardConfigPanel
extends AbstractLeaderboardConfigPanel
implements SelectedLeaderboardProvider<StrippedLeaderboardDTO>,
TrackedRaceChangedListener {
    private static final Logger logger = Logger.getLogger(LeaderboardConfigPanel.class.getName());
    private final AnchorTemplates ANCHORTEMPLATE = (AnchorTemplates)GWT.create(AnchorTemplates.class);
    private final boolean showRaceDetails;
    private Button leaderboardRemoveButton;
    private Button addRaceColumnsButton;
    private Button columnMoveUpButton;
    private Button columnMoveDownButton;
    private final Refresher<CompetitorDTO> competitorsRefresher;
    private final Refresher<BoatDTO> boatsRefresher;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$LeaderboardType;

    public LeaderboardConfigPanel(AdminConsoleView.Presenter presenter, StringMessages theStringConstants, boolean showRaceDetails) {
        super(presenter, theStringConstants, false);
        this.showRaceDetails = showRaceDetails;
        this.leaderboardTable.ensureDebugId("LeaderboardsCellTable");
        this.competitorsRefresher = presenter.getCompetitorsRefresher();
        this.boatsRefresher = presenter.getBoatsRefresher();
    }

    protected void addLeaderboardControls(AccessControlledButtonPanel buttonPanel) {
        Button createFlexibleLeaderboardBtn = buttonPanel.addCreateAction(String.valueOf(this.stringMessages.createFlexibleLeaderboard()) + " ...", () -> this.createFlexibleLeaderboard());
        createFlexibleLeaderboardBtn.ensureDebugId("CreateFlexibleLeaderboardButton");
        Supplier<Boolean> leaderboardCreateAndRegattaReadPermission = () -> this.userService.hasCurrentUserPermissionToCreateObjectOfType(SecuredDomainType.LEADERBOARD) && this.userService.hasCurrentUserAnyPermission(SecuredDomainType.REGATTA.getPermission(new HasPermissions.Action[]{HasPermissions.DefaultActions.READ}), null);
        Button createRegattaLeaderboardBtn = buttonPanel.addAction(String.valueOf(this.stringMessages.createRegattaLeaderboard()) + " ...", leaderboardCreateAndRegattaReadPermission, () -> this.createRegattaLeaderboard());
        createRegattaLeaderboardBtn.ensureDebugId("CreateRegattaLeaderboardButton");
        Button createRegattaLeaderboardWithEliminationsBtn = buttonPanel.addAction(String.valueOf(this.stringMessages.createRegattaLeaderboardWithEliminations()) + " ...", leaderboardCreateAndRegattaReadPermission, () -> this.createRegattaLeaderboardWithEliminations());
        createRegattaLeaderboardWithEliminationsBtn.ensureDebugId("CreateRegattaLeaderboardWithEliminationsButton");
        Button createRegattaLeaderboardWithOtherTieBreakingLeaderboardBtn = buttonPanel.addAction(String.valueOf(this.stringMessages.createRegattaLeaderboardWithOtherTieBreakingLeaderboard()) + " ...", leaderboardCreateAndRegattaReadPermission, () -> this.createRegattaLeaderboardWithOtherTieBreakingLeaderboard());
        createRegattaLeaderboardWithOtherTieBreakingLeaderboardBtn.ensureDebugId("CreateRegattaLeaderboardWithOtherTieBreakingLeaderboardButton");
        this.leaderboardRemoveButton = buttonPanel.addRemoveAction(this.stringMessages.remove(), (SetSelectionModel)this.leaderboardSelectionModel, true, () -> this.removeLeaderboards((Collection)this.leaderboardSelectionModel.getSelectedSet()));
        this.leaderboardRemoveButton.ensureDebugId("LeaderboardsRemoveButton");
        buttonPanel.addUnsecuredWidget((Widget)new HelpButton(HelpButtonResources.INSTANCE, this.stringMessages.videoGuide(), "https://sapsailing-documentation.s3-eu-west-1.amazonaws.com/adminconsole/Advanced+Topics/Leaderboard+Group+explained.mp4"));
    }

    protected void addColumnsToLeaderboardTableAndSetSelectionModel(UserService userService, FlushableCellTable<StrippedLeaderboardDTO> leaderboardTable, AdminConsoleTableResources tableResources, ListDataProvider<StrippedLeaderboardDTO> listDataProvider) {
        ColumnSortEvent.ListHandler leaderboardColumnListHandler = new ColumnSortEvent.ListHandler(this.filteredLeaderboardList.getList());
        SelectionCheckboxColumn selectionCheckboxColumn = this.createSortableSelectionCheckboxColumn(leaderboardTable, tableResources, leaderboardColumnListHandler, listDataProvider);
        AnchorCell anchorCell = new AnchorCell();
        1 linkColumn = new /* Unavailable Anonymous Inner Class!! */;
        linkColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)linkColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        3 leaderboardDisplayNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        leaderboardDisplayNameColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)leaderboardDisplayNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        5 leaderboardCanBoatsOfCompetitorsChangePerRaceColumn = new /* Unavailable Anonymous Inner Class!! */;
        leaderboardCanBoatsOfCompetitorsChangePerRaceColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)leaderboardCanBoatsOfCompetitorsChangePerRaceColumn, (l1, l2) -> Boolean.valueOf(l1.canBoatsOfCompetitorsChangePerRace).compareTo(l2.canBoatsOfCompetitorsChangePerRace));
        6 discardingOptionsColumn = new /* Unavailable Anonymous Inner Class!! */;
        discardingOptionsColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)discardingOptionsColumn, (o1, o2) -> {
            int n;
            int n2;
            int[] nArray;
            String s1 = "";
            String s2 = "";
            if (o1.discardThresholds != null) {
                nArray = o1.discardThresholds;
                n2 = o1.discardThresholds.length;
                n = 0;
                while (n < n2) {
                    int i1 = nArray[n];
                    s1 = String.valueOf(s1) + i1;
                    ++n;
                }
            }
            if (o2.discardThresholds != null) {
                nArray = o2.discardThresholds;
                n2 = o2.discardThresholds.length;
                n = 0;
                while (n < n2) {
                    int i2 = nArray[n];
                    s2 = String.valueOf(s2) + i2;
                    ++n;
                }
            }
            return new NaturalComparator().compare(s1, s2);
        });
        7 leaderboardTypeColumn = new /* Unavailable Anonymous Inner Class!! */;
        leaderboardTypeColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)leaderboardTypeColumn, (o1, o2) -> o1.type.compareTo((Enum)o2.type));
        8 scoringSystemColumn = new /* Unavailable Anonymous Inner Class!! */;
        scoringSystemColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)scoringSystemColumn, (o1, o2) -> {
            String s1 = o1.scoringScheme == null ? null : o1.scoringScheme.toString();
            String s2 = o2.scoringScheme == null ? null : o2.scoringScheme.toString();
            return new NaturalComparator().compare(s1, s2);
        });
        9 courseAreasColumn = new /* Unavailable Anonymous Inner Class!! */;
        courseAreasColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)courseAreasColumn, (o1, o2) -> new NaturalComparator().compare(Util.joinStrings((String)", ", (Iterable)Util.map((Iterable)o1.courseAreas, NamedDTO::getName)), Util.joinStrings((String)", ", (Iterable)Util.map((Iterable)o2.courseAreas, NamedDTO::getName))));
        HasPermissions type = SecuredDomainType.LEADERBOARD;
        AccessControlledActionsColumn leaderboardActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new LeaderboardConfigImagesBarCell(this.stringMessages), (UserService)userService);
        leaderboardActionColumn.addAction(LeaderboardConfigImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.editLeaderboard(arg_0));
        leaderboardActionColumn.addAction(LeaderboardConfigImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, leaderboardDTO -> {
            if (Window.confirm((String)this.stringMessages.doYouReallyWantToRemoveLeaderboard(leaderboardDTO.getName()))) {
                this.removeLeaderboard(leaderboardDTO);
            }
        });
        leaderboardActionColumn.addAction("ACTION_EDIT_SCORES", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, leaderboardDTO -> {
            String leaderboardEditingUrl = EntryPointWithSettingsLinkFactory.createLeaderboardEditingLink((String)leaderboardDTO.getName());
            Window.open((String)leaderboardEditingUrl, (String)"_blank", null);
        });
        leaderboardActionColumn.addAction("ACTION_EDIT_COMPETITORS", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, leaderboardDTO -> {
            EditCompetitorsDialog editCompetitorsDialog = new EditCompetitorsDialog(this.sailingServiceWrite, userService, this.competitorsRefresher, this.boatsRefresher, leaderboardDTO.getName(), leaderboardDTO.boatClassName, !leaderboardDTO.canBoatsOfCompetitorsChangePerRace, this.stringMessages, this.errorReporter, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
            editCompetitorsDialog.show();
        });
        leaderboardActionColumn.addAction("ACTION_CONFIGURE_URL", (HasPermissions.Action)HasPermissions.DefaultActions.READ, leaderboardDTO -> this.sailingServiceWrite.getAvailableDetailTypesForLeaderboard(leaderboardDTO.getName(), null, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        leaderboardActionColumn.addAction("ACTION_OPEN_COACH_DASHBOARD", (HasPermissions.Action)HasPermissions.DefaultActions.READ, leaderboardDTO -> {
            HashMap<String, String> dashboardURLParameters = new HashMap<String, String>();
            dashboardURLParameters.put("leaderboardName", leaderboardDTO.getName());
            Window.open((String)EntryPointLinkFactory.createDashboardLink(dashboardURLParameters), (String)"", null);
        });
        leaderboardActionColumn.addAction("ACTION_SHOW_REGATTA_LOG", (HasPermissions.Action)HasPermissions.DefaultActions.READ, leaderboardDTO -> this.showRegattaLog());
        leaderboardActionColumn.addAction("ACTION_CREATE_PAIRINGLIST", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.createPairingListTemplate(arg_0));
        leaderboardActionColumn.addAction("ACTION_COPY_PAIRINGLIST_FROM_OTHER_LEADERBOARD", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.copyPairingListFromOtherLeaderboard(arg_0));
        leaderboardActionColumn.addAction("ACTION_PRINT_PAIRINGLIST", (HasPermissions.Action)HasPermissions.DefaultActions.READ, arg_0 -> this.openPairingListEntryPoint(arg_0));
        EditOwnershipDialog.DialogConfig config = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, leaderboardDTO -> this.reloadLeaderboardForTable(leaderboardDTO.getName()), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        leaderboardActionColumn.addAction(LeaderboardConfigImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, (Consumer)new /* Unavailable Anonymous Inner Class!! */);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, leaderboardDTO -> this.reloadLeaderboardForTable(leaderboardDTO.getName()), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        leaderboardActionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, (Consumer)new /* Unavailable Anonymous Inner Class!! */);
        leaderboardTable.addColumn((Column)selectionCheckboxColumn, selectionCheckboxColumn.getHeader());
        leaderboardTable.addColumn((Column)linkColumn, this.stringMessages.name());
        leaderboardTable.addColumn((Column)leaderboardDisplayNameColumn, this.stringMessages.displayName());
        leaderboardTable.addColumn((Column)leaderboardCanBoatsOfCompetitorsChangePerRaceColumn, this.stringMessages.canBoatsChange());
        leaderboardTable.addColumn((Column)discardingOptionsColumn, this.stringMessages.discarding());
        leaderboardTable.addColumn((Column)leaderboardTypeColumn, this.stringMessages.type());
        leaderboardTable.addColumn((Column)scoringSystemColumn, this.stringMessages.scoringSystem());
        leaderboardTable.addColumn((Column)courseAreasColumn, this.stringMessages.courseAreas());
        SecuredDTOOwnerColumn.configureOwnerColumns(leaderboardTable, (ColumnSortEvent.ListHandler)leaderboardColumnListHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        leaderboardTable.addColumn((Column)leaderboardActionColumn, this.stringMessages.actions());
        leaderboardTable.addColumnSortHandler((ColumnSortEvent.Handler)leaderboardColumnListHandler);
        leaderboardTable.setSelectionModel((SelectionModel)selectionCheckboxColumn.getSelectionModel(), selectionCheckboxColumn.getSelectionManager());
    }

    /*
     * Exception decompiling
     */
    private void editLeaderboard(StrippedLeaderboardDTO leaderboardDTO) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LeaderboardDescriptor createLeaderboardDescriptor(StrippedLeaderboardDTO leaderboardDTO, ScoringSchemeType scoringScheme) {
        return new LeaderboardDescriptor(leaderboardDTO.getName(), leaderboardDTO.displayName, scoringScheme, leaderboardDTO.discardThresholds, leaderboardDTO.regattaName, (Iterable)Util.mapToArrayList((Iterable)leaderboardDTO.courseAreas, CourseAreaDTO::getId));
    }

    protected void addColumnsToRacesTable(CellTable<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality> racesTable) {
        17 explicitFactorColumn = new /* Unavailable Anonymous Inner Class!! */;
        19 isMedalRaceCheckboxColumn = new /* Unavailable Anonymous Inner Class!! */;
        isMedalRaceCheckboxColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        isMedalRaceCheckboxColumn.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        21 isLinkedRaceColumn = new /* Unavailable Anonymous Inner Class!! */;
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new LeaderboardRaceConfigImagesBarCell((SelectedLeaderboardProvider)this, this.stringMessages), (UserService)this.userService, item -> this.getSelectedLeaderboard());
        actionsColumn.addAction("ACTION_EDIT", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> ((LeaderboardConfigPanel)this).editRaceColumnOfLeaderboard(arg_0));
        actionsColumn.addAction("ACTION_UNLINK", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, object -> this.unlinkRaceColumnFromTrackedRace(((RaceColumnDTO)object.getA()).getRaceColumnName(), (FleetDTO)object.getB()));
        actionsColumn.addAction("ACTION_REMOVE", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, object -> {
            if (Window.confirm((String)this.stringMessages.reallyRemoveRace(((RaceColumnDTO)object.getA()).getRaceColumnName()))) {
                this.removeRaceColumn((RaceColumnDTO)object.getA());
            }
        });
        actionsColumn.addAction("ACTION_REFRESH_RACE_LOG", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, object -> this.refreshRaceLog((RaceColumnDTO)object.getA(), (FleetDTO)object.getB(), true));
        actionsColumn.addAction("ACTION_SET_STARTTIME", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, object -> this.setStartTime((RaceColumnDTO)object.getA(), (FleetDTO)object.getB()));
        actionsColumn.addAction("ACTION_SET_FINISHING_AND_FINISH_TIME", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, object -> this.setEndTime((RaceColumnDTO)object.getA(), (FleetDTO)object.getB()));
        actionsColumn.addAction("ACTION_SHOW_RACELOG", (HasPermissions.Action)HasPermissions.DefaultActions.READ, object -> this.showRaceLog((RaceColumnDTO)object.getA(), (FleetDTO)object.getB()));
        actionsColumn.addAction("ACTION_EDIT_COMPETITOR_TO_BOAT_MAPPINGS", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, object -> this.editCompetitorToBoatMappings((RaceColumnDTO)object.getA(), (FleetDTO)object.getB()));
        actionsColumn.addAction("ACTION_CERTIFICATE_ASSIGNMENT", (HasPermissions.Action)HasPermissions.DefaultActions.READ, object -> this.assignCertificates(object));
        actionsColumn.addAction("ACTION_SCRATCH_BOAT_SELECTION", (HasPermissions.Action)HasPermissions.DefaultActions.READ, object -> this.selectScratchBoat(object));
        actionsColumn.addAction("ACTION_SET_IMPLIED_WIND", (HasPermissions.Action)HasPermissions.DefaultActions.READ, object -> this.setImpliedWind(object));
        racesTable.addColumn((Column)isMedalRaceCheckboxColumn, this.stringMessages.medalRace());
        racesTable.addColumn((Column)isLinkedRaceColumn, this.stringMessages.islinked());
        racesTable.addColumn((Column)explicitFactorColumn, this.stringMessages.factor());
        racesTable.addColumn((Column)actionsColumn, this.stringMessages.actions());
        racesTable.ensureDebugId("RacesCellTable");
    }

    protected void addSelectedLeaderboardRacesControls(Panel racesPanel) {
        this.addRaceColumnsButton = new Button(String.valueOf(this.stringMessages.actionAddRaces()) + "...");
        this.addRaceColumnsButton.ensureDebugId("AddRacesButton");
        this.addRaceColumnsButton.addClickHandler(event -> {
            if (this.getSelectedLeaderboard().type.isRegattaLeaderboard()) {
                Notification.notify((String)this.stringMessages.cannotAddRacesToRegattaLeaderboardButOnlyToRegatta(), (Notification.NotificationType)Notification.NotificationType.ERROR);
            } else {
                this.addRaceColumnsToLeaderboard();
            }
        });
        racesPanel.add((Widget)this.addRaceColumnsButton);
        this.columnMoveUpButton = new Button(this.stringMessages.columnMoveUp());
        this.columnMoveUpButton.ensureDebugId("MoveRaceUpButton");
        this.columnMoveUpButton.addClickHandler(event -> this.moveSelectedRaceColumnUp());
        racesPanel.add((Widget)this.columnMoveUpButton);
        this.columnMoveDownButton = new Button(this.stringMessages.columnMoveDown());
        this.columnMoveDownButton.ensureDebugId("MoveRaceDownButton");
        this.columnMoveDownButton.addClickHandler(event -> this.moveSelectedRaceColumnDown());
        racesPanel.add((Widget)this.columnMoveDownButton);
    }

    protected void openUpdateFlexibleLeaderboardDialog(StrippedLeaderboardDTO leaderboardDTO, List<StrippedLeaderboardDTO> otherExistingLeaderboard, String oldLeaderboardName, LeaderboardDescriptor descriptor) {
        this.sailingServiceWrite.getEvents((AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected void openUpdateFlexibleLeaderboardDialog(StrippedLeaderboardDTO leaderboardDTO, List<StrippedLeaderboardDTO> otherExistingLeaderboard, String oldLeaderboardName, LeaderboardDescriptor descriptor, List<EventDTO> existingEvents) {
        FlexibleLeaderboardEditDialog dialog = new FlexibleLeaderboardEditDialog(Collections.unmodifiableCollection(otherExistingLeaderboard), descriptor, this.userService, this.stringMessages, Collections.unmodifiableList(existingEvents), this.errorReporter, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    private void openLeaderboardUrlConfigDialog(AbstractLeaderboardDTO leaderboard, Iterable<DetailType> availableDetailType) {
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.userService, this.subscriptionServiceFactory);
        Object lifeCycle = leaderboard.type.isMetaLeaderboard() ? new MetaLeaderboardPerspectiveLifecycle(this.stringMessages, leaderboard, availableDetailType, (PaywallResolver)paywallResolver) : new LeaderboardPerspectiveLifecycle(this.stringMessages, leaderboard, availableDetailType, (PaywallResolver)paywallResolver);
        LeaderboardContextDefinition leaderboardContextSettings = new LeaderboardContextDefinition(leaderboard.getName(), leaderboard.getDisplayName());
        LinkWithSettingsGenerator linkWithSettingsGenerator = new LinkWithSettingsGenerator("/gwt/Leaderboard.html", () -> ((AbstractLeaderboardPerspectiveLifecycle)lifeCycle).createDefaultSettings(), new GenericSerializableSettings[]{leaderboardContextSettings});
        SettingsDialogForLinkSharing dialog = new SettingsDialogForLinkSharing(linkWithSettingsGenerator, (ComponentLifecycle)lifeCycle, (com.sap.sse.gwt.client.StringMessages)this.stringMessages);
        dialog.ensureDebugId("LeaderboardPageUrlConfigurationDialog");
        dialog.show();
    }

    private void editCompetitorToBoatMappings(RaceColumnDTO raceColumnDTO, FleetDTO fleetDTO) {
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        String raceColumnName = raceColumnDTO.getName();
        String fleetName = fleetDTO.getName();
        String raceName = "Default".equals(fleetName) ? raceColumnName : String.valueOf(raceColumnName) + ", " + fleetName;
        ShowCompetitorToBoatMappingsDialog dialog = new ShowCompetitorToBoatMappingsDialog(this.sailingServiceWrite, this.stringMessages, this.errorReporter, selectedLeaderboardName, raceColumnName, fleetName, raceName, this.userService);
        dialog.center();
    }

    private void setStartTime(RaceColumnDTO raceColumnDTO, FleetDTO fleetDTO) {
        new SetStartTimeDialog((SailingServiceAsync)this.sailingServiceWrite, this.errorReporter, this.getSelectedLeaderboardName(), raceColumnDTO.getName(), fleetDTO.getName(), this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void setEndTime(RaceColumnDTO raceColumnDTO, FleetDTO fleetDTO) {
        new SetFinishingAndFinishedTimeDialog((SailingServiceAsync)this.sailingServiceWrite, this.errorReporter, this.getSelectedLeaderboardName(), raceColumnDTO.getName(), fleetDTO.getName(), this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private void removeRaceColumn(RaceColumnDTO raceColumnDTO) {
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        String raceColumnString = raceColumnDTO.getRaceColumnName();
        this.sailingServiceWrite.removeLeaderboardColumn(this.getSelectedLeaderboardName(), raceColumnString, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void moveSelectedRaceColumnDown() {
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        String selectedRaceColumnName = ((RaceColumnDTO)this.getSelectedRaceColumnWithFleet().getA()).getRaceColumnName();
        this.sailingServiceWrite.moveLeaderboardColumnDown(this.getSelectedLeaderboardName(), selectedRaceColumnName, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void moveSelectedRaceColumnUp() {
        String selectedLeaderboardName = this.getSelectedLeaderboardName();
        String selectedRaceColumnName = ((RaceColumnDTO)this.getSelectedRaceColumnWithFleet().getA()).getRaceColumnName();
        this.sailingServiceWrite.moveLeaderboardColumnUp(this.getSelectedLeaderboardName(), selectedRaceColumnName, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected void leaderboardRaceColumnSelectionChanged() {
        this.selectedRaceInLeaderboard = this.getSelectedRaceColumnWithFleet();
        if (this.selectedRaceInLeaderboard != null) {
            this.columnMoveUpButton.setEnabled(true);
            this.columnMoveDownButton.setEnabled(true);
            this.selectTrackedRaceInRaceList();
        } else {
            this.columnMoveUpButton.setEnabled(false);
            this.columnMoveDownButton.setEnabled(false);
            this.trackedRacesListComposite.clearSelection();
        }
    }

    private void setIsMedalRace(String leaderboardName, RaceColumnDTO raceInLeaderboard, boolean isMedalRace) {
        this.sailingServiceWrite.updateIsMedalRace(leaderboardName, raceInLeaderboard.getRaceColumnName(), isMedalRace, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addRaceColumnsToLeaderboard() {
        String leaderboardName = this.getSelectedLeaderboardName();
        ArrayList<RaceColumnDTO> existingRaceColumns = new ArrayList<RaceColumnDTO>();
        for (AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality pair : this.raceColumnTable.getDataProvider().getList()) {
            existingRaceColumns.add((RaceColumnDTO)pair.getA());
        }
        RaceColumnsInLeaderboardDialog raceDialog = new RaceColumnsInLeaderboardDialog(existingRaceColumns, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        raceDialog.ensureDebugId("RaceColumnsInLeaderboardDialog");
        raceDialog.show();
    }

    private void updateRaceColumnsOfLeaderboard(String leaderboardName, List<RaceColumnDTO> existingRaceColumns, List<RaceColumnDTO> newRaceColumns) {
        ArrayList<Util.Pair> raceColumnsToAdd = new ArrayList<Util.Pair>();
        for (RaceColumnDTO newRaceColumn : newRaceColumns) {
            if (existingRaceColumns.contains(newRaceColumn)) continue;
            raceColumnsToAdd.add(new Util.Pair((Object)newRaceColumn.getName(), (Object)newRaceColumn.isMedalRace()));
        }
        this.sailingServiceWrite.addColumnsToLeaderboard(leaderboardName, raceColumnsToAdd, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected void leaderboardSelectionChanged() {
        Set selectedLeaderboards = this.leaderboardSelectionModel.getSelectedSet();
        boolean canDeleteAllSelected = true;
        for (StrippedLeaderboardDTO leaderboard : selectedLeaderboards) {
            if (this.userService.hasPermission((SecuredDTO)leaderboard, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE)) continue;
            canDeleteAllSelected = false;
        }
        this.leaderboardRemoveButton.setEnabled(!selectedLeaderboards.isEmpty() && canDeleteAllSelected);
        StrippedLeaderboardDTO selectedLeaderboard = this.getSelectedLeaderboard();
        if (this.leaderboardSelectionModel.getSelectedSet().size() == 1 && selectedLeaderboard != null) {
            this.raceColumnTable.getDataProvider().getList().clear();
            for (RaceColumnDTO raceColumn : selectedLeaderboard.getRaceList()) {
                for (FleetDTO fleet : raceColumn.getFleets()) {
                    this.raceColumnTable.getDataProvider().getList().add(new AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality(raceColumn, fleet, selectedLeaderboard));
                }
            }
            this.selectedLeaderBoardPanel.setVisible(true);
            this.selectedLeaderBoardPanel.setCaptionText("Details of leaderboard '" + selectedLeaderboard.getName() + "'");
            if (!selectedLeaderboard.type.isMetaLeaderboard()) {
                this.trackedRacesListComposite.setRegattaFilterValue(selectedLeaderboard.regattaName);
                this.trackedRacesCaptionPanel.setVisible(true);
            }
            boolean hasPermission = this.userService.hasPermission((SecuredDTO)selectedLeaderboard, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE);
            boolean isRegattaLeaderboard = selectedLeaderboard.type.isRegattaLeaderboard();
            this.addRaceColumnsButton.setVisible(hasPermission && !isRegattaLeaderboard);
            this.columnMoveUpButton.setVisible(hasPermission && !isRegattaLeaderboard);
            this.columnMoveDownButton.setVisible(hasPermission && !isRegattaLeaderboard);
        } else {
            this.selectedLeaderBoardPanel.setVisible(false);
            this.trackedRacesCaptionPanel.setVisible(false);
            this.selectedRaceInLeaderboard = null;
        }
    }

    private void createFlexibleLeaderboard() {
        this.sailingServiceWrite.getEvents((AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void createFlexibleLeaderboard(List<EventDTO> existingEvents) {
        FlexibleLeaderboardCreateDialog dialog = new FlexibleLeaderboardCreateDialog(Collections.unmodifiableCollection(this.availableLeaderboardList), this.userService, this.stringMessages, Collections.unmodifiableCollection(existingEvents), this.errorReporter, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("FlexibleLeaderboardCreateDialog");
        dialog.show();
    }

    private void createRegattaLeaderboard() {
        RegattaLeaderboardCreateDialog dialog = new RegattaLeaderboardCreateDialog(Collections.unmodifiableCollection(this.availableLeaderboardList), Collections.unmodifiableCollection(this.allRegattas), new LeaderboardDescriptor(), this.stringMessages, this.errorReporter, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("RegattaLeaderboardCreateDialog");
        dialog.show();
    }

    private void createRegattaLeaderboardWithEliminations() {
        RegattaLeaderboardWithEliminationsCreateDialog dialog = new RegattaLeaderboardWithEliminationsCreateDialog(this.sailingServiceWrite, this.userService, Collections.unmodifiableCollection(this.availableLeaderboardList), Collections.unmodifiableCollection(this.allRegattas), this.stringMessages, this.errorReporter, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("RegattaLeaderboardCreateDialog");
        dialog.show();
    }

    private void createRegattaLeaderboardWithOtherTieBreakingLeaderboard() {
        RegattaLeaderboardWithOtherTieBreakingLeaderboardCreateDialog dialog = new RegattaLeaderboardWithOtherTieBreakingLeaderboardCreateDialog(Collections.unmodifiableCollection(this.availableLeaderboardList), Collections.unmodifiableCollection(this.allRegattas), this.stringMessages, this.errorReporter, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("RegattaLeaderboardWithOtherTieBreakingLeaderboardCreateDialog");
        dialog.show();
    }

    private void addLeaderboard(StrippedLeaderboardDTO result) {
        this.filteredLeaderboardList.getList().add(result);
        this.availableLeaderboardList.add(result);
        this.presenter.getLeaderboardsRefresher().add((Object)result);
        this.leaderboardSelectionModel.clear();
        this.leaderboardSelectionModel.setSelected((Object)result, true);
        this.loadAndRefreshLeaderboard(result);
    }

    private void updateLeaderboard(String leaderboardName, LeaderboardDescriptor leaderboardToUpdate) {
        this.sailingServiceWrite.updateLeaderboard(leaderboardName, leaderboardToUpdate.getDisplayName(), leaderboardToUpdate.getDiscardThresholds(), leaderboardToUpdate.getCourseAreaIds(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void reloadLeaderboardForTable(String leaderboardName) {
        this.sailingServiceWrite.getLeaderboardWithSecurity(leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void refreshLeaderboardInTable(String oldLeaderboardName, StrippedLeaderboardDTO updatedLeaderboard) {
        int indexOfLeaderboard = 0;
        int i = 0;
        while (i < this.availableLeaderboardList.size()) {
            StrippedLeaderboardDTO dao = (StrippedLeaderboardDTO)this.availableLeaderboardList.get(i);
            if (dao.getName().equals(oldLeaderboardName)) {
                indexOfLeaderboard = i;
                break;
            }
            ++i;
        }
        this.getLeaderboardsRefresher().addIfNotContainedElseReplace((Object)updatedLeaderboard, (EntityIdentityComparator)new NameBasedStrippedLeaderboardDTOEntityIdentityComparator());
        this.availableLeaderboardList.set(indexOfLeaderboard, updatedLeaderboard);
        this.filterLeaderboardPanel.updateAll((Iterable)this.availableLeaderboardList);
    }

    private void removeLeaderboards(Collection<StrippedLeaderboardDTO> leaderboards) {
        if (!leaderboards.isEmpty()) {
            HashSet<String> leaderboardNames = new HashSet<String>();
            for (StrippedLeaderboardDTO leaderboard : leaderboards) {
                leaderboardNames.add(leaderboard.getName());
            }
            this.sailingServiceWrite.removeLeaderboards(leaderboardNames, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void removeLeaderboard(StrippedLeaderboardDTO leaderBoard) {
        this.sailingServiceWrite.removeLeaderboard(leaderBoard.getName(), (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void removeLeaderboardFromTable(StrippedLeaderboardDTO leaderBoard) {
        this.filteredLeaderboardList.getList().remove(leaderBoard);
        this.availableLeaderboardList.remove(leaderBoard);
        this.leaderboardSelectionModel.setSelected((Object)leaderBoard, false);
    }

    private void createPairingListTemplate(StrippedLeaderboardDTO leaderboardDTO) {
        PairingListCreationSetupDialog dialog = new PairingListCreationSetupDialog(leaderboardDTO, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    private void copyPairingListFromOtherLeaderboard(StrippedLeaderboardDTO targetLeaderboardDTO) {
        CopyPairingListDialog dialog = new CopyPairingListDialog((Collection)this.availableLeaderboardList, Collections.unmodifiableCollection(this.allRegattas), targetLeaderboardDTO, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    private void openPairingListCreationDialog(StrippedLeaderboardDTO leaderboardDTO, PairingListTemplateDTO template) {
        PairingListCreationDialog dialog = new PairingListCreationDialog(leaderboardDTO, this.stringMessages, template, this.sailingServiceWrite, this.errorReporter);
        dialog.show();
    }

    private void openPairingListEntryPoint(StrippedLeaderboardDTO leaderboardDTO) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("leaderboardName", leaderboardDTO.getName());
        String link = EntryPointLinkFactory.createPairingListLink(result);
        Window.open((String)link, (String)"", (String)"");
    }

    static /* synthetic */ boolean access$0(LeaderboardConfigPanel leaderboardConfigPanel) {
        return leaderboardConfigPanel.showRaceDetails;
    }

    static /* synthetic */ AnchorTemplates access$1(LeaderboardConfigPanel leaderboardConfigPanel) {
        return leaderboardConfigPanel.ANCHORTEMPLATE;
    }

    static /* synthetic */ Logger access$2() {
        return logger;
    }

    static /* synthetic */ void access$3(LeaderboardConfigPanel leaderboardConfigPanel, AbstractLeaderboardDTO abstractLeaderboardDTO, Iterable iterable) {
        leaderboardConfigPanel.openLeaderboardUrlConfigDialog(abstractLeaderboardDTO, iterable);
    }

    static /* synthetic */ void access$4(LeaderboardConfigPanel leaderboardConfigPanel, String string, LeaderboardDescriptor leaderboardDescriptor) {
        leaderboardConfigPanel.updateLeaderboard(string, leaderboardDescriptor);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$LeaderboardType() {
        if ($SWITCH_TABLE$com$sap$sailing$domain$common$LeaderboardType != null) {
            return $SWITCH_TABLE$com$sap$sailing$domain$common$LeaderboardType;
        }
        int[] nArray = new int[LeaderboardType.values().length];
        try {
            nArray[LeaderboardType.FlexibleLeaderboard.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LeaderboardType.FlexibleMetaLeaderboard.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LeaderboardType.RegattaLeaderboard.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LeaderboardType.RegattaLeaderboardWithEliminations.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LeaderboardType.RegattaLeaderboardWithOtherTieBreakingLeaderboard.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[LeaderboardType.RegattaMetaLeaderboard.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sailing$domain$common$LeaderboardType = nArray;
        return nArray;
    }

    static /* synthetic */ void access$6(LeaderboardConfigPanel leaderboardConfigPanel, String string, RaceColumnDTO raceColumnDTO, boolean bl) {
        leaderboardConfigPanel.setIsMedalRace(string, raceColumnDTO, bl);
    }

    static /* synthetic */ void access$7(LeaderboardConfigPanel leaderboardConfigPanel, String string, List list, List list2) {
        leaderboardConfigPanel.updateRaceColumnsOfLeaderboard(string, list, list2);
    }

    static /* synthetic */ void access$8(LeaderboardConfigPanel leaderboardConfigPanel, List list) {
        leaderboardConfigPanel.createFlexibleLeaderboard(list);
    }

    static /* synthetic */ void access$9(LeaderboardConfigPanel leaderboardConfigPanel, StrippedLeaderboardDTO strippedLeaderboardDTO) {
        leaderboardConfigPanel.addLeaderboard(strippedLeaderboardDTO);
    }

    static /* synthetic */ void access$10(LeaderboardConfigPanel leaderboardConfigPanel, String string, StrippedLeaderboardDTO strippedLeaderboardDTO) {
        leaderboardConfigPanel.refreshLeaderboardInTable(string, strippedLeaderboardDTO);
    }

    static /* synthetic */ void access$11(LeaderboardConfigPanel leaderboardConfigPanel, StrippedLeaderboardDTO strippedLeaderboardDTO) {
        leaderboardConfigPanel.removeLeaderboardFromTable(strippedLeaderboardDTO);
    }

    static /* synthetic */ void access$12(LeaderboardConfigPanel leaderboardConfigPanel, StrippedLeaderboardDTO strippedLeaderboardDTO, PairingListTemplateDTO pairingListTemplateDTO) {
        leaderboardConfigPanel.openPairingListCreationDialog(strippedLeaderboardDTO, pairingListTemplateDTO);
    }
}

