/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.racelog.tracking.MappableToDevice;
import com.sap.sailing.gwt.ui.adminconsole.ExpeditionAllInOneAfterImportHandler;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLogFixesAddMappingsDialog;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLogSensorDataAddMappingsDialog;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.DeviceIdentifierDTO;
import com.sap.sailing.gwt.ui.shared.DeviceMappingDTO;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sailing.gwt.ui.shared.TrackFileImportDeviceIdentifierDTO;
import com.sap.sailing.gwt.ui.shared.TypedDeviceMappingDTO;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class ExpeditionAllInOneAfterImportHandler {
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final UserService userService;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final String leaderboardGroupName;
    private final UUID leaderboardGroupId;
    protected EventDTO event;
    private RegattaDTO regatta;
    private StrippedLeaderboardDTO leaderboard;
    private List<TrackFileImportDeviceIdentifierDTO> gpsFixesDeviceIDs;
    private List<TrackFileImportDeviceIdentifierDTO> sensorFixesDeviceIDs;
    private final String sensorImporterType;
    private List<Util.Triple<String, String, String>> raceEntries;
    private String regattaName;
    private Iterable<TimePoint> startTimes;

    public ExpeditionAllInOneAfterImportHandler(UUID eventId, String regattaName, String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId, List<Util.Triple<String, String, String>> raceEntries, List<String> gpsDeviceIds, List<String> sensorDeviceIds, String sensorImporterType, Iterable<TimePoint> startTimes, SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<CompetitorDTO> competitorsRefresher, Refresher<BoatDTO> boatsRefresher, Refresher<RegattaDTO> regattasRefresher, Refresher<EventDTO> eventsRefresher, Refresher<StrippedLeaderboardDTO> leaderboardsRefresher, Refresher<LeaderboardGroupDTO> leaderboardGroupsRefresher, ErrorReporter errorReporter, StringMessages stringMessages, Displayer<RegattaDTO> regattaOracleToRefresh) {
        this.leaderboardGroupName = leaderboardGroupName;
        this.leaderboardGroupId = leaderboardGroupId;
        this.sensorImporterType = sensorImporterType;
        this.sailingServiceWrite = sailingServiceWrite;
        this.userService = userService;
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.raceEntries = raceEntries;
        this.regattaName = regattaName;
        this.startTimes = startTimes;
        sailingServiceWrite.getEventById(eventId, false, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showCompetitorRegistration(Refresher<CompetitorDTO> competitorsRefresher, Refresher<BoatDTO> boatsRefresher) {
        new RegattaLogCompetitorRegistrationAndSelectionDialog(this, this.regatta.boatClass == null ? null : this.regatta.boatClass.getName(), this.sailingServiceWrite, this.userService, competitorsRefresher, boatsRefresher, this.stringMessages, this.errorReporter, true, this.leaderboard.getName(), this.leaderboard.canBoatsOfCompetitorsChangePerRace).show();
    }

    private void mapCompetitorsToGPSFixDeviceIds(Set<CompetitorDTO> mappedCompetitors) {
        if (this.gpsFixesDeviceIDs.size() == 1 && mappedCompetitors.size() == 1) {
            TrackFileImportDeviceIdentifierDTO deviceIdentifierDTO = (TrackFileImportDeviceIdentifierDTO)this.gpsFixesDeviceIDs.iterator().next();
            CompetitorDTO competitor = mappedCompetitors.iterator().next();
            this.saveCompetitorGPSMapping(mappedCompetitors, Collections.singleton(new DeviceMappingDTO((DeviceIdentifierDTO)deviceIdentifierDTO, deviceIdentifierDTO.from, deviceIdentifierDTO.to, (MappableToDevice)competitor, null)));
        } else {
            new RegattaLogFixesAddMappingsDialog(this.sailingServiceWrite, this.userService, this.errorReporter, this.stringMessages, this.leaderboard.getName(), (Collection)this.gpsFixesDeviceIDs, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
        }
    }

    private void saveCompetitorGPSMapping(Set<CompetitorDTO> mappedCompetitors, Collection<DeviceMappingDTO> mappings) {
        new AddDeviceMappingsToRegattaLog(this, this.leaderboard.getName(), mappings, () -> this.mapCompetitorsToSensorFixDeviceIds(mappedCompetitors));
    }

    private final void mapCompetitorsToSensorFixDeviceIds(Set<CompetitorDTO> mappedCompetitors) {
        if (this.sensorFixesDeviceIDs.size() == 1 && mappedCompetitors.size() == 1) {
            TrackFileImportDeviceIdentifierDTO deviceIdentifierDTO = (TrackFileImportDeviceIdentifierDTO)this.sensorFixesDeviceIDs.iterator().next();
            CompetitorDTO competitor = mappedCompetitors.iterator().next();
            this.saveCompetitorSensorFixMapping(Collections.singleton(new TypedDeviceMappingDTO((DeviceIdentifierDTO)deviceIdentifierDTO, deviceIdentifierDTO.from, deviceIdentifierDTO.to, (MappableToDevice)competitor, null, this.sensorImporterType)));
        } else if (this.sensorFixesDeviceIDs.size() > 0) {
            new RegattaLogSensorDataAddMappingsDialog(this.sailingServiceWrite, this.userService, this.errorReporter, this.stringMessages, this.leaderboard.getName(), (Collection)this.sensorFixesDeviceIDs, this.sensorImporterType, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */).show();
        } else {
            this.continueWithMappedDevices();
        }
    }

    private void saveCompetitorSensorFixMapping(Collection<TypedDeviceMappingDTO> mappings) {
        new AddTypedDeviceMappingsToRegattaLog(this, this.leaderboard.getName(), mappings, () -> this.continueWithMappedDevices());
    }

    private final void continueWithMappedDevices() {
        ArrayList<RegattaNameAndRaceName> racesToStopAndStartTrackingFor = new ArrayList<RegattaNameAndRaceName>();
        ArrayList<Util.Triple> leaderboardRaceColumnFleetNames = new ArrayList<Util.Triple>();
        ArrayList<Util.Pair> raceNames = new ArrayList<Util.Pair>();
        for (Util.Triple race : this.raceEntries) {
            String raceName = (String)race.getA();
            String raceColumnName = (String)race.getB();
            String fleetName = (String)race.getC();
            racesToStopAndStartTrackingFor.add(new RegattaNameAndRaceName(this.regattaName, raceName));
            leaderboardRaceColumnFleetNames.add(new Util.Triple((Object)this.leaderboard.getName(), (Object)raceColumnName, (Object)fleetName));
            raceNames.add(new Util.Pair((Object)raceName, (Object)raceColumnName));
        }
        this.sailingServiceWrite.removeAndUntrackRaces(racesToStopAndStartTrackingFor, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ StringMessages access$0(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler) {
        return expeditionAllInOneAfterImportHandler.stringMessages;
    }

    static /* synthetic */ SailingServiceWriteAsync access$1(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler) {
        return expeditionAllInOneAfterImportHandler.sailingServiceWrite;
    }

    static /* synthetic */ StrippedLeaderboardDTO access$2(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler) {
        return expeditionAllInOneAfterImportHandler.leaderboard;
    }

    static /* synthetic */ void access$3(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler, Set set) {
        expeditionAllInOneAfterImportHandler.mapCompetitorsToGPSFixDeviceIds(set);
    }

    static /* synthetic */ ErrorReporter access$4(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler) {
        return expeditionAllInOneAfterImportHandler.errorReporter;
    }

    static /* synthetic */ void access$5(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler, RegattaDTO regattaDTO) {
        expeditionAllInOneAfterImportHandler.regatta = regattaDTO;
    }

    static /* synthetic */ void access$6(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler, StrippedLeaderboardDTO strippedLeaderboardDTO) {
        expeditionAllInOneAfterImportHandler.leaderboard = strippedLeaderboardDTO;
    }

    static /* synthetic */ void access$7(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler, List list) {
        expeditionAllInOneAfterImportHandler.gpsFixesDeviceIDs = list;
    }

    static /* synthetic */ void access$8(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler, List list) {
        expeditionAllInOneAfterImportHandler.sensorFixesDeviceIDs = list;
    }

    static /* synthetic */ void access$9(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler, Refresher refresher, Refresher refresher2) {
        expeditionAllInOneAfterImportHandler.showCompetitorRegistration(refresher, refresher2);
    }

    static /* synthetic */ void access$10(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler, Set set, Collection collection) {
        expeditionAllInOneAfterImportHandler.saveCompetitorGPSMapping(set, collection);
    }

    static /* synthetic */ void access$11(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler, Collection collection) {
        expeditionAllInOneAfterImportHandler.saveCompetitorSensorFixMapping(collection);
    }

    static /* synthetic */ RegattaDTO access$12(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler) {
        return expeditionAllInOneAfterImportHandler.regatta;
    }

    static /* synthetic */ String access$13(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler) {
        return expeditionAllInOneAfterImportHandler.leaderboardGroupName;
    }

    static /* synthetic */ UUID access$14(ExpeditionAllInOneAfterImportHandler expeditionAllInOneAfterImportHandler) {
        return expeditionAllInOneAfterImportHandler.leaderboardGroupId;
    }
}

