/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.adminconsole.CompactBoatTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.CompactCompetitorConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.CompactCompetitorTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorToBoatMappingsDialog;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.ImagesBarColumn;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.HashMap;
import java.util.Map;

public class CompetitorToBoatMappingsDialog
extends DataEntryDialog<Map<CompetitorDTO, BoatDTO>> {
    private final CompactCompetitorTableWrapper<RefreshableSingleSelectionModel<CompetitorDTO>> competitorTable;
    private final CompactBoatTableWrapper<RefreshableSingleSelectionModel<BoatDTO>> boatTable;
    private final RefreshableSelectionModel<BoatDTO> refreshableBoatSelectionModel;
    private final RefreshableSelectionModel<CompetitorDTO> refreshableCompetitorSelectionModel;
    private final StringMessages stringMessages;
    private final SelectionChangeEvent.Handler boatListHandler;
    private HandlerRegistration boatListHandlerRegistration;
    private final Map<CompetitorDTO, BoatDTO> competitorToBoatMappings;

    public CompetitorToBoatMappingsDialog(SailingServiceWriteAsync sailingServiceWrite, StringMessages stringMessages, ErrorReporter errorReporter, String leaderboardName, Map<CompetitorDTO, BoatDTO> competitorsAndBoats, DataEntryDialog.DialogCallback<Map<CompetitorDTO, BoatDTO>> callback, UserService userService) {
        super(stringMessages.actionEditCompetitorToBoatAssignments(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new CompetitorToBoatMappingValidator(), callback);
        this.stringMessages = stringMessages;
        this.competitorToBoatMappings = new HashMap<CompetitorDTO, BoatDTO>(competitorsAndBoats);
        this.competitorTable = new CompactCompetitorTableWrapper(sailingServiceWrite, stringMessages, errorReporter, false, true, userService);
        this.boatTable = new CompactBoatTableWrapper(sailingServiceWrite, stringMessages, errorReporter, false, true);
        this.boatTable.asWidget().ensureDebugId("competitorToBoatMappingBoatTable");
        ImagesBarColumn competitorActionColumn = new ImagesBarColumn((ImagesBarCell)new CompactCompetitorConfigImagesBarCell(stringMessages));
        competitorActionColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.competitorTable.addColumn((Column)competitorActionColumn, stringMessages.actions());
        this.competitorTable.asWidget().ensureDebugId("competitorToBoatMappingCompetitorTable");
        this.refreshableBoatSelectionModel = this.boatTable.getSelectionModel();
        this.refreshableCompetitorSelectionModel = this.competitorTable.getSelectionModel();
        this.boatListHandler = new /* Unavailable Anonymous Inner Class!! */;
        this.boatListHandlerRegistration = this.refreshableBoatSelectionModel.addSelectionChangeHandler(this.boatListHandler);
        this.refreshableCompetitorSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.competitorTable.refreshCompetitorList(this.competitorToBoatMappings);
        this.boatTable.refreshBoatList(leaderboardName);
    }

    private void linkBoatToSelectedCompetitor(CompetitorDTO selectedCompetitor, BoatDTO selectedBoat) {
        this.competitorToBoatMappings.put(selectedCompetitor, selectedBoat);
        this.competitorTable.refreshCompetitorList(this.competitorToBoatMappings);
        this.competitorTable.getDataProvider().refresh();
        this.competitorTable.getTable().redraw();
    }

    private void unlinkBoatFromCompetitor(CompetitorDTO selectedCompetitor) {
        this.competitorToBoatMappings.remove(selectedCompetitor);
        this.competitorToBoatMappings.put(selectedCompetitor, null);
        this.competitorTable.refreshCompetitorList(this.competitorToBoatMappings);
        ((RefreshableSingleSelectionModel)this.boatTable.getSelectionModel()).clear();
        this.competitorTable.getDataProvider().refresh();
        this.competitorTable.getTable().redraw();
    }

    private void competitorSelectionChanged() {
        CompetitorDTO selectedCompetitor = this.getSelectedCompetitor();
        if (selectedCompetitor != null) {
            this.selectBoatForCompetitor(selectedCompetitor);
        } else {
            ((RefreshableSingleSelectionModel)this.boatTable.getSelectionModel()).clear();
        }
    }

    private void selectBoatInList(BoatDTO boat) {
        this.boatTable.selectBoat(boat);
    }

    private void selectBoatForCompetitor(CompetitorDTO selectedCompetitor) {
        this.removeBoatListHandlerTemporarily();
        BoatDTO boatForCompetitor = (BoatDTO)this.competitorToBoatMappings.get(selectedCompetitor);
        if (boatForCompetitor != null) {
            this.selectBoatInList(boatForCompetitor);
        } else {
            this.boatTable.clearSelection();
        }
        this.boatTable.getTable().redraw();
    }

    private void removeBoatListHandlerTemporarily() {
        if (this.boatListHandlerRegistration == null) {
            return;
        }
        this.boatListHandlerRegistration.removeHandler();
        this.boatListHandlerRegistration = null;
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    private CompetitorDTO getSelectedCompetitor() {
        if (((RefreshableSingleSelectionModel)this.competitorTable.getSelectionModel()).getSelectedSet().isEmpty()) {
            return null;
        }
        return (CompetitorDTO)((RefreshableSingleSelectionModel)this.competitorTable.getSelectionModel()).getSelectedSet().iterator().next();
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel mainPanel = new VerticalPanel();
        CaptionPanel competitorsPanel = new CaptionPanel(this.stringMessages.competitors());
        competitorsPanel.ensureDebugId("CompetitorsSection");
        competitorsPanel.setContentWidget(this.competitorTable.asWidget());
        CaptionPanel boatsPanel = new CaptionPanel(this.stringMessages.boats());
        boatsPanel.ensureDebugId("BoatsSection");
        boatsPanel.setContentWidget(this.boatTable.asWidget());
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setSpacing(5);
        mainPanel.add((Widget)buttonPanel);
        Grid grid = new Grid(1, 2);
        grid.setWidget(0, 0, (Widget)competitorsPanel);
        grid.setWidget(0, 1, (Widget)boatsPanel);
        grid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_TOP);
        grid.getCellFormatter().setVerticalAlignment(0, 1, HasVerticalAlignment.ALIGN_TOP);
        mainPanel.add((Widget)grid);
        return mainPanel;
    }

    protected Map<CompetitorDTO, BoatDTO> getResult() {
        return this.competitorToBoatMappings;
    }

    static /* synthetic */ void access$1(CompetitorToBoatMappingsDialog competitorToBoatMappingsDialog, CompetitorDTO competitorDTO) {
        competitorToBoatMappingsDialog.unlinkBoatFromCompetitor(competitorDTO);
    }

    static /* synthetic */ void access$2(CompetitorToBoatMappingsDialog competitorToBoatMappingsDialog) {
        competitorToBoatMappingsDialog.validateAndUpdate();
    }

    static /* synthetic */ RefreshableSelectionModel access$3(CompetitorToBoatMappingsDialog competitorToBoatMappingsDialog) {
        return competitorToBoatMappingsDialog.refreshableBoatSelectionModel;
    }

    static /* synthetic */ CompetitorDTO access$4(CompetitorToBoatMappingsDialog competitorToBoatMappingsDialog) {
        return competitorToBoatMappingsDialog.getSelectedCompetitor();
    }

    static /* synthetic */ void access$5(CompetitorToBoatMappingsDialog competitorToBoatMappingsDialog, CompetitorDTO competitorDTO, BoatDTO boatDTO) {
        competitorToBoatMappingsDialog.linkBoatToSelectedCompetitor(competitorDTO, boatDTO);
    }

    static /* synthetic */ Map access$6(CompetitorToBoatMappingsDialog competitorToBoatMappingsDialog) {
        return competitorToBoatMappingsDialog.competitorToBoatMappings;
    }

    static /* synthetic */ void access$7(CompetitorToBoatMappingsDialog competitorToBoatMappingsDialog) {
        competitorToBoatMappingsDialog.removeBoatListHandlerTemporarily();
    }

    static /* synthetic */ void access$8(CompetitorToBoatMappingsDialog competitorToBoatMappingsDialog) {
        competitorToBoatMappingsDialog.competitorSelectionChanged();
    }

    static /* synthetic */ SelectionChangeEvent.Handler access$9(CompetitorToBoatMappingsDialog competitorToBoatMappingsDialog) {
        return competitorToBoatMappingsDialog.boatListHandler;
    }

    static /* synthetic */ void access$10(CompetitorToBoatMappingsDialog competitorToBoatMappingsDialog, HandlerRegistration handlerRegistration) {
        competitorToBoatMappingsDialog.boatListHandlerRegistration = handlerRegistration;
    }
}

