/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.server;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.gwt.home.communication.event.EventAndLeaderboardReferenceWithStateDTO;
import com.sap.sailing.gwt.home.communication.event.EventMetadataDTO;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventDTO;
import com.sap.sailing.gwt.home.communication.start.EventStageDTO;
import com.sap.sailing.gwt.home.communication.start.StageEventType;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.gwt.ui.client.shared.SailingVideoDTO;
import com.sap.sailing.gwt.ui.shared.EventLinkDTO;
import com.sap.sailing.gwt.ui.shared.EventReferenceDTO;
import com.sap.sailing.gwt.ui.shared.TrackingConnectorInfoDTO;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.util.EventUtil;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.VideoDTO;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import com.sap.sse.gwt.dispatch.shared.exceptions.ServerDispatchException;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.MediaDescriptor;
import com.sap.sse.shared.media.VideoDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public final class HomeServiceUtil {
    private static final Logger logger = Logger.getLogger(HomeServiceUtil.class.getName());
    private static final int MINIMUM_IMAGE_HEIGHT_FOR_SAILING_PHOTOGRAPHY_IN_PIXELS = 500;

    private HomeServiceUtil() {
    }

    public static String findEventThumbnailImageUrlAsString(EventBase event) {
        ImageDescriptor url = HomeServiceUtil.findEventThumbnailImage((EventBase)event);
        return url == null ? null : url.getURL().toString();
    }

    public static boolean isSingleRegatta(Event event) {
        boolean first = true;
        for (LeaderboardGroup lg : event.getLeaderboardGroups()) {
            for (Leaderboard lb : lg.getLeaderboards()) {
                if (!first) {
                    return false;
                }
                first = false;
            }
        }
        return true;
    }

    public static EventState calculateEventState(EventBase event) {
        TimePoint startDate = event.getStartDate();
        if (startDate == null) {
            return EventState.PLANNED;
        }
        TimePoint now = MillisecondsTimePoint.now();
        if (now.before(startDate)) {
            return event.isPublic() ? EventState.UPCOMING : EventState.PLANNED;
        }
        TimePoint endDate = event.getEndDate();
        if (endDate != null && now.after(endDate)) {
            return EventState.FINISHED;
        }
        return EventState.RUNNING;
    }

    public static VideoDTO toVideoDTO(VideoDescriptor video) {
        VideoDTO videoDTO = new VideoDTO(video.getURL().toString(), video.getMimeType(), video.getCreatedAtDate().asDate());
        HomeServiceUtil.fillVideoDTOFields((VideoDescriptor)video, (VideoDTO)videoDTO);
        return videoDTO;
    }

    public static SailingVideoDTO toSailingVideoDTO(EventReferenceDTO eventRef, VideoDescriptor video) {
        SailingVideoDTO videoDTO = new SailingVideoDTO(eventRef, video.getURL().toString(), video.getMimeType(), video.getCreatedAtDate().asDate());
        HomeServiceUtil.fillVideoDTOFields((VideoDescriptor)video, (VideoDTO)videoDTO);
        return videoDTO;
    }

    private static void fillVideoDTOFields(VideoDescriptor video, VideoDTO videoDTO) {
        videoDTO.setTitle(video.getTitle());
        videoDTO.setSubtitle(video.getSubtitle());
        videoDTO.setTags(video.getTags());
        videoDTO.setCopyright(video.getCopyright());
        videoDTO.setLocale(video.getLocale() != null ? video.getLocale().toString() : null);
        videoDTO.setLengthInSeconds(video.getLengthInSeconds());
        videoDTO.setThumbnailRef(video.getThumbnailURL() != null ? video.getThumbnailURL().toString() : null);
    }

    private static ImageDescriptor findEventThumbnailImage(EventBase event) {
        return event.findImageWithTag(MediaTagConstants.TEASER.getName());
    }

    public static ImageDescriptor getFeaturedImage(EventBase event) {
        return event.findImageWithTag(MediaTagConstants.FEATURED.getName());
    }

    public static String getFeaturedImageUrlAsString(EventBase event) {
        ImageDescriptor image = HomeServiceUtil.getFeaturedImage((EventBase)event);
        return image == null ? null : image.getURL().toString();
    }

    public static String getStageImageURLAsString(EventBase event) {
        ImageDescriptor image = HomeServiceUtil.getStageImage((EventBase)event);
        return image == null ? null : image.getURL().toString();
    }

    public static ImageDescriptor getStageImage(EventBase event) {
        return event.findImageWithTag(MediaTagConstants.STAGE.getName());
    }

    public static List<String> getPhotoGalleryImageURLsAsString(EventBase event) {
        List urls = HomeServiceUtil.getPhotoGalleryImages((EventBase)event);
        ArrayList<String> result = new ArrayList<String>(urls.size());
        for (ImageDescriptor url : urls) {
            result.add(url.getURL().toString());
        }
        return result;
    }

    public static List<ImageDescriptor> getPhotoGalleryImages(EventBase event) {
        return event.findImagesWithTag(MediaTagConstants.GALLERY.getName());
    }

    public static List<ImageDescriptor> getSailingLovesPhotographyImages(EventBase event) {
        LinkedList<ImageDescriptor> acceptedImages = new LinkedList<ImageDescriptor>();
        for (ImageDescriptor candidateImageUrl : event.getImages()) {
            if (!candidateImageUrl.hasSize() || candidateImageUrl.getHeightInPx() <= 500 || !candidateImageUrl.hasTag(MediaTagConstants.STAGE.getName()) && !candidateImageUrl.hasTag(MediaTagConstants.GALLERY.getName())) continue;
            acceptedImages.add(candidateImageUrl);
        }
        return acceptedImages;
    }

    public static int calculateCompetitorsCount(Leaderboard sl) {
        return Util.size((Iterable)sl.getCompetitors());
    }

    public static String getBoatClassName(Leaderboard leaderboard) {
        BoatClass boatClass = HomeServiceUtil.getBoatClass((Leaderboard)leaderboard);
        return boatClass == null ? null : boatClass.getName();
    }

    public static BoatClass getBoatClass(Leaderboard leaderboard) {
        RegattaLeaderboard regattaLeaderboard;
        BoatClass boatClassFromRegatta;
        if (leaderboard instanceof RegattaLeaderboard && (boatClassFromRegatta = (regattaLeaderboard = (RegattaLeaderboard)leaderboard).getRegatta().getBoatClass()) != null) {
            return boatClassFromRegatta;
        }
        return HomeServiceUtil.getBoatClassFromTrackedRaces((Leaderboard)leaderboard);
    }

    private static BoatClass getBoatClassFromTrackedRaces(Leaderboard leaderboard) {
        Iterator iterator = leaderboard.getTrackedRaces().iterator();
        if (iterator.hasNext()) {
            TrackedRace trackedRace = (TrackedRace)iterator.next();
            return trackedRace.getRace().getBoatClass();
        }
        return null;
    }

    public static boolean hasMedia(Event event) {
        return HomeServiceUtil.hasVideos((Event)event) || HomeServiceUtil.hasPhotos((Event)event);
    }

    public static boolean hasPhotos(Event event) {
        return event.hasImageWithTag(MediaTagConstants.GALLERY.getName());
    }

    public static boolean hasVideos(Event event) {
        return !Util.isEmpty((Iterable)event.getVideos());
    }

    public static VideoDescriptor getRandomVideo(Iterable<VideoDescriptor> urls) {
        if (Util.isEmpty(urls)) {
            return null;
        }
        int size = Util.size(urls);
        return (VideoDescriptor)Util.get(urls, (int)new Random(size).nextInt(size));
    }

    public static VideoDescriptor getStageVideo(Event event, Locale locale, Collection<String> rankedTags, boolean acceptOtherTags) {
        VideoDescriptor bestMatch = null;
        for (VideoDescriptor videoCandidate : event.getVideos()) {
            LocaleMatch localeMatch;
            if (!MediaTagConstants.SUPPORTED_VIDEO_TYPES.contains(videoCandidate.getMimeType()) || !acceptOtherTags && !HomeServiceUtil.hasOneTag((MediaDescriptor)videoCandidate, rankedTags) || (localeMatch = HomeServiceUtil.matchLocale((VideoDescriptor)videoCandidate, (Locale)locale)) == LocaleMatch.NO_MATCH) continue;
            if (bestMatch == null) {
                bestMatch = videoCandidate;
                continue;
            }
            int compareByTag = HomeServiceUtil.compareByTag((VideoDescriptor)videoCandidate, (VideoDescriptor)bestMatch, rankedTags);
            if (compareByTag <= 0 && (compareByTag != 0 || !HomeServiceUtil.isBetter((VideoDescriptor)videoCandidate, (VideoDescriptor)bestMatch, (Locale)locale))) continue;
            bestMatch = videoCandidate;
        }
        return bestMatch;
    }

    private static int compareByTag(VideoDescriptor videoCandidate, VideoDescriptor bestMatch, Collection<String> rankedTags) {
        for (String rankedTag : rankedTags) {
            boolean hasTagBestMatch;
            boolean hasTag = HomeServiceUtil.hasTag((MediaDescriptor)videoCandidate, (String)rankedTag);
            if (hasTag == (hasTagBestMatch = HomeServiceUtil.hasTag((MediaDescriptor)bestMatch, (String)rankedTag))) continue;
            return hasTag ? 1 : -1;
        }
        return 0;
    }

    private static boolean isBetter(VideoDescriptor candidate, VideoDescriptor reference, Locale locale) {
        LocaleMatch localeMatchRef;
        LocaleMatch localeMatch = HomeServiceUtil.matchLocale((VideoDescriptor)candidate, (Locale)locale);
        if (localeMatch != (localeMatchRef = HomeServiceUtil.matchLocale((VideoDescriptor)reference, (Locale)locale))) {
            return localeMatch.compareTo((Enum)localeMatchRef) < 0;
        }
        return candidate.getCreatedAtDate().compareTo((Object)reference.getCreatedAtDate()) > 0;
    }

    private static boolean hasTag(MediaDescriptor videoCandidate, String tag) {
        return Util.contains((Iterable)videoCandidate.getTags(), (Object)tag);
    }

    private static boolean hasOneTag(MediaDescriptor videoCandidate, Collection<String> acceptedTags) {
        for (String tag : videoCandidate.getTags()) {
            if (!acceptedTags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    private static LocaleMatch matchLocale(VideoDescriptor videoCandidate, Locale locale) {
        Locale localeOfCandidate = videoCandidate.getLocale();
        if (localeOfCandidate == null) {
            return LocaleMatch.NOT_TAGGED;
        }
        if (videoCandidate.getLocale().equals(locale)) {
            return LocaleMatch.PERFECT;
        }
        if (videoCandidate.getLocale().equals(Locale.ENGLISH)) {
            return LocaleMatch.EN_FALLBACK;
        }
        return LocaleMatch.NO_MATCH;
    }

    public static EventStageDTO convertToEventStageDTO(EventBase event, URL baseURL, boolean onRemoteServer, StageEventType stageType, RacingEventService service, boolean useTeaserImage) {
        EventStageDTO dto = new EventStageDTO();
        HomeServiceUtil.mapToMetadataDTO((EventBase)event, (EventMetadataDTO)dto);
        dto.setBaseURL(baseURL.toString());
        dto.setOnRemoteServer(onRemoteServer);
        dto.setStageType(stageType);
        Set trackingConnectorInfos = event.getTrackingConnectorInfos().stream().map(TrackingConnectorInfoDTO::new).collect(Collectors.toSet());
        dto.setTrackingConnectorInfos(trackingConnectorInfos);
        dto.setStageImageURL(useTeaserImage ? HomeServiceUtil.findEventThumbnailImageUrlAsString((EventBase)event) : HomeServiceUtil.getStageImageURLAsString((EventBase)event));
        return dto;
    }

    public static EventListEventDTO convertToEventListDTO(EventBase event, URL baseURL, boolean onRemoteServer) {
        EventListEventDTO dto = new EventListEventDTO();
        HomeServiceUtil.mapToMetadataDTO((EventBase)event, (EventMetadataDTO)dto);
        dto.setBaseURL(String.valueOf(baseURL));
        dto.setOnRemoteServer(onRemoteServer);
        return dto;
    }

    public static EventMetadataDTO convertToMetadataDTO(EventBase event) {
        EventMetadataDTO dto = new EventMetadataDTO();
        HomeServiceUtil.mapToMetadataDTO((EventBase)event, (EventMetadataDTO)dto);
        return dto;
    }

    public static EventLinkDTO convertToEventLinkDTO(EventBase event, URL baseURL, boolean onRemoteServer) {
        EventLinkDTO dto = new EventLinkDTO();
        HomeServiceUtil.mapToReferenceDTO((EventBase)event, (EventReferenceDTO)dto);
        dto.setBaseURL(String.valueOf(baseURL));
        dto.setOnRemoteServer(onRemoteServer);
        return dto;
    }

    public static void mapToMetadataDTO(EventBase event, EventMetadataDTO dto) {
        HomeServiceUtil.mapToReferenceDTO((EventBase)event, (EventReferenceDTO)dto);
        dto.setStartDate(event.getStartDate() == null ? null : event.getStartDate().asDate());
        dto.setEndDate(event.getEndDate() == null ? null : event.getEndDate().asDate());
        dto.setState(HomeServiceUtil.calculateEventState((EventBase)event));
        dto.setVenue(event.getVenue().getName());
        if (EventUtil.isFakeSeries((EventBase)event)) {
            dto.setLocation(HomeServiceUtil.getLocation((EventBase)event));
        }
        dto.setThumbnailImageURL(HomeServiceUtil.findEventThumbnailImageUrlAsString((EventBase)event));
    }

    private static void mapToReferenceDTO(EventBase event, EventReferenceDTO dto) {
        dto.setId((UUID)event.getId());
        dto.setDisplayName(HomeServiceUtil.getEventDisplayName((EventBase)event));
    }

    public static String getEventDisplayName(EventBase event) {
        String location;
        String seriesName;
        if (EventUtil.isFakeSeries((EventBase)event) && (seriesName = HomeServiceUtil.getSeriesName((EventBase)event)) != null && (location = HomeServiceUtil.getLocation((EventBase)event)) != null) {
            return String.valueOf(seriesName) + " - " + location;
        }
        return event.getName();
    }

    public static String getSeriesName(EventBase event) {
        LeaderboardGroupBase overallLeaderboardGroup = (LeaderboardGroupBase)event.getLeaderboardGroups().iterator().next();
        return HomeServiceUtil.getLeaderboardDisplayName((LeaderboardGroupBase)overallLeaderboardGroup);
    }

    public static String getLeaderboardDisplayName(LeaderboardGroupBase overallLeaderboardGroup) {
        return overallLeaderboardGroup.getDisplayName() != null ? overallLeaderboardGroup.getDisplayName() : overallLeaderboardGroup.getName();
    }

    public static String getLocation(EventBase eventBase) {
        if (!(eventBase instanceof Event)) {
            return null;
        }
        Event event = (Event)eventBase;
        String displayNameOfSingleAssociatedRegatta = null;
        for (Leaderboard leaderboard : ((LeaderboardGroup)event.getLeaderboardGroups().iterator().next()).getLeaderboards()) {
            if (!leaderboard.isPartOfEvent((EventBase)event)) continue;
            if (displayNameOfSingleAssociatedRegatta != null) {
                return null;
            }
            displayNameOfSingleAssociatedRegatta = HomeServiceUtil.getLocation((Event)event, (Leaderboard)leaderboard);
        }
        return displayNameOfSingleAssociatedRegatta;
    }

    public static String getLocation(Event eventBase, Leaderboard leaderboard) {
        return leaderboard.getDisplayName() != null ? leaderboard.getDisplayName() : leaderboard.getName();
    }

    public static ImageDTO convertToImageDTO(ImageDescriptor image) {
        ImageDTO result = new ImageDTO(image.getURL().toString(), image.getCreatedAtDate() != null ? image.getCreatedAtDate().asDate() : null);
        result.setCopyright(image.getCopyright());
        result.setTitle(image.getTitle());
        result.setSubtitle(image.getSubtitle());
        result.setMimeType(image.getMimeType());
        result.setSizeInPx(image.getWidthInPx(), image.getHeightInPx());
        result.setLocale(image.getLocale() != null ? image.getLocale().toString() : null);
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : image.getTags()) {
            tags.add(tag);
        }
        result.setTags(tags);
        return result;
    }

    public static String getCourseAreaNameForRegattaIfThereIsMoreThanOne(EventBase event, Leaderboard leaderboard) {
        Iterable courseAreas;
        String result = Util.size((Iterable)event.getVenue().getCourseAreas()) <= 1 ? null : (Util.isEmpty((Iterable)(courseAreas = leaderboard.getCourseAreas())) ? null : Util.join((String)", ", (Iterable)courseAreas));
        return result;
    }

    public static Iterable<String> getCourseAreaIdsAsStringsForRegatta(EventBase event, Leaderboard leaderboard) {
        return Util.map((Iterable)leaderboard.getCourseAreas(), ca -> ca.getId().toString());
    }

    public static void forAllPublicEventsWithReadPermission(RacingEventService service, HttpServletRequest request, SecurityService securityService, EventVisitor ... visitors) throws DispatchException {
        URL requestedBaseURL = HomeServiceUtil.getRequestBaseURL((HttpServletRequest)request);
        for (Event event : service.getAllEvents()) {
            if (!event.isPublic() || !securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)event)) continue;
            EventVisitor[] eventVisitorArray = visitors;
            int n = visitors.length;
            int n2 = 0;
            while (n2 < n) {
                EventVisitor visitor = eventVisitorArray[n2];
                visitor.visit((EventBase)event, false, requestedBaseURL);
                ++n2;
            }
        }
        for (Map.Entry entry : service.getPublicEventsOfAllSailingServers().entrySet()) {
            Util.Pair eventsOrException = (Util.Pair)entry.getValue();
            RemoteSailingServerReference serverRef = (RemoteSailingServerReference)entry.getKey();
            Iterable remoteEvents = (Iterable)eventsOrException.getA();
            URL baseURL = HomeServiceUtil.getBaseURL((URL)serverRef.getURL());
            if (remoteEvents == null) continue;
            for (EventBase remoteEvent : remoteEvents) {
                EventVisitor[] eventVisitorArray = visitors;
                int n = visitors.length;
                int n3 = 0;
                while (n3 < n) {
                    EventVisitor visitor = eventVisitorArray[n3];
                    visitor.visit(remoteEvent, true, baseURL);
                    ++n3;
                }
            }
        }
    }

    public static URL getRequestBaseURL(HttpServletRequest request) throws DispatchException {
        try {
            URL url = new URL(request.getRequestURL().toString());
            URL baseURL = HomeServiceUtil.getBaseURL((URL)url);
            return baseURL;
        }
        catch (MalformedURLException e) {
            throw new ServerDispatchException((Throwable)e);
        }
    }

    private static URL getBaseURL(URL url) throws DispatchException {
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), "");
        }
        catch (MalformedURLException e) {
            ServerDispatchException dispatchException = new ServerDispatchException((Throwable)e);
            logger.log(Level.SEVERE, "Uncaught server exception id: " + dispatchException.getExceptionId(), e);
            throw dispatchException;
        }
    }

    public static boolean hasRegattaData(EventBase event) {
        boolean fakeSeries = EventUtil.isFakeSeries((EventBase)event);
        for (LeaderboardGroupBase leaderboardGroupBase : event.getLeaderboardGroups()) {
            if (leaderboardGroupBase instanceof LeaderboardGroup) {
                LeaderboardGroup leaderboardGroup = (LeaderboardGroup)leaderboardGroupBase;
                for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                    if (fakeSeries && !leaderboard.isPartOfEvent(event)) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    public static List<Event> getEventsForSeriesInDescendingOrder(LeaderboardGroup overallLeaderboardGroup, RacingEventService service) {
        List eventsForSeriesOrdered = HomeServiceUtil.getEventsForSeriesOrdered((LeaderboardGroup)overallLeaderboardGroup, (RacingEventService)service);
        Collections.reverse(eventsForSeriesOrdered);
        return eventsForSeriesOrdered;
    }

    public static List<Event> getEventsForSeriesOrdered(LeaderboardGroup overallLeaderboardGroup, RacingEventService service) {
        return HomeServiceUtil.getEventsAndLeaderboardsForSeriesOrdered((LeaderboardGroup)overallLeaderboardGroup, (RacingEventService)service).stream().map(pair -> (Event)pair.getA()).distinct().collect(Collectors.toList());
    }

    public static List<Util.Pair<Event, Leaderboard>> getEventsAndLeaderboardsForSeriesOrdered(LeaderboardGroup overallLeaderboardGroup, RacingEventService service) {
        Iterable eventsInSeries = HomeServiceUtil.getEventsInSeries((LeaderboardGroup)overallLeaderboardGroup, (RacingEventService)service);
        Iterable orderedLeaderboards = HomeServiceUtil.getLeaderboardsForSeriesInOrderWithReadPermissions((LeaderboardGroup)overallLeaderboardGroup, (RacingEventService)service);
        ArrayList<Util.Pair<Event, Leaderboard>> orderedEventsInSeries = new ArrayList<Util.Pair<Event, Leaderboard>>();
        for (Leaderboard leaderboard : orderedLeaderboards) {
            Event associatedEvent = HomeServiceUtil.getAssociatedEventForLeaderboardInSeries((Leaderboard)leaderboard, (Iterable)eventsInSeries);
            if (associatedEvent == null) continue;
            orderedEventsInSeries.add((Util.Pair<Event, Leaderboard>)new Util.Pair((Object)associatedEvent, (Object)leaderboard));
        }
        return orderedEventsInSeries;
    }

    public static Iterable<Leaderboard> getLeaderboardsForSeriesInOrderWithReadPermissions(LeaderboardGroup overallLeaderboardGroup, RacingEventService service) {
        if (overallLeaderboardGroup.isDisplayGroupsInReverseOrder()) {
            ArrayList<Leaderboard> leaderboardsInSeries = new ArrayList<Leaderboard>();
            for (Leaderboard leaderboard : overallLeaderboardGroup.getLeaderboards()) {
                if (!service.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard)) continue;
                if (leaderboard instanceof RegattaLeaderboard) {
                    if (!service.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)((RegattaLeaderboard)leaderboard).getRegatta())) continue;
                    leaderboardsInSeries.add(leaderboard);
                    continue;
                }
                leaderboardsInSeries.add(leaderboard);
            }
            Collections.reverse(leaderboardsInSeries);
            return leaderboardsInSeries;
        }
        return overallLeaderboardGroup.getLeaderboards();
    }

    private static Event getAssociatedEventForLeaderboardInSeries(Leaderboard leaderboard, Iterable<Event> eventsInSeries) {
        for (Event event : eventsInSeries) {
            if (!Util.containsAny((Iterable)event.getVenue().getCourseAreas(), (Iterable)leaderboard.getCourseAreas())) continue;
            return event;
        }
        return null;
    }

    public static List<EventAndLeaderboardReferenceWithStateDTO> getEventAndLeaderboardReferencesForSeriesOrdered(LeaderboardGroup overallLeaderboardGroup, RacingEventService service) {
        ArrayList<EventAndLeaderboardReferenceWithStateDTO> eventsOfSeries = new ArrayList<EventAndLeaderboardReferenceWithStateDTO>();
        for (Util.Pair eventAndLeaderboardInSeries : HomeServiceUtil.getEventsAndLeaderboardsForSeriesOrdered((LeaderboardGroup)overallLeaderboardGroup, (RacingEventService)service)) {
            Leaderboard leaderboardInSeries;
            Event eventInSeries = (Event)eventAndLeaderboardInSeries.getA();
            String displayName = HomeServiceUtil.getLocation((Event)eventInSeries, (Leaderboard)(leaderboardInSeries = (Leaderboard)eventAndLeaderboardInSeries.getB()));
            if (displayName == null) {
                displayName = eventInSeries.getName();
            }
            EventState eventState = HomeServiceUtil.calculateEventState((EventBase)eventInSeries);
            eventsOfSeries.add(new EventAndLeaderboardReferenceWithStateDTO(eventInSeries.getId(), leaderboardInSeries.getName(), displayName, eventState));
        }
        return eventsOfSeries;
    }

    private static Iterable<Event> getEventsInSeries(LeaderboardGroup overallLeaderboardGroup, RacingEventService service) {
        HashSet<Event> eventsInSeries = new HashSet<Event>();
        for (Event event : service.getAllEvents()) {
            if (!service.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)event)) continue;
            for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
                if (!service.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroup) || !overallLeaderboardGroup.equals(leaderboardGroup)) continue;
                eventsInSeries.add(event);
            }
        }
        return eventsInSeries;
    }

    public static Event determineBestMatchingEvent(RacingEventService service, LeaderboardGroup leaderBoardGroup) {
        ArrayList events = new ArrayList(HomeServiceUtil.getEventsForSeriesOrdered((LeaderboardGroup)leaderBoardGroup, (RacingEventService)service));
        Collections.sort(events, new /* Unavailable Anonymous Inner Class!! */);
        return (Event)events.get(0);
    }
}

