/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.utils;

import com.google.gwt.user.client.Timer;
import com.sap.sailing.gwt.home.shared.utils.Countdown;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;

/*
 * Exception performing whole class analysis ignored.
 */
public class Countdown {
    private static final int WHOLE_DAYS_LIMIT = 3;
    private static final int UPDATE_INTERVALL_MILLIS = 1000;
    private final Timer timer;
    private final TimePoint zeroDate;
    private final CountdownListener countdownListener;
    private RemainingTime previousMajor;
    private RemainingTime previousMinor;

    public Countdown(TimePoint zeroDate, CountdownListener countdownListener, boolean dontSchedule) {
        this.zeroDate = zeroDate;
        this.countdownListener = countdownListener;
        this.update();
        this.timer = new /* Unavailable Anonymous Inner Class!! */;
        if (!dontSchedule) {
            this.timer.scheduleRepeating(1000);
        }
    }

    public Countdown(TimePoint zeroDate, CountdownListener countdownListener) {
        this(zeroDate, countdownListener, false);
    }

    private void update() {
        RemainingTime minor;
        RemainingTime major;
        Duration diff = MillisecondsTimePoint.now().until(this.zeroDate);
        if (diff.asMillis() < 0L) {
            diff = new MillisecondsDurationImpl(0L);
        }
        double asDays = diff.asDays();
        long wholeDaysRemaining = (long)asDays;
        double asHours = diff.asHours();
        long wholeHoursRemaining = (long)(asHours - (double)wholeDaysRemaining * 24.0);
        double asMinutes = diff.asMinutes();
        long wholeMinutesRemaining = (long)(asMinutes - (double)wholeHoursRemaining * 60.0);
        double asSeconds = diff.asSeconds();
        long wholeSecondsRemaining = (long)(asSeconds - (double)wholeMinutesRemaining * 60.0);
        if (wholeDaysRemaining > 0L) {
            major = new RemainingTime(wholeDaysRemaining, Unit.DAYS);
            minor = wholeDaysRemaining < 3L ? new RemainingTime(wholeHoursRemaining, Unit.HOURS) : null;
        } else if (wholeHoursRemaining > 0L) {
            major = new RemainingTime(wholeHoursRemaining, Unit.HOURS);
            minor = new RemainingTime(wholeMinutesRemaining, Unit.MINUTES);
        } else if (wholeMinutesRemaining > 0L) {
            major = new RemainingTime(wholeMinutesRemaining, Unit.MINUTES);
            minor = new RemainingTime(wholeSecondsRemaining, Unit.SECONDS);
        } else {
            major = new RemainingTime(wholeSecondsRemaining, Unit.SECONDS);
            minor = null;
        }
        if (!RemainingTime.equal((RemainingTime)this.previousMajor, (RemainingTime)major) || !RemainingTime.equal((RemainingTime)this.previousMinor, (RemainingTime)minor)) {
            this.countdownListener.changed(major, minor);
            this.previousMajor = major;
            this.previousMinor = minor;
        }
    }

    public void cancel() {
        this.timer.cancel();
    }

    static /* synthetic */ void access$0(Countdown countdown) {
        countdown.update();
    }
}

