/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.statistics;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.DataResource;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sailing.gwt.home.shared.partials.statistics.StatisticsBoxView;
import com.sap.sailing.gwt.ui.client.StringMessages;

public abstract class AbstractStatisticsBoxPresenter {
    private NumberFormat simpleFormat = NumberFormat.getFormat((String)"#0.0");
    private final StatisticsBoxView view;

    public AbstractStatisticsBoxPresenter(StatisticsBoxView view) {
        this.view = view;
    }

    public void addCompetitorItem(DataResource icon, String name, SimpleCompetitorDTO competitor) {
        if (competitor != null) {
            this.addItem(icon, name, (Object)(competitor.getShortInfo() != null ? competitor.getShortInfo() : competitor.getName()));
        }
    }

    public void addKnotsItem(DataResource icon, String name, Double speedInKnots) {
        if (speedInKnots != null) {
            this.addItem(icon, name, (Object)StringMessages.INSTANCE.knotsValue(speedInKnots.doubleValue()));
        }
    }

    public void addItemWithCompactFormat(DataResource icon, String name, Double payload) {
        if (payload != null && payload != 0.0) {
            this.addItem(icon, name, (Object)this.compactNumber(payload.doubleValue()));
        }
    }

    public void addItemWithCompactFormat(DataResource icon, String name, long payload) {
        if (payload != 0L) {
            this.addItem(icon, name, (Object)this.compactNumber(payload));
        }
    }

    public void addItemIfNotNull(DataResource icon, String name, Object payload) {
        if (payload != null || payload instanceof Number && ((Number)payload).longValue() != 0L) {
            this.addItem(icon, name, payload);
        }
    }

    private String compactNumber(double value) {
        if (value < 100.0) {
            return this.simpleFormat.format(value);
        }
        if (value < 100000.0) {
            return "" + Double.valueOf(value).intValue();
        }
        if (value < 1.0E8) {
            return StringMessages.INSTANCE.millionValue(value / 1000000.0);
        }
        return StringMessages.INSTANCE.billionValue(value / 1.0E9);
    }

    private String compactNumber(long value) {
        if (value < 100000L) {
            return "" + value;
        }
        if (value < 100000000L) {
            return StringMessages.INSTANCE.millionValue((double)value / 1000000.0);
        }
        return StringMessages.INSTANCE.billionValue((double)value / 1.0E9);
    }

    protected void clear() {
        this.view.clear();
    }

    protected void addItem(DataResource icon, String name, Object payload) {
        this.addItem(icon.getSafeUri().asString(), name, payload);
    }

    protected void addItem(String iconUrl, String name, Object payload) {
        this.view.addItem(iconUrl, name, payload);
    }
}

