/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.server;

import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sailing.gwt.home.server.EventActionUtil;
import com.sap.sailing.gwt.home.server.RaceContext;

public class OverallRacesStateCalculator
implements EventActionUtil.RaceCallback {
    private boolean hasLiveRace = false;
    private boolean hasFinishedRace = false;
    private boolean hasAbandonedOrPostponedRace = false;
    private boolean hasUnfinishedRace = false;

    public void doForRace(RaceContext context) {
        SimpleRaceMetadataDTO.RaceViewState raceViewState = context.getLiveRaceViewState();
        this.hasLiveRace |= raceViewState == SimpleRaceMetadataDTO.RaceViewState.RUNNING;
        this.hasFinishedRace |= raceViewState == SimpleRaceMetadataDTO.RaceViewState.FINISHED;
        this.hasAbandonedOrPostponedRace |= raceViewState == SimpleRaceMetadataDTO.RaceViewState.POSTPONED || raceViewState == SimpleRaceMetadataDTO.RaceViewState.ABANDONED;
        this.hasUnfinishedRace |= raceViewState != SimpleRaceMetadataDTO.RaceViewState.FINISHED && (context.getRegatta() == null || context.getRegatta().getEndDate() == null || context.getRegatta().getEndDate().after(context.getLiveTimePoint()));
    }

    public boolean hasLiveRace() {
        return this.hasLiveRace;
    }

    public boolean hasFinishedRace() {
        return this.hasFinishedRace;
    }

    public boolean hasUnfinishedRace() {
        return this.hasUnfinishedRace;
    }

    public boolean hasAbandonedOrPostponedRace() {
        return this.hasAbandonedOrPostponedRace;
    }
}

