/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.regattaheader;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.UIObject;
import com.sap.sailing.gwt.home.communication.event.LabelType;
import com.sap.sailing.gwt.home.communication.eventview.HasRegattaMetadata;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.desktop.partials.regattaheader.RegattaHeaderBody;
import com.sap.sailing.gwt.home.desktop.partials.regattaheader.RegattaHeaderResources;
import com.sap.sailing.gwt.home.shared.utils.LabelTypeUtil;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;

public class RegattaHeaderBody
extends UIObject {
    private static final StringMessages I18N = StringMessages.INSTANCE;
    private static RegattaHeaderBodyUiBinder uiBinder = (RegattaHeaderBodyUiBinder)GWT.create(RegattaHeaderBodyUiBinder.class);
    @UiField
    protected SpanElement nameUi;
    @UiField
    protected DivElement labelUi;
    @UiField
    protected DivElement detailsItemContainerUi;

    public RegattaHeaderBody(RegattaMetadataDTO regattaMetadata, boolean showStateMarker) {
        RegattaHeaderResources.INSTANCE.css().ensureInjected();
        this.setElement((Element)uiBinder.createAndBindUi((Object)this));
        this.nameUi.setInnerText(regattaMetadata.getDisplayName());
        HasRegattaMetadata.RegattaState state = regattaMetadata.getState();
        LabelTypeUtil.renderLabelTypeOrHide((Element)this.labelUi, (LabelType)(showStateMarker ? state.getStateMarker() : LabelType.NONE));
        this.addDetailsItem(regattaMetadata.getCompetitorsCount(), I18N.competitorsCount(regattaMetadata.getCompetitorsCount()));
        this.addDetailsItem(regattaMetadata.getRaceCount(), I18N.racesCount(regattaMetadata.getRaceCount()));
        String defaultCourseAreaName = regattaMetadata.getDefaultCourseAreaName();
        if (defaultCourseAreaName != null) {
            this.addDetailsItem(I18N.courseAreaName(defaultCourseAreaName));
        }
        if (regattaMetadata.getLeaderboardGroupNames() != null && !Util.isEmpty((Iterable)regattaMetadata.getLeaderboardGroupNames())) {
            this.addDetailsItem(Util.joinStrings((String)", ", (Iterable)regattaMetadata.getLeaderboardGroupNames()));
        }
        UIObject.ensureDebugId((Element)this.nameUi, (String)"RegattaNameSpan");
        UIObject.ensureDebugId((Element)this.labelUi, (String)"RegattaStateLabelDiv");
    }

    private void addDetailsItem(int count, String text) {
        if (count > 0) {
            this.addDetailsItem(text);
        }
    }

    private void addDetailsItem(String text) {
        if (text != null) {
            DivElement detailsItem = (DivElement)DOM.createDiv().cast();
            detailsItem.addClassName(RegattaHeaderResources.INSTANCE.css().regattaheader_content_details_item());
            detailsItem.setInnerText(text);
            this.detailsItemContainerUi.appendChild((Node)detailsItem);
        }
    }
}

