/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.search;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.LeaderboardSearchResultBase;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.search.SearchResultDTO;
import com.sap.sailing.server.interfaces.KeywordQueryWithOptionalEventQualification;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Util;
import com.sap.sse.common.search.Result;
import com.sap.sse.gwt.dispatch.client.system.batching.NonBatchableAction;
import com.sap.sse.gwt.dispatch.shared.commands.ListResult;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import com.sap.sse.gwt.shared.DTO;
import java.net.URL;
import java.util.Set;
import java.util.UUID;

public class GetSearchResultsAction
implements SailingAction<ListResult<SearchResultDTO>>,
NonBatchableAction {
    private String searchText;
    private String remoteServerName;

    private GetSearchResultsAction() {
    }

    public GetSearchResultsAction(String searchText) {
        this(searchText, null);
    }

    public GetSearchResultsAction(String searchText, String remoteServerName) {
        this.searchText = searchText;
        this.remoteServerName = remoteServerName;
    }

    @GwtIncompatible
    public ListResult<SearchResultDTO> execute(SailingDispatchContext ctx) throws DispatchException {
        ListResult result;
        RacingEventService service = ctx.getRacingEventService();
        Iterable splitAlongWhitespaceRespectingDoubleQuotedPhrases = Util.splitAlongWhitespaceRespectingDoubleQuotedPhrases((String)this.searchText);
        if (this.remoteServerName == null) {
            KeywordQueryWithOptionalEventQualification searchQuery = new KeywordQueryWithOptionalEventQualification(splitAlongWhitespaceRespectingDoubleQuotedPhrases);
            result = this.getListResult(service.search(searchQuery), ctx.getRequestBaseURL(), null, null, false);
        } else {
            RemoteSailingServerReference remoteServer = service.getRemoteServerReferenceByName(this.remoteServerName);
            KeywordQueryWithOptionalEventQualification searchQuery = new KeywordQueryWithOptionalEventQualification(splitAlongWhitespaceRespectingDoubleQuotedPhrases, remoteServer.isInclude(), (Iterable)remoteServer.getSelectedEventIds());
            result = this.getListResult(service.searchRemotely(this.remoteServerName, searchQuery), remoteServer.getURL(), Boolean.valueOf(remoteServer.isInclude()), remoteServer.getSelectedEventIds(), true);
        }
        return result;
    }

    @GwtIncompatible
    private <T extends LeaderboardSearchResultBase> ListResult<SearchResultDTO> getListResult(Result<T> result, URL baseUrl, Boolean include, Set<UUID> eventIds, boolean isOnRemoteServer) {
        ListResult resultList = new ListResult();
        if (result != null) {
            for (LeaderboardSearchResultBase hit : result.getHits()) {
                if (hit.getEvents() == null || Util.isEmpty((Iterable)hit.getEvents())) continue;
                resultList.addValue((DTO)new SearchResultDTO(hit, baseUrl, isOnRemoteServer, include, eventIds));
            }
        }
        return resultList;
    }
}

