/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.impl;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnectionFactory;
import com.sap.sailing.domain.igtimiadapter.impl.IgtimiWindTracker;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.WindTracker;
import com.sap.sailing.domain.tracking.WindTrackerFactory;
import com.sap.sse.security.SecurityService;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class IgtimiWindTrackerFactory
implements WindTrackerFactory {
    private static final Logger logger = Logger.getLogger(IgtimiWindTrackerFactory.class.getName());
    private final WeakHashMap<RaceDefinition, WindTracker> trackersForRace = new WeakHashMap();
    private final IgtimiConnectionFactory connectionFactory;

    public IgtimiWindTrackerFactory(IgtimiConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public WindTracker createWindTracker(DynamicTrackedRegatta trackedRegatta, RaceDefinition race, boolean correctByDeclination, SecurityService optionalSecurityService) throws Exception {
        DynamicTrackedRace trackedRace = trackedRegatta.getTrackedRace(race);
        IgtimiWindTracker windTracker = new IgtimiWindTracker(trackedRace, this, correctByDeclination, optionalSecurityService, this.connectionFactory);
        this.trackersForRace.put(race, windTracker);
        return windTracker;
    }

    public WindTracker getExistingWindTracker(RaceDefinition race) {
        return this.trackersForRace.get(race);
    }

    void windTrackerStopped(RaceDefinition race, IgtimiWindTracker igtimiWindTracker) {
        WindTracker removedTracker = this.trackersForRace.remove(race);
        if (removedTracker != igtimiWindTracker) {
            logger.warning("Expected to remove wind tracker " + (Object)((Object)igtimiWindTracker) + " but did remove " + removedTracker);
        }
    }

    WindSource getWindSource(String deviceSerialNumber) {
        return new WindSourceWithAdditionalID(WindSourceType.EXPEDITION, deviceSerialNumber);
    }
}

