/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.windimport.expedition;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.server.trackfiles.impl.ExpeditionExtendedDataImporterImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WindLogParser {
    private static final String COL_NAME_TRUE_WIND_SPEED = "tws";
    private static final String COL_NAME_TRUE_WIND_SPEED2 = "tw_speed";
    private static final String COL_NAME_TRUE_WIND_DIRECTION = "twd";
    private static final String COL_NAME_TRUE_WIND_DIRECTION2 = "tw_dirn";
    private static final String COL_NAME_LAT = "lat";
    private static final String COL_NAME_LON = "lon";

    public static Iterable<Wind> importWind(InputStream windStream) throws IOException {
        BufferedReader csvReader = new BufferedReader(new InputStreamReader(windStream));
        String headerLine = csvReader.readLine();
        ExpeditionExtendedDataImporterImpl importer = new ExpeditionExtendedDataImporterImpl();
        Map headers = importer.parseHeader(headerLine);
        ArrayList<Wind> result = new ArrayList<Wind>();
        WindBuffer windBuffer = new WindBuffer();
        AtomicInteger lineNr = new AtomicInteger(1);
        csvReader.lines().forEach(line -> {
            if (!line.trim().isEmpty()) {
                importer.parseLine((long)lineNr.incrementAndGet(), "Expedition Wind Import", line, headers, (timePoint, columnValues, headerDefinitions) -> {
                    String trueWindSpeedData;
                    windBuffer.updateTime(timePoint);
                    String string = headerDefinitions.containsKey(COL_NAME_TRUE_WIND_SPEED) && columnValues[(Integer)headerDefinitions.get(COL_NAME_TRUE_WIND_SPEED)] != null ? columnValues[(Integer)headerDefinitions.get(COL_NAME_TRUE_WIND_SPEED)] : (trueWindSpeedData = headerDefinitions.containsKey(COL_NAME_TRUE_WIND_SPEED2) ? columnValues[(Integer)headerDefinitions.get(COL_NAME_TRUE_WIND_SPEED2)] : null);
                    String trueWindDirectionData = headerDefinitions.containsKey(COL_NAME_TRUE_WIND_DIRECTION) && columnValues[(Integer)headerDefinitions.get(COL_NAME_TRUE_WIND_DIRECTION)] != null ? columnValues[(Integer)headerDefinitions.get(COL_NAME_TRUE_WIND_DIRECTION)] : (headerDefinitions.containsKey(COL_NAME_TRUE_WIND_DIRECTION2) ? columnValues[(Integer)headerDefinitions.get(COL_NAME_TRUE_WIND_DIRECTION2)] : null);
                    windBuffer.updateWindData(trueWindSpeedData, trueWindDirectionData);
                    windBuffer.updatePosition(columnValues[(Integer)headerDefinitions.get(COL_NAME_LAT)], columnValues[(Integer)headerDefinitions.get(COL_NAME_LON)]);
                    Wind wind = windBuffer.createWindIfReady();
                    if (wind != null) {
                        result.add(wind);
                    }
                });
            }
        });
        return result;
    }

    private static class WindBuffer {
        private TimePoint timePoint;
        private Position position;
        private SpeedWithBearing trueWindSpeedWithBearing;

        private WindBuffer() {
        }

        public void updateTime(TimePoint timePoint) {
            if (timePoint != null) {
                this.timePoint = timePoint;
            }
        }

        public void updateWindData(String trueWindSpeedData, String trueWindDirectionData) {
            if (!trueWindSpeedData.trim().isEmpty() && !trueWindDirectionData.trim().isEmpty()) {
                double trueWindSpeed = Double.parseDouble(trueWindSpeedData);
                double trueWindDirection = Double.parseDouble(trueWindDirectionData);
                DegreeBearingImpl trueWindBearing = new DegreeBearingImpl(trueWindDirection + 180.0);
                this.trueWindSpeedWithBearing = new KnotSpeedWithBearingImpl(trueWindSpeed, (Bearing)trueWindBearing);
            }
        }

        public void updatePosition(String latData, String lonData) {
            if (!latData.trim().isEmpty() && !lonData.trim().isEmpty()) {
                double lat = Double.parseDouble(latData);
                double lon = Double.parseDouble(lonData);
                this.position = new DegreePosition(lat, lon);
            }
        }

        public Wind createWindIfReady() {
            if (this.timePoint != null && this.position != null && this.trueWindSpeedWithBearing != null) {
                WindImpl result = new WindImpl(this.position, this.timePoint, this.trueWindSpeedWithBearing);
                this.reset();
                return result;
            }
            return null;
        }

        private void reset() {
            this.timePoint = null;
            this.position = null;
            this.trueWindSpeedWithBearing = null;
        }
    }
}

