/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.landscape.common.SharedLandscapeConstants;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.ConcurrentHashBag;
import com.sap.sse.security.util.RemoteServerUtil;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;

@Path(value="/v1/compareservers")
public class CompareServersResource
extends AbstractSailingServerResource {
    public static final String V1_COMPARESERVERS = "/v1/compareservers";
    public static final Logger logger = Logger.getLogger(CompareServersResource.class.getName());
    private static final String LEADERBOARDGROUPSPATH = "/sailingserver/api/v1/leaderboardgroups";
    private static final String LEADERBOARDGROUPSIDENTIFIABLEPATH = "/sailingserver/api/v1/leaderboardgroups/identifiable";
    public static final String SERVER1_FORM_PARAM = "server1";
    public static final String SERVER2_FORM_PARAM = "server2";
    public static final String USER1_FORM_PARAM = "user1";
    public static final String USER2_FORM_PARAM = "user2";
    public static final String PASSWORD1_FORM_PARAM = "password1";
    public static final String PASSWORD2_FORM_PARAM = "password2";
    public static final String BEARER1_FORM_PARAM = "bearer1";
    public static final String BEARER2_FORM_PARAM = "bearer2";
    public static final String LEADERBOARDGROUP_UUID_FORM_PARAM = "leaderboardgroupUUID[]";
    private static final String[] KEYLISTTOCOMPARE = new String[]{"id", "description", "events", "leaderboards", "displayName", "isMetaLeaderboard", "isRegattaLeaderboard", "scoringComment", "lastScoringUpdate", "scoringScheme", "regattaName", "discardIndexResultsStartingWithHowManyRaces", "series", "isMedalSeries", "fleets", "color", "ordering", "races", "isMedalRace", "isTracked", "regattaName", "trackedRaceName", "hasGpsData", "hasWindData", "name"};
    private static final Set<String> KEYSETTOCOMPARE = new HashSet<String>(Arrays.asList(KEYLISTTOCOMPARE));
    private static final String[] KEYSTOIGNORE = new String[]{".timepoint", ".timepoint-ms", ".leaderboards[].series[].fleets[].races[].raceViewerUrls"};
    private static final Set<String> KEYSETTOIGNORE = new HashSet<String>(Arrays.asList(KEYSTOIGNORE));
    private static final String[] KEYSTOPRINT = new String[]{"id"};
    private static final Set<String> KEYSETTOPRINT = new HashSet<String>(Arrays.asList(KEYSTOPRINT));
    private static final String SERVERTOOOLD = "At least one server you are trying to compare has not yet enabled the /sailingserver/api/v1/leaderboardgroups/identifiable endpoint and therefore you need to fallback to running the compareServers shell script.";
    @Context
    UriInfo uriInfo;

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response compareServers(@FormParam(value="server1") String server1, @FormParam(value="server2") String server2, @FormParam(value="leaderboardgroupUUID[]") Set<String> uuidset, @FormParam(value="user1") String user1, @FormParam(value="user2") String user2, @FormParam(value="password1") String password1, @FormParam(value="password2") String password2, @FormParam(value="bearer1") String bearer1, @FormParam(value="bearer2") String bearer2) throws MalformedURLException {
        HashMap result = new HashMap();
        Response response = null;
        String effectiveServer1 = !Util.hasLength((String)server1) ? this.uriInfo.getBaseUri().getAuthority() : server1;
        URL url1 = RemoteServerUtil.createBaseUrl((String)effectiveServer1);
        URL url2 = RemoteServerUtil.createBaseUrl((String)server2);
        if (!SharedLandscapeConstants.isTrustedDomain((String)url1.getHost())) {
            response = this.badRequest("Untrusted domain for " + url1);
        } else if (!SharedLandscapeConstants.isTrustedDomain((String)url2.getHost())) {
            response = this.badRequest("Untrusted domain for " + url2);
        } else if (!this.validateParameters(server2, uuidset, user1, user2, password1, password2, bearer1, bearer2)) {
            response = this.badRequest("Specify two trusted server names and optionally a set of valid leaderboardgroup UUIDs.");
        } else {
            String token1 = this.getSecurityService().getOrCreateTargetServerBearerToken(effectiveServer1, user1, password1, bearer1);
            String token2 = this.getSecurityService().getOrCreateTargetServerBearerToken(server2, user2, password2, bearer2);
            result.put(effectiveServer1, new HashSet());
            result.put(server2, new HashSet());
            try {
                if (!uuidset.isEmpty()) {
                    for (String uuid : uuidset) {
                        Util.Pair<Object, Object> jsonPair = this.fetchLeaderboardgroupDetailsAndRemoveDuplicates(effectiveServer1, server2, uuid, token1, token2);
                        if (jsonPair.getA() == null || jsonPair.getB() == null) continue;
                        ((Set)result.get(effectiveServer1)).add(jsonPair.getA());
                        ((Set)result.get(server2)).add(jsonPair.getB());
                    }
                } else {
                    JSONArray leaderboardgroupList1 = this.getLeaderboardgroupList(effectiveServer1, token1);
                    JSONArray leaderboardgroupList2 = this.getLeaderboardgroupList(server2, token2);
                    for (Object lg1 : leaderboardgroupList1) {
                        if (!leaderboardgroupList2.contains(lg1)) {
                            ((Set)result.get(effectiveServer1)).add(lg1);
                            continue;
                        }
                        String lgId = ((JSONObject)lg1).get((Object)"id").toString();
                        Util.Pair<Object, Object> jsonPair = this.fetchLeaderboardgroupDetailsAndRemoveDuplicates(effectiveServer1, server2, lgId, token1, token2);
                        if (jsonPair.getA() == null || jsonPair.getB() == null) continue;
                        ((Set)result.get(effectiveServer1)).add(jsonPair.getA());
                        ((Set)result.get(server2)).add(jsonPair.getB());
                    }
                    for (Object lg2 : leaderboardgroupList2) {
                        if (leaderboardgroupList1.contains(lg2)) continue;
                        ((Set)result.get(server2)).add(lg2);
                    }
                }
                JSONObject json = new JSONObject();
                for (Map.Entry entry : result.entrySet()) {
                    json.put(entry.getKey(), entry.getValue());
                }
                response = ((Set)result.get(effectiveServer1)).isEmpty() && ((Set)result.get(server2)).isEmpty() ? Response.ok((Object)this.streamingOutput(json)).build() : Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.streamingOutput(json)).build();
            }
            catch (FileNotFoundException e) {
                response = Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.toString()).build();
                logger.warning(e.toString());
            }
            catch (ConnectException e) {
                response = Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.toString()).build();
                logger.warning(e.toString());
            }
            catch (Exception e) {
                response = this.returnInternalServerError(e);
            }
        }
        return response;
    }

    private boolean validateParameters(String server2, Set<String> uuidset, String user1, String user2, String password1, String password2, String bearer1, String bearer2) {
        boolean result = this.validateAuthenticationParameters(user1, password1, bearer1) && this.validateAuthenticationParameters(user2, password2, bearer2) && this.validateParameters(server2, uuidset);
        return result;
    }

    private boolean validateParameters(String server2, Set<String> uuidset) {
        boolean result = Util.hasLength((String)server2);
        for (String uuid : uuidset) {
            if (!Util.hasLength((String)uuid) || UUID.fromString(uuid).toString().equals(uuid)) continue;
            result = false;
            break;
        }
        return result;
    }

    private Util.Pair<Object, Object> fetchLeaderboardgroupDetailsAndRemoveDuplicates(String server1, String server2, String leaderboardgroupId, String bearer1, String bearer2) throws Exception {
        JSONObject lgdetail1 = this.getLeaderboardgroupDetailsById(leaderboardgroupId, RemoteServerUtil.createBaseUrl((String)server1), bearer1);
        JSONObject lgdetail2 = this.getLeaderboardgroupDetailsById(leaderboardgroupId, RemoteServerUtil.createBaseUrl((String)server2), bearer2);
        Util.Pair<Object, Object> result = this.removeUnnecessaryAndDuplicateFields((JSONAware)lgdetail1, (JSONAware)lgdetail2);
        return result;
    }

    Util.Pair<Object, Object> removeUnnecessaryAndDuplicateFields(JSONAware lgdetail1, JSONAware lgdetail2) {
        this.removeUnnecessaryFields(lgdetail1);
        this.removeUnnecessaryFields(lgdetail2);
        Util.Pair<Object, Object> result = this.removeDuplicateEntries(lgdetail1, lgdetail2);
        return result;
    }

    private JSONArray getLeaderboardgroupList(String server, String bearer) throws Exception {
        JSONParser parser = new JSONParser();
        URL baseUrl = RemoteServerUtil.createBaseUrl((String)server);
        URLConnection leaderboardgroupListC = HttpUrlConnectionHelper.redirectConnectionWithBearerToken((URL)RemoteServerUtil.createRemoteServerUrl((URL)baseUrl, (String)LEADERBOARDGROUPSIDENTIFIABLEPATH, null), (String)bearer);
        if (((HttpURLConnection)leaderboardgroupListC).getResponseCode() == 404) {
            throw new FileNotFoundException(SERVERTOOOLD);
        }
        JSONArray result = (JSONArray)parser.parse((Reader)new InputStreamReader(leaderboardgroupListC.getInputStream(), "UTF-8"));
        return result;
    }

    private JSONObject getLeaderboardgroupDetailsById(String leaderboardgroupId, URL baseUrl, String bearer) throws Exception {
        URLConnection lgdetails = HttpUrlConnectionHelper.redirectConnectionWithBearerToken((URL)RemoteServerUtil.createRemoteServerUrl((URL)baseUrl, (String)this.createLgDetailPath(leaderboardgroupId), null), (String)bearer);
        JSONObject result = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(lgdetails.getInputStream(), "UTF-8"));
        return result;
    }

    private String createLgDetailPath(String leaderboardgroupId) throws URISyntaxException {
        StringBuilder lgdetailpath = new StringBuilder(LEADERBOARDGROUPSPATH);
        lgdetailpath.append("/");
        lgdetailpath.append(leaderboardgroupId);
        String result = lgdetailpath.toString();
        return result;
    }

    private void removeUnnecessaryFields(JSONAware json) {
        this.removeUnnecessaryFields(json, "");
    }

    private void removeUnnecessaryFields(Object json, String path) {
        block4: {
            block3: {
                if (!(json instanceof JSONObject)) break block3;
                Iterator iter = ((JSONObject)json).keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    String nextPath = String.valueOf(path) + "." + key;
                    if (KEYSETTOIGNORE.contains(nextPath) || !KEYSETTOCOMPARE.contains(key)) {
                        iter.remove();
                        continue;
                    }
                    Object value = ((JSONObject)json).get(key);
                    this.removeUnnecessaryFields(value, nextPath);
                }
                break block4;
            }
            if (!(json instanceof JSONArray)) break block4;
            String nextPath = String.valueOf(path) + "[]";
            int i = 0;
            while (i < ((JSONArray)json).size()) {
                this.removeUnnecessaryFields(((JSONArray)json).get(i), nextPath);
                ++i;
            }
        }
    }

    private Util.Pair<Object, Object> removeDuplicateEntries(Object lg1, Object lg2) {
        Util.Pair result;
        if (this.equalsWithArrayOrderIgnored(lg1, lg2)) {
            result = new Util.Pair(null, null);
        } else {
            if (lg1 instanceof JSONObject && lg2 instanceof JSONObject) {
                this.removeDuplicateEntries((JSONObject)lg1, (JSONObject)lg2);
            } else if (lg1 instanceof JSONArray && lg2 instanceof JSONArray) {
                this.removeDuplicateEntries((JSONArray)lg1, (JSONArray)lg2);
            }
            result = new Util.Pair(lg1, lg2);
        }
        return result;
    }

    boolean equalsWithArrayOrderIgnored(Object a, Object b) {
        boolean result;
        if (a == b || Util.equalsWithNull((Object)a, (Object)b)) {
            result = true;
        } else if (a instanceof JSONArray && b instanceof JSONArray) {
            ConcurrentHashBag aBag = new ConcurrentHashBag();
            for (Object aObject : (JSONArray)a) {
                aBag.add(aObject);
            }
            ConcurrentHashBag bBag = new ConcurrentHashBag();
            for (Object bObject : (JSONArray)b) {
                bBag.add(bObject);
            }
            result = aBag.equals((Object)bBag);
        } else if (a instanceof JSONObject && b instanceof JSONObject) {
            if (((JSONObject)a).keySet().equals(((JSONObject)b).keySet())) {
                boolean allValuesRecursivelyEqual = true;
                for (Object aKey : ((JSONObject)a).keySet()) {
                    if (this.equalsWithArrayOrderIgnored(((JSONObject)a).get(aKey), ((JSONObject)b).get(aKey))) continue;
                    allValuesRecursivelyEqual = false;
                    break;
                }
                result = allValuesRecursivelyEqual;
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    private void removeDuplicateEntries(JSONObject jsonObject1, JSONObject jsonObject2) {
        if (!jsonObject1.containsKey((Object)"name") && !jsonObject2.containsKey((Object)"name") || Util.equalsWithNull((Object)jsonObject1.get((Object)"name"), (Object)jsonObject2.get((Object)"name"))) {
            Iterator iter1 = jsonObject1.keySet().iterator();
            while (iter1.hasNext()) {
                Object key = iter1.next();
                if (!jsonObject2.containsKey(key)) continue;
                Object value1 = jsonObject1.get(key);
                Object value2 = jsonObject2.get(key);
                if (KEYSETTOPRINT.contains(key) && this.equalsWithArrayOrderIgnored(value1, value2)) continue;
                if (!key.equals("name") && this.equalsWithArrayOrderIgnored(value1, value2) && KEYSETTOCOMPARE.contains(key)) {
                    iter1.remove();
                    jsonObject2.remove(key);
                    continue;
                }
                this.removeDuplicateEntries(value1, value2);
            }
        }
    }

    private void removeDuplicateEntries(JSONArray json1, JSONArray json2) {
        if (this.equalsWithArrayOrderIgnored(json1, json2)) {
            json1.clear();
            json2.clear();
        } else {
            Map<String, JSONObject> jsonObjects1KeyedByName = this.getJsonObjectsByName(json1);
            Map<String, JSONObject> jsonObjects2KeyedByName = this.getJsonObjectsByName(json2);
            int i = 0;
            while (i < json1.size()) {
                String name;
                JSONObject item2;
                if (jsonObjects1KeyedByName == null || jsonObjects2KeyedByName == null) {
                    if (i < json2.size()) {
                        if (this.equalsWithArrayOrderIgnored(json1.get(i), json2.get(i))) {
                            json1.remove(i);
                            json2.remove(i);
                            continue;
                        }
                        this.removeDuplicateEntries(json1.get(i), json2.get(i));
                        ++i;
                        continue;
                    }
                    ++i;
                    continue;
                }
                JSONObject item1 = (JSONObject)json1.get(i);
                if (this.equalsWithArrayOrderIgnored(item1, item2 = jsonObjects2KeyedByName.get(name = item1.get((Object)"name").toString()))) {
                    json1.remove(i);
                    json2.remove((Object)item2);
                    continue;
                }
                if (item1 != null && item2 != null) {
                    this.removeDuplicateEntries(item1, item2);
                }
                ++i;
            }
        }
    }

    private Map<String, JSONObject> getJsonObjectsByName(JSONArray jsonArray) {
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        for (Object o : jsonArray) {
            if (!(o instanceof JSONObject) || !((JSONObject)o).containsKey((Object)"name")) continue;
            result.put(((JSONObject)o).get((Object)"name").toString(), (JSONObject)o);
        }
        return result.size() == jsonArray.size() ? result : null;
    }
}

