/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl.rc;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.gateway.AbstractJsonHttpServlet;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorAndBoatJsonSerializer;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CompetitorsAndBoatsJsonExportServlet
extends AbstractJsonHttpServlet {
    private static final long serialVersionUID = 4510175441769759252L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String leaderboardName = request.getParameter("leaderboard");
        if (leaderboardName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "leaderboard"));
            return;
        }
        String raceColumnName = request.getParameter("race_column");
        if (raceColumnName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "race_column"));
            return;
        }
        String fleetName = request.getParameter("fleet");
        if (fleetName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "fleet"));
            return;
        }
        RacingEventService service = this.getService();
        Leaderboard leaderboard = service.getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            response.sendError(404, "No such leaderboard found.");
            return;
        }
        SecurityUtils.getSubject().checkPermission(leaderboard.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ));
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            response.sendError(404, "No such race column found.");
            return;
        }
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            response.sendError(404, "No such fleet found.");
            return;
        }
        JSONArray result = new JSONArray();
        TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
        if (trackedRace != null) {
            SecurityUtils.getSubject().checkPermission(trackedRace.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ));
        }
        for (Competitor competitor : leaderboard.getCompetitors(raceColumn, fleet)) {
            Boat boat = leaderboard.getBoatOfCompetitor(competitor, raceColumn, fleet);
            if (!this.getSecurityService().hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS) || !this.getSecurityService().hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)boat, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS)) continue;
            CompetitorAndBoatJsonSerializer competitorsAndBoatsSerializer = CompetitorAndBoatJsonSerializer.create((boolean)this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)competitor));
            JSONObject serializeCompetitorAndBoat = competitorsAndBoatsSerializer.serialize(new Util.Pair((Object)competitor, (Object)boat));
            result.add((Object)serializeCompetitorAndBoat);
        }
        this.setJsonResponseHeader(response);
        result.writeJSONString((Writer)response.getWriter());
    }
}

