/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.util;

import com.sap.sse.common.Util;
import java.util.Arrays;
import java.util.function.Supplier;

public class CubicSpline {
    private final double[] _x;
    private final double[] _c0;
    private final double[] _c1;
    private final double[] _c2;
    private final double[] _c3;
    private static final double EPSILON = 1.0E-12;
    Supplier<double[]> _indefiniteIntegral;

    private static boolean almostEqual(double d1, double d2) {
        return CubicSpline.almostEqual(d1, d2, 1.0E-12);
    }

    private static boolean almostEqual(double d1, double d2, double epsilon) {
        return Math.abs(d1 - d2) <= epsilon;
    }

    public CubicSpline(double[] x, double[] c0, double[] c1, double[] c2, double[] c3) {
        if (x.length != c0.length + 1 || x.length != c1.length + 1 || x.length != c2.length + 1 || x.length != c3.length + 1) {
            throw new IllegalArgumentException("Argument vectors must have same length");
        }
        if (x.length < 2) {
            throw new IllegalArgumentException("Array too small, must be at least two but was " + x.length);
        }
        this._x = x;
        this._c0 = c0;
        this._c1 = c1;
        this._c2 = c2;
        this._c3 = c3;
        this._indefiniteIntegral = this::computeIndefiniteIntegral;
    }

    public static CubicSpline interpolateHermiteSorted(double[] x, double[] y, double[] firstDerivatives) {
        if (x.length != y.length || x.length != firstDerivatives.length) {
            throw new IllegalArgumentException("Argument vectors must have same length");
        }
        if (x.length < 2) {
            throw new IllegalArgumentException("Array too small, must be at least two but was " + x.length);
        }
        double[] c0 = new double[x.length - 1];
        double[] c1 = new double[x.length - 1];
        double[] c2 = new double[x.length - 1];
        double[] c3 = new double[x.length - 1];
        int i = 0;
        while (i < c1.length) {
            double w = x[i + 1] - x[i];
            double w2 = w * w;
            c0[i] = y[i];
            c1[i] = firstDerivatives[i];
            c2[i] = (3.0 * (y[i + 1] - y[i]) / w - 2.0 * firstDerivatives[i] - firstDerivatives[i + 1]) / w;
            c3[i] = (2.0 * (y[i] - y[i + 1]) / w + firstDerivatives[i] + firstDerivatives[i + 1]) / w2;
            ++i;
        }
        return new CubicSpline(x, c0, c1, c2, c3);
    }

    public static CubicSpline InterpolateHermiteInplace(double[] x, double[] y, double[] firstDerivatives) {
        if (x.length != y.length || x.length != firstDerivatives.length) {
            throw new IllegalArgumentException("Argument vectors must have same length");
        }
        if (x.length < 2) {
            throw new IllegalArgumentException("Array too small, must be at least two but was " + x.length);
        }
        Util.sort(x, y, firstDerivatives);
        return CubicSpline.interpolateHermiteSorted(x, y, firstDerivatives);
    }

    public static CubicSpline interpolateAkimaSorted(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Argument vectors must have same length");
        }
        if (x.length < 5) {
            throw new IllegalArgumentException("Array too small, must be at least five but was " + x.length);
        }
        double[] diff = new double[x.length - 1];
        double[] weights = new double[x.length - 1];
        int i = 0;
        while (i < diff.length) {
            diff[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]);
            ++i;
        }
        i = 1;
        while (i < weights.length) {
            weights[i] = Math.abs(diff[i] - diff[i - 1]);
            ++i;
        }
        double[] dd = new double[x.length];
        int i2 = 2;
        while (i2 < dd.length - 2) {
            dd[i2] = CubicSpline.almostEqual(weights[i2 - 1], 0.0) && CubicSpline.almostEqual(weights[i2 + 1], 0.0) ? ((x[i2 + 1] - x[i2]) * diff[i2 - 1] + (x[i2] - x[i2 - 1]) * diff[i2]) / (x[i2 + 1] - x[i2 - 1]) : (weights[i2 + 1] * diff[i2 - 1] + weights[i2 - 1] * diff[i2]) / (weights[i2 + 1] + weights[i2 - 1]);
            ++i2;
        }
        dd[0] = CubicSpline.differentiateThreePoint(x, y, 0, 0, 1, 2);
        dd[1] = CubicSpline.differentiateThreePoint(x, y, 1, 0, 1, 2);
        dd[x.length - 2] = CubicSpline.differentiateThreePoint(x, y, x.length - 2, x.length - 3, x.length - 2, x.length - 1);
        dd[x.length - 1] = CubicSpline.differentiateThreePoint(x, y, x.length - 1, x.length - 3, x.length - 2, x.length - 1);
        return CubicSpline.interpolateHermiteSorted(x, y, dd);
    }

    public static CubicSpline interpolateAkimaInplace(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Argument vectors must have same length");
        }
        Util.sort(x, new double[][]{y});
        return CubicSpline.interpolateAkimaSorted(x, y);
    }

    public static CubicSpline interpolateBoundariesSorted(double[] x, double[] y, SplineBoundaryCondition leftBoundaryCondition, double leftBoundary, SplineBoundaryCondition rightBoundaryCondition, double rightBoundary) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Argument vectors must have same length");
        }
        if (x.length < 2) {
            throw new IllegalArgumentException("Array too small, must be at least two but was " + x.length);
        }
        int n = x.length;
        if (n == 2 && leftBoundaryCondition == SplineBoundaryCondition.ParabolicallyTerminated && rightBoundaryCondition == SplineBoundaryCondition.ParabolicallyTerminated) {
            leftBoundaryCondition = SplineBoundaryCondition.SecondDerivative;
            leftBoundary = 0.0;
            rightBoundaryCondition = SplineBoundaryCondition.SecondDerivative;
            rightBoundary = 0.0;
        }
        if (leftBoundaryCondition == SplineBoundaryCondition.Natural) {
            leftBoundaryCondition = SplineBoundaryCondition.SecondDerivative;
            leftBoundary = 0.0;
        }
        if (rightBoundaryCondition == SplineBoundaryCondition.Natural) {
            rightBoundaryCondition = SplineBoundaryCondition.SecondDerivative;
            rightBoundary = 0.0;
        }
        double[] a1 = new double[n];
        double[] a2 = new double[n];
        double[] a3 = new double[n];
        double[] b = new double[n];
        switch (leftBoundaryCondition) {
            case ParabolicallyTerminated: {
                a1[0] = 0.0;
                a2[0] = 1.0;
                a3[0] = 1.0;
                b[0] = 2.0 * (y[1] - y[0]) / (x[1] - x[0]);
                break;
            }
            case FirstDerivative: {
                a1[0] = 0.0;
                a2[0] = 1.0;
                a3[0] = 0.0;
                b[0] = leftBoundary;
                break;
            }
            case SecondDerivative: {
                a1[0] = 0.0;
                a2[0] = 2.0;
                a3[0] = 1.0;
                b[0] = 3.0 * ((y[1] - y[0]) / (x[1] - x[0])) - 0.5 * leftBoundary * (x[1] - x[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid Left Boundary Condition " + (Object)((Object)leftBoundaryCondition));
            }
        }
        int i = 1;
        while (i < x.length - 1) {
            a1[i] = x[i + 1] - x[i];
            a2[i] = 2.0 * (x[i + 1] - x[i - 1]);
            a3[i] = x[i] - x[i - 1];
            b[i] = 3.0 * (y[i] - y[i - 1]) / (x[i] - x[i - 1]) * (x[i + 1] - x[i]) + 3.0 * (y[i + 1] - y[i]) / (x[i + 1] - x[i]) * (x[i] - x[i - 1]);
            ++i;
        }
        switch (rightBoundaryCondition) {
            case ParabolicallyTerminated: {
                a1[n - 1] = 1.0;
                a2[n - 1] = 1.0;
                a3[n - 1] = 0.0;
                b[n - 1] = 2.0 * (y[n - 1] - y[n - 2]) / (x[n - 1] - x[n - 2]);
                break;
            }
            case FirstDerivative: {
                a1[n - 1] = 0.0;
                a2[n - 1] = 1.0;
                a3[n - 1] = 0.0;
                b[n - 1] = rightBoundary;
                break;
            }
            case SecondDerivative: {
                a1[n - 1] = 1.0;
                a2[n - 1] = 2.0;
                a3[n - 1] = 0.0;
                b[n - 1] = 3.0 * (y[n - 1] - y[n - 2]) / (x[n - 1] - x[n - 2]) + 0.5 * rightBoundary * (x[n - 1] - x[n - 2]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid Right Boundary Condition " + (Object)((Object)rightBoundaryCondition));
            }
        }
        double[] dd = CubicSpline.solveTridiagonal(a1, a2, a3, b);
        return CubicSpline.interpolateHermiteSorted(x, y, dd);
    }

    public static CubicSpline interpolateNaturalSorted(double[] x, double[] y) {
        return CubicSpline.interpolateBoundariesSorted(x, y, SplineBoundaryCondition.SecondDerivative, 0.0, SplineBoundaryCondition.SecondDerivative, 0.0);
    }

    private static double differentiateThreePoint(double[] xx, double[] yy, int indexT, int index0, int index1, int index2) {
        double x0 = yy[index0];
        double x1 = yy[index1];
        double x2 = yy[index2];
        double t = xx[indexT] - xx[index0];
        double t1 = xx[index1] - xx[index0];
        double t2 = xx[index2] - xx[index0];
        double a = (x2 - x0 - t2 / t1 * (x1 - x0)) / (t2 * t2 - t1 * t2);
        double b = (x1 - x0 - a * t1 * t1) / t1;
        return 2.0 * a * t + b;
    }

    private static double[] solveTridiagonal(double[] a, double[] b, double[] c, double[] d) {
        int k = 1;
        while (k < a.length) {
            double t = a[k] / b[k - 1];
            b[k] = b[k] - t * c[k - 1];
            d[k] = d[k] - t * d[k - 1];
            ++k;
        }
        double[] x = new double[a.length];
        x[x.length - 1] = d[d.length - 1] / b[b.length - 1];
        int k2 = x.length - 2;
        while (k2 >= 0) {
            x[k2] = (d[k2] - c[k2] * x[k2 + 1]) / b[k2];
            --k2;
        }
        return x;
    }

    public double interpolate(double t) {
        int k = this.leftSegmentIndex(t);
        double x = t - this._x[k];
        return this._c0[k] + x * (this._c1[k] + x * (this._c2[k] + x * this._c3[k]));
    }

    public double differentiate(double t) {
        int k = this.leftSegmentIndex(t);
        double x = t - this._x[k];
        return this._c1[k] + x * (2.0 * this._c2[k] + x * 3.0 * this._c3[k]);
    }

    public double differentiate2(double t) {
        int k = this.leftSegmentIndex(t);
        double x = t - this._x[k];
        return 2.0 * this._c2[k] + x * 6.0 * this._c3[k];
    }

    public double integrate(double t) {
        int k = this.leftSegmentIndex(t);
        double x = t - this._x[k];
        return this._indefiniteIntegral.get()[k] + x * (this._c0[k] + x * (this._c1[k] / 2.0 + x * (this._c2[k] / 3.0 + x * this._c3[k] / 4.0)));
    }

    public double integrate(double a, double b) {
        return this.integrate(b) - this.integrate(a);
    }

    private double[] computeIndefiniteIntegral() {
        double[] integral = new double[this._c1.length];
        int i = 0;
        while (i < integral.length - 1) {
            double w = this._x[i + 1] - this._x[i];
            integral[i + 1] = integral[i] + w * (this._c0[i] + w * (this._c1[i] / 2.0 + w * (this._c2[i] / 3.0 + w * this._c3[i] / 4.0)));
            ++i;
        }
        return integral;
    }

    private int leftSegmentIndex(double t) {
        int index = Arrays.binarySearch(this._x, t);
        if (index < 0) {
            index = ~index - 1;
        }
        return Math.min(Math.max(index, 0), this._x.length - 2);
    }

    public static enum SplineBoundaryCondition {
        Natural,
        ParabolicallyTerminated,
        FirstDerivative,
        SecondDerivative;

    }
}

