/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRaceOperation;
import java.util.logging.Logger;

public class UpdateRaceDelayToLive
extends AbstractRaceOperation<Void> {
    private static final long serialVersionUID = -4759501337499106614L;
    private static final Logger logger = Logger.getLogger(UpdateRaceDelayToLive.class.getName());
    private final long delayToLiveInMillis;

    public UpdateRaceDelayToLive(RegattaAndRaceIdentifier raceIdentifier, long delayToLiveInMillis) {
        super(raceIdentifier);
        this.delayToLiveInMillis = delayToLiveInMillis;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        DynamicTrackedRace trackedRace = toState.getExistingTrackedRace(this.getRaceIdentifier());
        if (trackedRace != null) {
            trackedRace.setAndFixDelayToLiveInMillis(this.delayToLiveInMillis);
        } else {
            logger.warning("Tracked race for " + this.getRaceIdentifier() + " has disappeared");
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

