/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRacingEventServiceOperation;
import java.util.logging.Logger;

public class RemoveSeries
extends AbstractRacingEventServiceOperation<Void> {
    private static final long serialVersionUID = -2232723085937305299L;
    private static final Logger logger = Logger.getLogger(RemoveSeries.class.getName());
    private final RegattaIdentifier regattaIdentifier;
    private final String seriesName;

    public RemoveSeries(RegattaIdentifier identifier, String seriesName) {
        this.regattaIdentifier = identifier;
        this.seriesName = seriesName;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        Regatta regatta = toState.getRegatta(this.regattaIdentifier);
        if (regatta != null) {
            Series series = regatta.getSeriesByName(this.seriesName);
            if (series != null) {
                toState.removeSeries(series);
            } else {
                logger.warning("Could not find series " + this.seriesName);
            }
        } else {
            logger.warning("Couldn't find regatta " + this.regattaIdentifier);
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

