/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRacingEventServiceOperation;
import com.sap.sse.common.Util;
import java.util.ArrayList;

public class AllowBoatResetToDefaults
extends AbstractRacingEventServiceOperation<Void> {
    private static final long serialVersionUID = -3698113910122095903L;
    private final Iterable<String> boatIdsAsStrings;

    public AllowBoatResetToDefaults(Iterable<String> boatIdsAsStrings) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.boatIdsAsStrings = arrayList;
        Util.addAll(boatIdsAsStrings, arrayList);
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        CompetitorAndBoatStore competitorAndBoatStore = toState.getBaseDomainFactory().getCompetitorAndBoatStore();
        for (String boatIdAsString : this.boatIdsAsStrings) {
            DynamicBoat boat = competitorAndBoatStore.getExistingBoatByIdAsString(boatIdAsString);
            if (boat == null) continue;
            competitorAndBoatStore.allowBoatResetToDefaults(boat);
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

