/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.AbstractRacingEventServiceOperation;
import java.util.logging.Logger;

public abstract class AbstractSeriesOperation<ResultType>
extends AbstractRacingEventServiceOperation<ResultType> {
    private static final long serialVersionUID = -7786133902346491275L;
    private static final Logger logger = Logger.getLogger(AbstractSeriesOperation.class.getName());
    private final RegattaIdentifier regattaIdentifier;
    private final String seriesName;

    public AbstractSeriesOperation(RegattaIdentifier regattaIdentifier, String seriesName) {
        this.regattaIdentifier = regattaIdentifier;
        this.seriesName = seriesName;
    }

    protected RegattaIdentifier getRegattaIdentifier() {
        return this.regattaIdentifier;
    }

    protected String getSeriesName() {
        return this.seriesName;
    }

    protected Series getSeries(RacingEventService toState) {
        Series series = null;
        Regatta regatta = toState.getRegatta(this.getRegattaIdentifier());
        if (regatta != null) {
            series = regatta.getSeriesByName(this.getSeriesName());
            if (series == null) {
                logger.warning("series " + this.getSeriesName() + " not found in regatta " + regatta.getName());
            }
        } else {
            logger.warning("regatta " + this.getRegattaIdentifier() + " not found");
        }
        return series;
    }
}

