/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.interfaces;

import com.sap.sailing.competitorimport.CompetitorProvider;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.anniversary.DetailedRaceInfo;
import com.sap.sailing.domain.anniversary.SimpleRaceInfo;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.LeaderboardSearchResult;
import com.sap.sailing.domain.base.LeaderboardSearchResultBase;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.RegattaRegistry;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.base.SailingServerConfiguration;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.common.CompetitorDescriptor;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.domain.common.DataImportSubProgress;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RaceFetcher;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaFetcher;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.WindFinderReviewedSpotsCollectionIdProvider;
import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.domain.common.impl.MasterDataImportObjectCreationCountImpl;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.domain.common.racelog.tracking.DoesNotHaveRegattaLogException;
import com.sap.sailing.domain.common.racelog.tracking.MarkAlreadyUsedInRaceException;
import com.sap.sailing.domain.leaderboard.EventResolver;
import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.leaderboard.LeaderboardRegistry;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithEliminations;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithOtherTieBreakingLeaderboard;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprintRegistry;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelog.tracking.SensorFixStoreSupplier;
import com.sap.sailing.domain.ranking.RankingMetricConstructor;
import com.sap.sailing.domain.regattalike.LeaderboardThatHasRegattaLike;
import com.sap.sailing.domain.resultimport.ResultUrlProvider;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.statistics.Statistics;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParametersHandler;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.TrackerManager;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.server.interfaces.AnniversaryRaceDeterminator;
import com.sap.sailing.server.interfaces.CourseAndMarkConfigurationFactory;
import com.sap.sailing.server.interfaces.DataImportLockWithProgress;
import com.sap.sailing.server.interfaces.KeywordQueryWithOptionalEventQualification;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.interfaces.SimulationService;
import com.sap.sailing.server.interfaces.TaggingService;
import com.sap.sse.common.Distance;
import com.sap.sse.common.PairingListCreationException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.search.Result;
import com.sap.sse.common.search.Searchable;
import com.sap.sse.filestorage.FileStorageManagementService;
import com.sap.sse.pairinglist.PairingList;
import com.sap.sse.pairinglist.PairingListTemplate;
import com.sap.sse.replication.ReplicableWithObjectInputStream;
import com.sap.sse.security.SecurityService;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.VideoDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.shiro.authz.UnauthorizedException;

public interface RacingEventService
extends TrackedRegattaRegistry,
RegattaFetcher,
RegattaRegistry,
MarkPassingRaceFingerprintRegistry,
ManeuverRaceFingerprintRegistry,
RaceFetcher,
LeaderboardRegistry,
EventResolver,
LeaderboardGroupResolver,
TrackerManager,
Searchable<LeaderboardSearchResult, KeywordQueryWithOptionalEventQualification>,
ReplicableWithObjectInputStream<RacingEventService, RacingEventServiceOperation<?>>,
RaceLogAndTrackedRaceResolver,
SensorFixStoreSupplier,
WindFinderReviewedSpotsCollectionIdProvider {
    public Regatta getRegatta(RegattaName var1);

    public RaceDefinition getRace(RegattaAndRaceIdentifier var1);

    public DynamicTrackedRace getTrackedRace(Regatta var1, RaceDefinition var2);

    public DynamicTrackedRace getTrackedRace(RegattaAndRaceIdentifier var1);

    public Iterable<TrackedRace> getAllTrackedRacesForEventTrackingAt(Event var1, TimePoint var2);

    public Map<String, Leaderboard> getLeaderboards();

    public Leaderboard getLeaderboardByName(String var1);

    public Position getMarkPosition(Mark var1, LeaderboardThatHasRegattaLike var2, TimePoint var3);

    public void stopTracking(Regatta var1, boolean var2) throws MalformedURLException, IOException, InterruptedException;

    public void startTrackingWind(Regatta var1, RaceDefinition var2, boolean var3);

    public void stopTrackingWind(Regatta var1, RaceDefinition var2) throws SocketException, IOException;

    public Iterable<Util.Triple<Regatta, RaceDefinition, String>> getWindTrackedRaces();

    public FlexibleLeaderboard addFlexibleLeaderboard(String var1, String var2, int[] var3, ScoringScheme var4, Iterable<? extends Serializable> var5);

    public RegattaLeaderboard addRegattaLeaderboard(RegattaIdentifier var1, String var2, int[] var3);

    public RegattaLeaderboardWithEliminations addRegattaLeaderboardWithEliminations(String var1, String var2, RegattaLeaderboard var3);

    public RegattaLeaderboardWithOtherTieBreakingLeaderboard addRegattaLeaderboardWithOtherTieBreakingLeaderboard(RegattaIdentifier var1, String var2, int[] var3, RegattaLeaderboard var4);

    public void removeLeaderboard(String var1);

    public RaceColumn addColumnToLeaderboard(String var1, String var2, boolean var3);

    public void moveLeaderboardColumnUp(String var1, String var2);

    public void moveLeaderboardColumnDown(String var1, String var2);

    public void removeLeaderboardColumn(String var1, String var2);

    public void renameLeaderboardColumn(String var1, String var2, String var3);

    public void updateLeaderboardColumnFactor(String var1, String var2, Double var3);

    public void updateStoredLeaderboard(Leaderboard var1);

    public void updateStoredRegatta(Regatta var1);

    public void stopTrackingAndRemove(Regatta var1) throws MalformedURLException, IOException, InterruptedException;

    public void removeRegatta(Regatta var1) throws MalformedURLException, IOException, InterruptedException;

    public void removeSeries(Series var1) throws MalformedURLException, IOException, InterruptedException;

    public DynamicTrackedRace getExistingTrackedRace(RegattaAndRaceIdentifier var1);

    public Map<UUID, LeaderboardGroup> getLeaderboardGroups();

    public LeaderboardGroup addLeaderboardGroup(UUID var1, String var2, String var3, String var4, boolean var5, List<String> var6, int[] var7, ScoringSchemeType var8);

    public void removeLeaderboardGroup(UUID var1);

    public void updateStoredLeaderboardGroup(LeaderboardGroup var1);

    public DynamicTrackedRace createTrackedRace(RegattaAndRaceIdentifier var1, WindStore var2, long var3, long var5, long var7, boolean var9, TrackingConnectorInfo var10);

    default public Regatta createRegatta(String regattaName, String boatClassName, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, String registrationLinkSecret, TimePoint startDate, TimePoint endDate, Serializable id, Iterable<? extends Series> series, boolean persistent, ScoringScheme scoringScheme, Serializable courseAreaId, Double buoyZoneRadiusInHullLengths, boolean useStartTimeInference, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, RankingMetricConstructor rankingMetricConstructor) {
        return this.createRegatta(regattaName, boatClassName, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, registrationLinkSecret, startDate, endDate, id, series, persistent, scoringScheme, courseAreaId == null ? Collections.emptySet() : Collections.singleton(courseAreaId), buoyZoneRadiusInHullLengths, useStartTimeInference, controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange, rankingMetricConstructor);
    }

    public Regatta createRegatta(String var1, String var2, boolean var3, CompetitorRegistrationType var4, String var5, TimePoint var6, TimePoint var7, Serializable var8, Iterable<? extends Series> var9, boolean var10, ScoringScheme var11, Iterable<? extends Serializable> var12, Double var13, boolean var14, boolean var15, boolean var16, RankingMetricConstructor var17);

    public Regatta updateRegatta(RegattaIdentifier var1, TimePoint var2, TimePoint var3, Iterable<? extends Serializable> var4, RegattaConfiguration var5, Iterable<? extends Series> var6, Double var7, boolean var8, boolean var9, boolean var10, String var11, CompetitorRegistrationType var12);

    public void addRace(RegattaIdentifier var1, RaceDefinition var2);

    public void updateLeaderboardGroup(UUID var1, String var2, String var3, String var4, List<String> var5, int[] var6, ScoringSchemeType var7);

    public Iterable<Event> getAllEvents();

    public Iterable<Regatta> getRegattasSelectively(boolean var1, Iterable<UUID> var2);

    public Iterable<Event> getEventsSelectively(boolean var1, Iterable<UUID> var2);

    public Event addEvent(String var1, String var2, TimePoint var3, TimePoint var4, String var5, boolean var6, UUID var7);

    public void updateEvent(UUID var1, String var2, String var3, TimePoint var4, TimePoint var5, String var6, boolean var7, Iterable<UUID> var8, URL var9, URL var10, Map<Locale, URL> var11, Iterable<ImageDescriptor> var12, Iterable<VideoDescriptor> var13, Iterable<String> var14);

    public void renameEvent(UUID var1, String var2);

    public void removeEvent(UUID var1);

    public Map<RemoteSailingServerReference, Util.Pair<Iterable<EventBase>, Exception>> getPublicEventsOfAllSailingServers();

    public RemoteSailingServerReference addRemoteSailingServerReference(String var1, URL var2, boolean var3);

    public RemoteSailingServerReference updateRemoteSailingServerReference(String var1, boolean var2, Set<UUID> var3);

    public void removeRemoteSailingServerReference(String var1);

    public CourseArea[] addCourseAreas(UUID var1, String[] var2, UUID[] var3, Position[] var4, Distance[] var5);

    public DomainFactory getBaseDomainFactory();

    public CourseArea getCourseArea(Serializable var1);

    public void mediaTrackAdded(MediaTrack var1);

    public void mediaTracksAdded(Iterable<MediaTrack> var1);

    public void mediaTrackTitleChanged(MediaTrack var1);

    public void mediaTrackUrlChanged(MediaTrack var1);

    public void mediaTrackStartTimeChanged(MediaTrack var1);

    public void mediaTrackDurationChanged(MediaTrack var1);

    public void mediaTrackAssignedRacesChanged(MediaTrack var1);

    public void mediaTrackDeleted(MediaTrack var1);

    public void mediaTracksImported(Iterable<MediaTrack> var1, MasterDataImportObjectCreationCountImpl var2, boolean var3) throws Exception;

    public Iterable<MediaTrack> getMediaTracksForRace(RegattaAndRaceIdentifier var1);

    public Iterable<MediaTrack> getMediaTracksInTimeRange(RegattaAndRaceIdentifier var1);

    public Iterable<MediaTrack> getAllMediaTracks();

    public Iterable<URL> getResultImportUrls(String var1) throws UnauthorizedException;

    public void removeResultImportURLs(String var1, Set<URL> var2) throws UnauthorizedException, Exception;

    public void addResultImportUrl(String var1, URL var2) throws UnauthorizedException, Exception;

    public Optional<ResultUrlProvider> getUrlBasedScoreCorrectionProvider(String var1);

    public void reloadRaceLog(String var1, String var2, String var3);

    public RaceLog getRaceLog(String var1, String var2, String var3);

    public Map<Competitor, Boat> getCompetitorToBoatMappingsForRace(String var1, String var2, String var3);

    public Util.Pair<Regatta, Boolean> getOrCreateRegattaWithoutReplication(String var1, String var2, boolean var3, CompetitorRegistrationType var4, String var5, TimePoint var6, TimePoint var7, Serializable var8, Iterable<? extends Series> var9, boolean var10, ScoringScheme var11, Iterable<? extends Serializable> var12, Double var13, boolean var14, boolean var15, boolean var16, RankingMetricConstructor var17);

    public ConcurrentHashMap<String, Regatta> getPersistentRegattasForRaceIDs();

    public Event createEventWithoutReplication(String var1, String var2, TimePoint var3, TimePoint var4, String var5, boolean var6, UUID var7, URL var8, URL var9, Map<Locale, URL> var10, Iterable<ImageDescriptor> var11, Iterable<VideoDescriptor> var12);

    public void setRegattaForRace(Regatta var1, String var2);

    public CourseArea[] addCourseAreasWithoutReplication(UUID var1, UUID[] var2, String[] var3, Position[] var4, Distance[] var5);

    public CourseArea[] removeCourseAreaWithoutReplication(UUID var1, UUID[] var2);

    public DeviceConfiguration getDeviceConfigurationById(UUID var1);

    public DeviceConfiguration getDeviceConfigurationByName(String var1);

    public void createOrUpdateDeviceConfiguration(DeviceConfiguration var1);

    public void removeDeviceConfiguration(UUID var1);

    public Iterable<DeviceConfiguration> getAllDeviceConfigurations();

    public TimePoint setStartTimeAndProcedure(String var1, String var2, String var3, String var4, int var5, int var6, TimePoint var7, TimePoint var8, RacingProcedureType var9, UUID var10);

    public TimePoint setEndTime(String var1, String var2, String var3, String var4, int var5, int var6, TimePoint var7);

    public TimePoint setFinishingTime(String var1, String var2, String var3, String var4, Integer var5, int var6, MillisecondsTimePoint var7);

    public Util.Triple<TimePoint, Integer, RacingProcedureType> getStartTimeAndProcedure(String var1, String var2, String var3);

    public Util.Triple<TimePoint, TimePoint, Integer> getFinishingAndFinishTime(String var1, String var2, String var3);

    public MongoObjectFactory getMongoObjectFactory();

    public DomainObjectFactory getDomainObjectFactory();

    public WindStore getWindStore();

    public PolarDataService getPolarDataService();

    public SimulationService getSimulationService();

    public TaggingService getTaggingService();

    public RaceTracker getRaceTrackerById(Object var1);

    public AbstractLogEventAuthor getServerAuthor();

    public CompetitorAndBoatStore getCompetitorAndBoatStore();

    public TypeBasedServiceFinderFactory getTypeBasedServiceFinderFactory();

    public DataImportLockWithProgress getDataImportLock();

    public DataImportProgress createOrUpdateDataImportProgressWithReplication(UUID var1, double var2, DataImportSubProgress var4, double var5);

    public DataImportProgress createOrUpdateDataImportProgressWithoutReplication(UUID var1, double var2, DataImportSubProgress var4, double var5);

    public void setDataImportFailedWithReplication(UUID var1, String var2);

    public void setDataImportFailedWithoutReplication(UUID var1, String var2);

    public void setDataImportDeleteProgressFromMapTimerWithReplication(UUID var1);

    public void setDataImportDeleteProgressFromMapTimerWithoutReplication(UUID var1);

    public Util.Pair<Iterable<EventBase>, Exception> updateRemoteServerEventCacheSynchronously(RemoteSailingServerReference var1, boolean var2);

    public Util.Pair<Iterable<EventBase>, Exception> getCompleteRemoteServerReference(RemoteSailingServerReference var1);

    public Result<LeaderboardSearchResult> search(KeywordQueryWithOptionalEventQualification var1);

    public Result<LeaderboardSearchResultBase> searchRemotely(String var1, KeywordQueryWithOptionalEventQualification var2);

    public SailingServerConfiguration getSailingServerConfiguration();

    public void updateServerConfiguration(SailingServerConfiguration var1);

    public Iterable<RemoteSailingServerReference> getLiveRemoteServerReferences();

    public Map<String, RemoteSailingServerReference> getAllRemoteServerReferences();

    public RemoteSailingServerReference getRemoteServerReferenceByName(String var1);

    public RemoteSailingServerReference getRemoteServerReferenceByUrl(URL var1);

    public void addRegattaWithoutReplication(Regatta var1);

    public void addEventWithoutReplication(Event var1);

    public void addLeaderboardGroupWithoutReplication(LeaderboardGroup var1);

    public FileStorageManagementService getFileStorageManagementService();

    public void getRaceTrackerByRegattaAndRaceIdentifier(RegattaAndRaceIdentifier var1, Consumer<RaceTracker> var2);

    public long getNumberOfTrackedRacesToRestore();

    public int getNumberOfTrackedRacesRestored();

    public Map<Integer, Statistics> getLocalStatisticsByYear();

    public Map<Integer, Statistics> getOverallStatisticsByYear();

    public Map<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>> getRemoteRaceList(Predicate<UUID> var1);

    public Map<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>> getLocalRaceList(Predicate<UUID> var1);

    public DetailedRaceInfo getFullDetailsForRaceCascading(RegattaAndRaceIdentifier var1);

    public DetailedRaceInfo getFullDetailsForRaceLocal(RegattaAndRaceIdentifier var1);

    public Util.Pair<Integer, AnniversaryType> getNextAnniversary();

    public int getCurrentRaceCount();

    public Map<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> getKnownAnniversaries();

    public AnniversaryRaceDeterminator getAnniversaryRaceDeterminator();

    public PairingListTemplate createPairingListTemplate(int var1, int var2, int var3, int var4, int var5);

    public PairingList<RaceColumn, Fleet, Competitor, Boat> getPairingListFromTemplate(PairingListTemplate var1, String var2, Iterable<RaceColumn> var3) throws PairingListCreationException;

    public DynamicCompetitorWithBoat convertCompetitorDescriptorToCompetitorWithBoat(CompetitorDescriptor var1, String var2);

    public SecurityService getSecurityService();

    default public boolean skipChecksDueToCorrectSecret(String leaderboardName, String secret) {
        boolean result;
        if (leaderboardName == null && secret == null) {
            result = false;
        } else {
            Regatta regatta = this.getRegattaByName(leaderboardName);
            if (regatta == null) {
                if (secret != null) {
                    logger.warning("Attempt to skip security checks using regatta secret \"" + secret + "\" for leaderboard \"" + leaderboardName + "\", but a regatta with the same name could not be resolved");
                }
                result = false;
            } else {
                result = Util.equalStringsWithEmptyIsNull((String)regatta.getRegistrationLinkSecret(), (String)secret);
            }
        }
        return result;
    }

    public CourseAndMarkConfigurationFactory getCourseAndMarkConfigurationFactory();

    public RaceTrackingConnectivityParameters getConnectivityParametersByRace(RaceDefinition var1);

    public RaceTrackingHandler getPermissionAwareRaceTrackingHandler();

    public RaceHandle addRace(RegattaIdentifier var1, RaceTrackingConnectivityParameters var2, long var3) throws Exception;

    public TypeBasedServiceFinder<RaceTrackingConnectivityParametersHandler> getRaceTrackingConnectivityParamsServiceFinder();

    public Map<LeaderboardGroup, ? extends Iterable<Event>> importMasterData(String var1, UUID[] var2, boolean var3, boolean var4, boolean var5, boolean var6, String var7, String var8, String var9, boolean var10, UUID var11) throws IllegalArgumentException;

    public void addOrReplaceExpeditionDeviceConfiguration(UUID var1, String var2, Integer var3);

    public void removeExpeditionDeviceConfiguration(UUID var1);

    public int getNumberOfTrackedRacesStillLoading();

    public int getNumberOfTrackedRacesRestoredDoneLoading();

    public Event findEventContainingLeaderboardAndMatchingAtLeastOneCourseArea(Leaderboard var1);

    public Set<Event> findEventsContainingLeaderboardAndMatchingAtLeastOneCourseArea(Leaderboard var1, Iterable<Event> var2);

    public void revokeMarkDefinitionEventInRegattaLog(String var1, String var2, String var3, String var4) throws DoesNotHaveRegattaLogException, MarkAlreadyUsedInRaceException;

    public void addMarkToRegattaLog(String var1, Mark var2) throws DoesNotHaveRegattaLogException;

    public Util.Pair<Boolean, String> checkIfMarksAreUsedInOtherRaceLogs(String var1, String var2, String var3, Set<String> var4);

    public Iterable<CompetitorProvider> getAllCompetitorProviders();

    public Double getCompetitorRaceDataEntry(DetailType var1, TrackedRace var2, Competitor var3, TimePoint var4, LeaderboardGroup var5, String var6, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var7) throws NoWindException, NotEnoughDataHasBeenAddedException, MaxIterationsExceededException, FunctionEvaluationException;
}

