/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubPatternMessageListener;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.SubscribeListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.ServiceManager;
import org.redisson.misc.AsyncSemaphore;
import org.redisson.misc.WrappedLock;
import org.redisson.pubsub.PublishSubscribeService;

public class PubSubConnectionEntry {
    private final AtomicInteger subscribedChannelsAmount;
    private final RedisPubSubConnection conn;
    private final Map<ChannelName, SubscribeListener> subscribeChannelListeners = new ConcurrentHashMap<ChannelName, SubscribeListener>();
    private final Map<ChannelName, Queue<RedisPubSubListener<?>>> channelListeners = new ConcurrentHashMap();
    private final Map<ChannelName, WrappedLock> channelLocks = new ConcurrentHashMap<ChannelName, WrappedLock>();
    private static final Queue<RedisPubSubListener<?>> EMPTY_QUEUE = new LinkedList();
    private final ServiceManager serviceManager;
    private final PublishSubscribeService subscribeService;
    private final MasterSlaveEntry entry;
    private static final Map<PubSubType, PubSubType> SUBSCRIBE2UNSUBSCRIBE = new HashMap<PubSubType, PubSubType>();

    public PubSubConnectionEntry(RedisPubSubConnection conn, ConnectionManager connectionManager, MasterSlaveEntry entry) {
        this.conn = conn;
        this.entry = entry;
        this.serviceManager = connectionManager.getServiceManager();
        this.subscribeService = connectionManager.getSubscribeService();
        this.subscribedChannelsAmount = new AtomicInteger(this.serviceManager.getConfig().getSubscriptionsPerConnection());
    }

    public MasterSlaveEntry getEntry() {
        return this.entry;
    }

    public int countListeners(ChannelName channelName) {
        return this.channelListeners.getOrDefault(channelName, EMPTY_QUEUE).size();
    }

    public boolean hasListeners(ChannelName channelName) {
        return this.channelListeners.containsKey(channelName);
    }

    public Queue<RedisPubSubListener<?>> getListeners(ChannelName channelName) {
        return this.channelListeners.getOrDefault(channelName, EMPTY_QUEUE);
    }

    public void addListener(ChannelName channelName, RedisPubSubListener<?> listener) {
        if (listener == null) {
            return;
        }
        Queue queue = this.channelListeners.computeIfAbsent(channelName, k -> new ConcurrentLinkedQueue());
        WrappedLock lock = this.channelLocks.computeIfAbsent(channelName, k -> new WrappedLock());
        boolean deleted = lock.execute(() -> {
            if (this.channelListeners.get(channelName) != queue) {
                return true;
            }
            queue.add(listener);
            return false;
        });
        if (deleted) {
            this.addListener(channelName, listener);
            return;
        }
        this.conn.addListener(listener);
    }

    public boolean removeListener(ChannelName channelName, EventListener msgListener) {
        Queue<RedisPubSubListener<?>> listeners = this.channelListeners.get(channelName);
        for (RedisPubSubListener redisPubSubListener : listeners) {
            if (redisPubSubListener instanceof PubSubMessageListener && ((PubSubMessageListener)redisPubSubListener).getListener() == msgListener) {
                this.removeListener(channelName, redisPubSubListener);
                return true;
            }
            if (!(redisPubSubListener instanceof PubSubPatternMessageListener) || ((PubSubPatternMessageListener)redisPubSubListener).getListener() != msgListener) continue;
            this.removeListener(channelName, redisPubSubListener);
            return true;
        }
        return false;
    }

    public boolean removeListener(ChannelName channelName, int listenerId) {
        Queue<RedisPubSubListener<?>> listeners = this.channelListeners.getOrDefault(channelName, EMPTY_QUEUE);
        for (RedisPubSubListener redisPubSubListener : listeners) {
            if (System.identityHashCode(redisPubSubListener) != listenerId) continue;
            this.removeListener(channelName, redisPubSubListener);
            return true;
        }
        return false;
    }

    public void removeListener(ChannelName channelName, RedisPubSubListener<?> listener) {
        Queue<RedisPubSubListener<?>> queue = this.channelListeners.get(channelName);
        WrappedLock lock = this.channelLocks.get(channelName);
        lock.execute(() -> {
            if (queue.remove(listener) && queue.isEmpty()) {
                this.channelListeners.remove(channelName);
                this.channelLocks.remove(channelName);
            }
        });
        this.conn.removeListener(listener);
    }

    public int tryAcquire() {
        int value;
        do {
            if ((value = this.subscribedChannelsAmount.get()) != 0) continue;
            return -1;
        } while (!this.subscribedChannelsAmount.compareAndSet(value, value - 1));
        return value - 1;
    }

    public int release() {
        return this.subscribedChannelsAmount.incrementAndGet();
    }

    public boolean isFree() {
        return this.subscribedChannelsAmount.get() == this.serviceManager.getConfig().getSubscriptionsPerConnection();
    }

    public void subscribe(Codec codec, ChannelName channelName, CompletableFuture<PubSubConnectionEntry> pm, PubSubType type, AsyncSemaphore lock, RedisPubSubListener<?>[] listeners) {
        CompletableFuture<PubSubConnectionEntry> pp = new CompletableFuture<PubSubConnectionEntry>();
        pp.whenComplete((r, e) -> {
            if (e != null) {
                PubSubType unsubscribeType = SUBSCRIBE2UNSUBSCRIBE.get((Object)type);
                CompletableFuture<Codec> f = this.subscribeService.unsubscribe(channelName, this, unsubscribeType);
                f.whenComplete((rr, ee) -> pm.completeExceptionally((Throwable)e));
                return;
            }
            pm.complete((PubSubConnectionEntry)r);
        });
        CompletableFuture<Void> subscribeFuture = this.addListeners(channelName, pp, type, lock, listeners);
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        promise.whenComplete((r, ex) -> {
            if (ex != null) {
                subscribeFuture.completeExceptionally((Throwable)ex);
            }
        });
        ChannelFuture future = PubSubType.SUBSCRIBE == type ? this.conn.subscribe(promise, codec, channelName) : (PubSubType.SSUBSCRIBE == type ? this.conn.ssubscribe(promise, codec, channelName) : this.conn.psubscribe(promise, codec, channelName));
        future.addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
            if (!future1.isSuccess()) {
                subscribeFuture.completeExceptionally(future1.cause());
                return;
            }
            this.serviceManager.newTimeout(t -> subscribeFuture.completeExceptionally(new RedisTimeoutException("Subscription response timeout after " + this.serviceManager.getConfig().getTimeout() + "ms. Check network and/or increase 'timeout' parameter.")), this.serviceManager.getConfig().getTimeout(), TimeUnit.MILLISECONDS);
        }));
    }

    private SubscribeListener getSubscribeFuture(ChannelName channel, PubSubType type) {
        return this.subscribeChannelListeners.computeIfAbsent(channel, k -> {
            SubscribeListener listener = new SubscribeListener(channel, type);
            this.conn.addListener(listener);
            return listener;
        });
    }

    public void unsubscribe(final PubSubType commandType, final ChannelName channel, final RedisPubSubListener<?> listener) {
        final AtomicBoolean executed = new AtomicBoolean();
        this.conn.addListener(new BaseRedisPubSubListener(){

            @Override
            public void onStatus(PubSubType type, CharSequence ch) {
                if (type == commandType && channel.equals(ch)) {
                    executed.set(true);
                    PubSubConnectionEntry.this.conn.removeListener(this);
                    PubSubConnectionEntry.this.removeListeners(channel);
                    if (listener != null) {
                        listener.onStatus(type, ch);
                    }
                }
            }
        });
        ChannelFuture future = this.conn.unsubscribe(commandType, channel);
        future.addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                return;
            }
            this.serviceManager.newTimeout(timeout -> {
                if (executed.get()) {
                    return;
                }
                this.conn.onMessage(new PubSubStatusMessage(commandType, channel));
            }, this.serviceManager.getConfig().getTimeout(), TimeUnit.MILLISECONDS);
        }));
    }

    private void removeListeners(ChannelName channel) {
        this.conn.removeDisconnectListener(channel);
        SubscribeListener s = this.subscribeChannelListeners.remove(channel);
        this.conn.removeListener(s);
        Queue<RedisPubSubListener<?>> queue = this.channelListeners.get(channel);
        if (queue != null) {
            WrappedLock lock = this.channelLocks.get(channel);
            lock.execute(() -> {
                this.channelListeners.remove(channel);
                this.channelLocks.remove(channel);
            });
            for (RedisPubSubListener redisPubSubListener : queue) {
                this.conn.removeListener(redisPubSubListener);
            }
        }
    }

    public RedisPubSubConnection getConnection() {
        return this.conn;
    }

    public String toString() {
        return "PubSubConnectionEntry [subscribedChannelsAmount=" + this.subscribedChannelsAmount + ", conn=" + this.conn + "]";
    }

    public CompletableFuture<Void> addListeners(ChannelName channelName, CompletableFuture<PubSubConnectionEntry> promise, PubSubType type, AsyncSemaphore lock, RedisPubSubListener<?> ... listeners) {
        for (RedisPubSubListener<?> listener : listeners) {
            this.addListener(channelName, listener);
        }
        SubscribeListener list = this.getSubscribeFuture(channelName, type);
        CompletableFuture<Void> subscribeFuture = list.getSuccessFuture();
        subscribeFuture.whenComplete((res, e) -> {
            if (e != null) {
                promise.completeExceptionally((Throwable)e);
                lock.release();
                return;
            }
            if (!promise.complete(this)) {
                for (RedisPubSubListener listener : listeners) {
                    this.removeListener(channelName, listener);
                }
                if (!this.hasListeners(channelName)) {
                    this.subscribeService.unsubscribeLocked(type, channelName, this).whenComplete((r, ex) -> lock.release());
                } else {
                    lock.release();
                }
            } else {
                lock.release();
            }
        });
        return subscribeFuture;
    }

    static {
        SUBSCRIBE2UNSUBSCRIBE.put(PubSubType.SUBSCRIBE, PubSubType.UNSUBSCRIBE);
        SUBSCRIBE2UNSUBSCRIBE.put(PubSubType.SSUBSCRIBE, PubSubType.SUNSUBSCRIBE);
        SUBSCRIBE2UNSUBSCRIBE.put(PubSubType.PSUBSCRIBE, PubSubType.PUNSUBSCRIBE);
    }
}

