/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.swisstimingadapter.SailMasterMessage;
import com.sap.sailing.domain.swisstimingadapter.impl.SailMasterConnectorForSocket;
import com.sap.sailing.domain.swisstimingadapter.impl.SwissTimingRaceTrackerImpl;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SailMasterLiveSimulatorConnectorImpl
extends SailMasterConnectorForSocket {
    private static final Logger logger = Logger.getLogger(SailMasterLiveSimulatorConnectorImpl.class.getName());
    private final List<SailMasterMessage> bufferedMessageList;
    private long messageDeliveryIntervalInMs = Long.valueOf(System.getProperty("simulateLiveMode.delayInMillis", "250"));

    public SailMasterLiveSimulatorConnectorImpl(String host, int port, String raceId, String raceName, String raceDescription, BoatClass boatClass, SwissTimingRaceTrackerImpl swissTimingRaceTracker) throws InterruptedException, ParseException {
        super(host, port, raceId, raceName, raceDescription, boatClass, swissTimingRaceTracker);
        this.bufferedMessageList = Collections.synchronizedList(new LinkedList());
        Thread messageDeliveryThread = new Thread("SailMasterLiveSimulatorConnector"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (!SailMasterLiveSimulatorConnectorImpl.this.bufferedMessageList.isEmpty()) {
                                SailMasterMessage message = (SailMasterMessage)SailMasterLiveSimulatorConnectorImpl.this.bufferedMessageList.remove(0);
                                SailMasterLiveSimulatorConnectorImpl.this.notifyParentListeners(message);
                            }
                            Thread.sleep(SailMasterLiveSimulatorConnectorImpl.this.messageDeliveryIntervalInMs);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error trying to simulate SwissTiming messages", e);
                        continue;
                    }
                    break;
                }
            }
        };
        messageDeliveryThread.start();
    }

    private void notifyParentListeners(SailMasterMessage message) throws ParseException {
        super.notifyListeners(message);
    }

    @Override
    protected void notifyListeners(SailMasterMessage message) {
        this.bufferedMessageList.add(message);
    }
}

