/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.impl.rules;

import com.sap.sailing.aiagent.impl.AIAgentImpl;
import com.sap.sailing.aiagent.impl.rules.Rule;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.tagging.RaceLogNotFoundException;
import com.sap.sailing.domain.common.tagging.ServiceNotFoundException;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.shared.util.Wait;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.SecurityUtils;
import org.json.simple.parser.ParseException;

public class TopThreeMarkRoundingRule
extends Rule {
    private static final Logger logger = Logger.getLogger(TopThreeMarkRoundingRule.class.getName());
    private static final String TOPIC_TEMPLATE = "Rounding waypoint #%d";
    private final ConcurrentMap<Waypoint, Boolean> hasFired = new ConcurrentHashMap<Waypoint, Boolean>();

    public TopThreeMarkRoundingRule(AIAgentImpl aiAgent, Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        super(aiAgent, leaderboard, raceColumn, fleet, trackedRace);
    }

    public void markPassingReceived(Competitor competitor, Map<Waypoint, MarkPassing> oldMarkPassings, Iterable<MarkPassing> markPassings) {
        int numberOfCompetitors = Util.size((Iterable)this.getTrackedRace().getRace().getCompetitors());
        for (MarkPassing markPassing : markPassings) {
            List waypointMarkPassingsCopy;
            int waypointIndex = this.getTrackedRace().getRace().getCourse().getIndexOfWaypoint(markPassing.getWaypoint());
            if (waypointIndex <= 0 || this.hasFired.get(markPassing.getWaypoint()) == Boolean.TRUE) continue;
            RankingMetric.RankingInfo rankingInfo = this.getTrackedRace().getRankingMetric().getRankingInfo(markPassing.getTimePoint());
            LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(markPassing.getTimePoint());
            Iterable waypointMarkPassings = this.getTrackedRace().getMarkPassingsInOrder(markPassing.getWaypoint());
            this.getTrackedRace().lockForRead(waypointMarkPassings);
            try {
                waypointMarkPassingsCopy = Util.asList((Iterable)waypointMarkPassings);
            }
            finally {
                this.getTrackedRace().unlockAfterRead(waypointMarkPassings);
            }
            if (Util.size((Iterable)waypointMarkPassingsCopy) < Math.min(numberOfCompetitors, 3)) continue;
            this.hasFired.put(markPassing.getWaypoint(), Boolean.TRUE);
            TrackedLeg previousTrackedLeg = waypointIndex > 1 ? this.getTrackedRace().getTrackedLeg(this.getTrackedRace().getRace().getCourse().getLeg(waypointIndex - 2)) : null;
            LinkedHashMap ranksAfterPreviousLeg = waypointIndex > 1 ? previousTrackedLeg.getRanks(markPassing.getTimePoint()) : null;
            StringBuilder promptBuilder = new StringBuilder();
            promptBuilder.append("Describe, very consisely, the fact that ");
            int i = 0;
            Iterator markPassingsIterator = waypointMarkPassingsCopy.iterator();
            ArrayList<Duration> gaps = new ArrayList<Duration>();
            boolean first = true;
            TimePoint lastOfTheThreeMarkPassingTime = null;
            while (i++ < 3 && markPassingsIterator.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    promptBuilder.append(" and ");
                }
                MarkPassing waypointMarkPassing = (MarkPassing)markPassingsIterator.next();
                this.appendCompetitorToPromptBuilder(waypointMarkPassing.getCompetitor(), promptBuilder);
                if (waypointIndex == this.getTrackedRace().getRace().getCourse().getNumberOfWaypoints() - 1) {
                    promptBuilder.append(" finished the race");
                } else {
                    promptBuilder.append(" rounded waypoint #");
                    promptBuilder.append(waypointIndex);
                    promptBuilder.append(" (\"");
                    promptBuilder.append(waypointMarkPassing.getWaypoint().getName());
                    promptBuilder.append("\")");
                }
                promptBuilder.append(" in position #");
                promptBuilder.append(i);
                promptBuilder.append(" at ");
                lastOfTheThreeMarkPassingTime = waypointMarkPassing.getTimePoint();
                promptBuilder.append(lastOfTheThreeMarkPassingTime);
                if (waypointIndex <= 1) continue;
                promptBuilder.append(" after starting into the leg at position #");
                promptBuilder.append(ranksAfterPreviousLeg.get(waypointMarkPassing.getCompetitor()));
                gaps.add(this.getTrackedRace().getRankingMetric().getLegGapToLegLeaderInOwnTime(this.getTrackedRace().getTrackedLeg(waypointMarkPassing.getCompetitor(), previousTrackedLeg.getLeg()), markPassing.getTimePoint(), rankingInfo, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache));
            }
            TimePoint finalLastOfTheThreeMarkPassingTime = lastOfTheThreeMarkPassingTime;
            if (waypointIndex > 1) {
                promptBuilder.append(", where their gaps to the race leader at the previous waypoint were ");
                promptBuilder.append(Util.joinStrings((String)", ", gaps));
                promptBuilder.append(", respectively.");
            }
            new Thread(SecurityUtils.getSubject().associateWith(() -> {
                promptBuilder.append("Here are the average distances the competitors were left (negative values) or right (positive values) of the course middle line where the competitors are sorted from best to worst at the end of the leg:\n");
                TrackedLeg trackedLeg = this.getTrackedRace().getTrackedLeg(this.getTrackedRace().getRace().getCourse().getLeg(waypointIndex - 1));
                for (Competitor c : this.getTrackedRace().getCompetitorsFromBestToWorst(markPassing.getTimePoint())) {
                    TrackedLegOfCompetitor trackedLegOfCompetitor = this.getTrackedRace().getTrackedLeg(c, trackedLeg.getLeg());
                    this.waitForRaceToStopLoading();
                    Distance xte = trackedLegOfCompetitor.getAverageSignedCrossTrackError(markPassing.getTimePoint(), true);
                    promptBuilder.append("  ");
                    this.appendCompetitorToPromptBuilder(c, promptBuilder);
                    promptBuilder.append(": ");
                    promptBuilder.append(xte);
                    promptBuilder.append("\n");
                }
                promptBuilder.append("Mention, if you see any pattern for which course side worked out better on this leg and relate this to the top three finishers of this leg: left or right!");
                try {
                    this.produceComment(String.format(TOPIC_TEMPLATE, waypointIndex), promptBuilder.toString(), finalLastOfTheThreeMarkPassingTime, String.valueOf(((Object)((Object)this)).getClass().getName()) + "/" + waypointIndex);
                }
                catch (RaceLogNotFoundException | ServiceNotFoundException | IOException | UnsupportedOperationException | URISyntaxException | ParseException e) {
                    this.hasFired.put(markPassing.getWaypoint(), Boolean.FALSE);
                    logger.log(Level.WARNING, "Problem trying to produce an AI comment", e);
                }
            }), "Background prompt completer for race " + this.getTrackedRace().getTrackedRegatta().getRegatta().getName() + " / " + this.getTrackedRace().getRace() + ", waiting for XTE calculations to finish").start();
        }
    }

    private void waitForRaceToStopLoading() throws RuntimeException {
        try {
            Wait.wait(() -> {
                TrackedRaceStatusEnum status = this.getTrackedRace().getStatus().getStatus();
                if (status != TrackedRaceStatusEnum.LOADING && status != TrackedRaceStatusEnum.PREPARED) {
                    return true;
                }
                return false;
            }, Optional.empty(), (Duration)Duration.ONE_SECOND, (Level)Level.INFO, (String)("Race " + this.getTrackedRace().getRace().getName() + " to finish loading"));
        }
        catch (TimeoutException e) {
            logger.warning("This shouldn't have happened because we should have been waiting indefinitely");
        }
        catch (Exception e) {
            assert (false);
            throw new RuntimeException();
        }
    }
}

