/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action to use in the place of the action that results from the rule group evaluation. Set the override action to
 * none to leave the result of the rule group alone. Set it to count to override the result to count only.
 * </p>
 * <p>
 * You can only use this for rule statements that reference a rule group, like <code>RuleGroupReferenceStatement</code>
 * and <code>ManagedRuleGroupStatement</code>.
 * </p>
 * <note>
 * <p>
 * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the
 * rules in the rule group to only count matches, do not use this and instead use the rule action override option, with
 * <code>Count</code> action, in your rule group reference statement settings.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OverrideAction implements SdkPojo, Serializable, ToCopyableBuilder<OverrideAction.Builder, OverrideAction> {
    private static final SdkField<CountAction> COUNT_FIELD = SdkField.<CountAction> builder(MarshallingType.SDK_POJO)
            .memberName("Count").getter(getter(OverrideAction::count)).setter(setter(Builder::count))
            .constructor(CountAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<NoneAction> NONE_FIELD = SdkField.<NoneAction> builder(MarshallingType.SDK_POJO)
            .memberName("None").getter(getter(OverrideAction::none)).setter(setter(Builder::none))
            .constructor(NoneAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("None").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, NONE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CountAction count;

    private final NoneAction none;

    private OverrideAction(BuilderImpl builder) {
        this.count = builder.count;
        this.none = builder.none;
    }

    /**
     * <p>
     * Override the rule group evaluation result to count only.
     * </p>
     * <note>
     * <p>
     * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want
     * the rules in the rule group to only count matches, do not use this and instead use the rule action override
     * option, with <code>Count</code> action, in your rule group reference statement settings.
     * </p>
     * </note>
     * 
     * @return Override the rule group evaluation result to count only. </p> <note>
     *         <p>
     *         This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If
     *         you want the rules in the rule group to only count matches, do not use this and instead use the rule
     *         action override option, with <code>Count</code> action, in your rule group reference statement settings.
     *         </p>
     */
    public final CountAction count() {
        return count;
    }

    /**
     * <p>
     * Don't override the rule group evaluation result. This is the most common setting.
     * </p>
     * 
     * @return Don't override the rule group evaluation result. This is the most common setting.
     */
    public final NoneAction none() {
        return none;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(none());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverrideAction)) {
            return false;
        }
        OverrideAction other = (OverrideAction) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(none(), other.none());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OverrideAction").add("Count", count()).add("None", none()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "None":
            return Optional.ofNullable(clazz.cast(none()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Count", COUNT_FIELD);
        map.put("None", NONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OverrideAction, T> g) {
        return obj -> g.apply((OverrideAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OverrideAction> {
        /**
         * <p>
         * Override the rule group evaluation result to count only.
         * </p>
         * <note>
         * <p>
         * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you
         * want the rules in the rule group to only count matches, do not use this and instead use the rule action
         * override option, with <code>Count</code> action, in your rule group reference statement settings.
         * </p>
         * </note>
         * 
         * @param count
         *        Override the rule group evaluation result to count only. </p> <note>
         *        <p>
         *        This option is usually set to none. It does not affect how the rules in the rule group are evaluated.
         *        If you want the rules in the rule group to only count matches, do not use this and instead use the
         *        rule action override option, with <code>Count</code> action, in your rule group reference statement
         *        settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(CountAction count);

        /**
         * <p>
         * Override the rule group evaluation result to count only.
         * </p>
         * <note>
         * <p>
         * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you
         * want the rules in the rule group to only count matches, do not use this and instead use the rule action
         * override option, with <code>Count</code> action, in your rule group reference statement settings.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link CountAction.Builder} avoiding the
         * need to create one manually via {@link CountAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CountAction.Builder#build()} is called immediately and its result
         * is passed to {@link #count(CountAction)}.
         * 
         * @param count
         *        a consumer that will call methods on {@link CountAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #count(CountAction)
         */
        default Builder count(Consumer<CountAction.Builder> count) {
            return count(CountAction.builder().applyMutation(count).build());
        }

        /**
         * <p>
         * Don't override the rule group evaluation result. This is the most common setting.
         * </p>
         * 
         * @param none
         *        Don't override the rule group evaluation result. This is the most common setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder none(NoneAction none);

        /**
         * <p>
         * Don't override the rule group evaluation result. This is the most common setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link NoneAction.Builder} avoiding the need to
         * create one manually via {@link NoneAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NoneAction.Builder#build()} is called immediately and its result
         * is passed to {@link #none(NoneAction)}.
         * 
         * @param none
         *        a consumer that will call methods on {@link NoneAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #none(NoneAction)
         */
        default Builder none(Consumer<NoneAction.Builder> none) {
            return none(NoneAction.builder().applyMutation(none).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CountAction count;

        private NoneAction none;

        private BuilderImpl() {
        }

        private BuilderImpl(OverrideAction model) {
            count(model.count);
            none(model.none);
        }

        public final CountAction.Builder getCount() {
            return count != null ? count.toBuilder() : null;
        }

        public final void setCount(CountAction.BuilderImpl count) {
            this.count = count != null ? count.build() : null;
        }

        @Override
        public final Builder count(CountAction count) {
            this.count = count;
            return this;
        }

        public final NoneAction.Builder getNone() {
            return none != null ? none.toBuilder() : null;
        }

        public final void setNone(NoneAction.BuilderImpl none) {
            this.none = none != null ? none.build() : null;
        }

        @Override
        public final Builder none(NoneAction none) {
            this.none = none;
            return this;
        }

        @Override
        public OverrideAction build() {
            return new OverrideAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
