/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * Amazon Elastic Inference is no longer available.
 * </p>
 * </note>
 * <p>
 * Describes the Inference accelerators for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceAcceleratorInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceAcceleratorInfo.Builder, InferenceAcceleratorInfo> {
    private static final SdkField<List<InferenceDeviceInfo>> ACCELERATORS_FIELD = SdkField
            .<List<InferenceDeviceInfo>> builder(MarshallingType.LIST)
            .memberName("Accelerators")
            .getter(getter(InferenceAcceleratorInfo::accelerators))
            .setter(setter(Builder::accelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerators")
                    .unmarshallLocationName("accelerators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceDeviceInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceDeviceInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Integer> TOTAL_INFERENCE_MEMORY_IN_MIB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalInferenceMemoryInMiB")
            .getter(getter(InferenceAcceleratorInfo::totalInferenceMemoryInMiB))
            .setter(setter(Builder::totalInferenceMemoryInMiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInferenceMemoryInMiB")
                    .unmarshallLocationName("totalInferenceMemoryInMiB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATORS_FIELD,
            TOTAL_INFERENCE_MEMORY_IN_MIB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<InferenceDeviceInfo> accelerators;

    private final Integer totalInferenceMemoryInMiB;

    private InferenceAcceleratorInfo(BuilderImpl builder) {
        this.accelerators = builder.accelerators;
        this.totalInferenceMemoryInMiB = builder.totalInferenceMemoryInMiB;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accelerators property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccelerators() {
        return accelerators != null && !(accelerators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the Inference accelerators for the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccelerators} method.
     * </p>
     * 
     * @return Describes the Inference accelerators for the instance type.
     */
    public final List<InferenceDeviceInfo> accelerators() {
        return accelerators;
    }

    /**
     * <p>
     * The total size of the memory for the inference accelerators for the instance type, in MiB.
     * </p>
     * 
     * @return The total size of the memory for the inference accelerators for the instance type, in MiB.
     */
    public final Integer totalInferenceMemoryInMiB() {
        return totalInferenceMemoryInMiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccelerators() ? accelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalInferenceMemoryInMiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceAcceleratorInfo)) {
            return false;
        }
        InferenceAcceleratorInfo other = (InferenceAcceleratorInfo) obj;
        return hasAccelerators() == other.hasAccelerators() && Objects.equals(accelerators(), other.accelerators())
                && Objects.equals(totalInferenceMemoryInMiB(), other.totalInferenceMemoryInMiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceAcceleratorInfo").add("Accelerators", hasAccelerators() ? accelerators() : null)
                .add("TotalInferenceMemoryInMiB", totalInferenceMemoryInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accelerators":
            return Optional.ofNullable(clazz.cast(accelerators()));
        case "TotalInferenceMemoryInMiB":
            return Optional.ofNullable(clazz.cast(totalInferenceMemoryInMiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Accelerators", ACCELERATORS_FIELD);
        map.put("TotalInferenceMemoryInMiB", TOTAL_INFERENCE_MEMORY_IN_MIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceAcceleratorInfo, T> g) {
        return obj -> g.apply((InferenceAcceleratorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceAcceleratorInfo> {
        /**
         * <p>
         * Describes the Inference accelerators for the instance type.
         * </p>
         * 
         * @param accelerators
         *        Describes the Inference accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerators(Collection<InferenceDeviceInfo> accelerators);

        /**
         * <p>
         * Describes the Inference accelerators for the instance type.
         * </p>
         * 
         * @param accelerators
         *        Describes the Inference accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerators(InferenceDeviceInfo... accelerators);

        /**
         * <p>
         * Describes the Inference accelerators for the instance type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #accelerators(List<InferenceDeviceInfo>)}.
         * 
         * @param accelerators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accelerators(java.util.Collection<InferenceDeviceInfo>)
         */
        Builder accelerators(Consumer<InferenceDeviceInfo.Builder>... accelerators);

        /**
         * <p>
         * The total size of the memory for the inference accelerators for the instance type, in MiB.
         * </p>
         * 
         * @param totalInferenceMemoryInMiB
         *        The total size of the memory for the inference accelerators for the instance type, in MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInferenceMemoryInMiB(Integer totalInferenceMemoryInMiB);
    }

    static final class BuilderImpl implements Builder {
        private List<InferenceDeviceInfo> accelerators = DefaultSdkAutoConstructList.getInstance();

        private Integer totalInferenceMemoryInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceAcceleratorInfo model) {
            accelerators(model.accelerators);
            totalInferenceMemoryInMiB(model.totalInferenceMemoryInMiB);
        }

        public final List<InferenceDeviceInfo.Builder> getAccelerators() {
            List<InferenceDeviceInfo.Builder> result = InferenceDeviceInfoListCopier.copyToBuilder(this.accelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccelerators(Collection<InferenceDeviceInfo.BuilderImpl> accelerators) {
            this.accelerators = InferenceDeviceInfoListCopier.copyFromBuilder(accelerators);
        }

        @Override
        public final Builder accelerators(Collection<InferenceDeviceInfo> accelerators) {
            this.accelerators = InferenceDeviceInfoListCopier.copy(accelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(InferenceDeviceInfo... accelerators) {
            accelerators(Arrays.asList(accelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(Consumer<InferenceDeviceInfo.Builder>... accelerators) {
            accelerators(Stream.of(accelerators).map(c -> InferenceDeviceInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalInferenceMemoryInMiB() {
            return totalInferenceMemoryInMiB;
        }

        public final void setTotalInferenceMemoryInMiB(Integer totalInferenceMemoryInMiB) {
            this.totalInferenceMemoryInMiB = totalInferenceMemoryInMiB;
        }

        @Override
        public final Builder totalInferenceMemoryInMiB(Integer totalInferenceMemoryInMiB) {
            this.totalInferenceMemoryInMiB = totalInferenceMemoryInMiB;
            return this;
        }

        @Override
        public InferenceAcceleratorInfo build() {
            return new InferenceAcceleratorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
