/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.impl.rules;

import com.sap.sailing.aiagent.impl.AIAgentImpl;
import com.sap.sailing.aiagent.impl.rules.Rule;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.tagging.RaceLogNotFoundException;
import com.sap.sailing.domain.common.tagging.ServiceNotFoundException;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.json.simple.parser.ParseException;

public class GoodStartRule
extends Rule {
    private static final String TOPIC = "The Start";
    private static final Iterable<MaxPointsReason> EARLY_START_CODES = new HashSet<MaxPointsReason>(Arrays.asList(MaxPointsReason.OCS, MaxPointsReason.UFD, MaxPointsReason.BFD));
    private boolean hasFired = false;

    public GoodStartRule(AIAgentImpl aiAgent, Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        super(aiAgent, leaderboard, raceColumn, fleet, trackedRace);
    }

    public void markPassingReceived(Competitor competitor, Map<Waypoint, MarkPassing> oldMarkPassings, Iterable<MarkPassing> markPassings) {
        Iterable startMarkPassings;
        if (!this.hasFired && Util.size((Iterable)(startMarkPassings = this.getTrackedRace().getMarkPassingsInOrder(this.getTrackedRace().getRace().getCourse().getFirstWaypoint()))) >= Util.size((Iterable)this.getTrackedRace().getRace().getCompetitors()) / 2) {
            this.hasFired = true;
            MarkPassing firstStart = (MarkPassing)startMarkPassings.iterator().next();
            try {
                MaxPointsReason maxPointsReason;
                StringBuilder promptBuilder = new StringBuilder();
                promptBuilder.append("Describe, very consisely, the fact that ");
                this.appendCompetitorToPromptBuilder(firstStart.getCompetitor(), promptBuilder).append(" started first in race " + this.getTrackedRace().getRace().getName()).append(". Consider the competitor's start delays in comparison to all other competitors' start delays in previous races of this regatta ").append(this.getLeaderboard().getName()).append(" in class " + this.getLeaderboard().getBoatClass().getName()).append(" that are given below in table form:\n");
                for (RaceColumn previousRaceColumn : this.getLeaderboard().getRaceColumns()) {
                    if (previousRaceColumn == this.getRaceColumn()) break;
                    TrackedRace previousTrackedRace = previousRaceColumn.getTrackedRace(firstStart.getCompetitor());
                    if (previousTrackedRace == null) continue;
                    promptBuilder.append("\nStart delays in race ").append(previousRaceColumn.getName()).append(":\n");
                    for (Competitor previousRaceCompetitor : previousTrackedRace.getRace().getCompetitors()) {
                        MarkPassing previousRaceCompetitorStartMarkPassing = previousTrackedRace.getMarkPassing(previousRaceCompetitor, previousTrackedRace.getRace().getCourse().getFirstWaypoint());
                        if (previousRaceCompetitorStartMarkPassing == null) continue;
                        promptBuilder.append("  ");
                        this.appendCompetitorToPromptBuilder(previousRaceCompetitor, promptBuilder).append(": ").append(previousTrackedRace.getStartOfRace().until(previousRaceCompetitorStartMarkPassing.getTimePoint())).append("\n");
                    }
                }
                if (Util.contains(EARLY_START_CODES, (Object)(maxPointsReason = this.getLeaderboard().getMaxPointsReason(firstStart.getCompetitor(), this.getRaceColumn(), TimePoint.now())))) {
                    promptBuilder.append("Consider that ");
                    this.appendCompetitorToPromptBuilder(firstStart.getCompetitor(), promptBuilder);
                    promptBuilder.append(" was called over early with penalty code ");
                    promptBuilder.append(maxPointsReason.name());
                    promptBuilder.append(".");
                }
                promptBuilder.append("Also, consider in your concise comment the typical start performance of this competitor in previous regattas at other events.");
                this.produceComment(TOPIC, promptBuilder.toString(), firstStart.getTimePoint(), ((Object)((Object)this)).getClass().getName());
            }
            catch (RaceLogNotFoundException | ServiceNotFoundException | IOException | UnsupportedOperationException | URISyntaxException | ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

