/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.data;

import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.data.ClusterBoundary;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public abstract class AbstractCluster<ElementType extends Serializable>
implements Cluster<ElementType> {
    private static final long serialVersionUID = 1606840566021644768L;
    private Collection<ClusterBoundary<ElementType>> boundaries;

    public AbstractCluster(Collection<ClusterBoundary<ElementType>> boundaries) {
        this.boundaries = new ArrayList<ClusterBoundary<ElementType>>(boundaries);
    }

    @Override
    public boolean isInRange(ElementType value) {
        for (ClusterBoundary<ElementType> boundary : this.boundaries) {
            if (boundary.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class<ElementType> getClusterElementsType() {
        return this.boundaries.iterator().next().getClusterElementsType();
    }

    @Override
    public String asLocalizedString(Locale locale, ResourceBundleStringMessages stringMessages) {
        return this.getBoundariesAsString();
    }

    protected abstract String getBoundariesAsString();

    public String toString() {
        return this.getBoundariesAsString();
    }

    public Iterable<ClusterBoundary<ElementType>> getClusterBoundaries() {
        return this.boundaries;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boundaries == null ? 0 : this.boundaries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCluster other = (AbstractCluster)obj;
        return !(this.boundaries == null ? other.boundaries != null : !this.boundaries.equals(other.boundaries));
    }
}

