/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.management;

import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.impl.components.DataRetrieverLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ReducedDimensions {
    private final Map<DataRetrieverLevel<?, ?>, Iterable<Function<?>>> reducedDimensions;
    private final Map<Function<?>, Function<?>> fromOriginalDimensionToReducedDimension;

    public ReducedDimensions(Map<DataRetrieverLevel<?, ?>, Iterable<Function<?>>> reducedDimensions, Map<Function<?>, Function<?>> fromOriginalDimensionToReducedDimension) {
        this.reducedDimensions = reducedDimensions;
        this.fromOriginalDimensionToReducedDimension = fromOriginalDimensionToReducedDimension;
    }

    public ReducedDimensions() {
        this(new HashMap(), new HashMap());
    }

    public Function<?> getReducedDimension(Function<?> originalDimension) {
        return this.fromOriginalDimensionToReducedDimension.get(originalDimension);
    }

    public Map<DataRetrieverLevel<?, ?>, Iterable<Function<?>>> getReducedDimensions() {
        return Collections.unmodifiableMap(this.reducedDimensions);
    }

    public Map<Function<?>, Function<?>> getFromOriginalDimensionToReducedDimension() {
        return Collections.unmodifiableMap(this.fromOriginalDimensionToReducedDimension);
    }

    public ReducedDimensions createByAdd(ReducedDimensions other, boolean replaceExistingMappingsFromOriginalToReducedDimension) {
        HashMap newReducedDimensions = new HashMap(this.reducedDimensions);
        HashMap newFromOriginalDimensionToReducedDimension = new HashMap(this.fromOriginalDimensionToReducedDimension);
        for (Map.Entry<DataRetrieverLevel<?, ?>, Iterable<Function<?>>> entry : other.getReducedDimensions().entrySet()) {
            boolean alreadyContained;
            boolean bl = alreadyContained = newReducedDimensions.put(entry.getKey(), entry.getValue()) != null;
            assert (!alreadyContained);
        }
        for (Map.Entry<Object, Object> entry : other.getFromOriginalDimensionToReducedDimension().entrySet()) {
            if (!replaceExistingMappingsFromOriginalToReducedDimension && newFromOriginalDimensionToReducedDimension.containsKey(entry.getKey())) continue;
            Function original = this.getReducedDimension((Function)entry.getValue());
            newFromOriginalDimensionToReducedDimension.put((Function)entry.getKey(), original == null ? (Function)entry.getValue() : original);
        }
        return new ReducedDimensions(newReducedDimensions, newFromOriginalDimensionToReducedDimension);
    }

    public String toString() {
        return "ReducedDimensions [reducedDimensions=" + this.reducedDimensions + ", fromOriginalDimensionToReducedDimension=" + this.fromOriginalDimensionToReducedDimension + "]";
    }
}

