/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl;

import com.sap.sse.datamining.AdditionalQueryData;
import com.sap.sse.datamining.Query;
import com.sap.sse.datamining.QueryState;
import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.data.QueryResult;
import com.sap.sse.datamining.impl.components.OverwritingResultDataBuilder;
import com.sap.sse.datamining.impl.data.QueryResultImpl;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.data.QueryResultState;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProcessorQuery<ResultType, DataSourceType>
implements Query<ResultType> {
    private static final Logger LOGGER = Logger.getLogger(ProcessorQuery.class.getSimpleName());
    private final DataSourceType dataSource;
    private final Processor<DataSourceType, ?> firstProcessor;
    private QueryState state;
    private final Class<ResultType> resultType;
    private final ProcessResultReceiver resultReceiver;
    private final ResourceBundleStringMessages stringMessages;
    private final Locale locale;
    private final AdditionalQueryData additionalData;
    private final Object monitorObject = new Object();
    private Thread workingThread;

    public ProcessorQuery(DataSourceType dataSource, Class<ResultType> resultType) {
        this(dataSource, resultType, AdditionalQueryData.NULL_INSTANCE);
    }

    public ProcessorQuery(DataSourceType dataSource, Class<ResultType> resultType, AdditionalQueryData additionalData) {
        this(dataSource, null, null, resultType, additionalData);
    }

    public ProcessorQuery(DataSourceType dataSource, ResourceBundleStringMessages stringMessages, Locale locale, Class<ResultType> resultType, AdditionalQueryData additionalData) {
        this.dataSource = dataSource;
        this.stringMessages = stringMessages;
        this.locale = locale;
        this.state = QueryState.NOT_STARTED;
        this.resultType = resultType;
        this.additionalData = additionalData;
        this.resultReceiver = new ProcessResultReceiver();
        this.firstProcessor = this.createChainAndReturnFirstProcessor(this.resultReceiver);
    }

    protected abstract Processor<DataSourceType, ?> createChainAndReturnFirstProcessor(Processor<Map<GroupKey, ResultType>, Void> var1);

    @Override
    public QueryState getState() {
        return this.state;
    }

    @Override
    public Class<ResultType> getResultType() {
        return this.resultType;
    }

    @Override
    public AdditionalQueryData getAdditionalData() {
        return this.additionalData;
    }

    @Override
    public <T extends AdditionalQueryData> T getAdditionalData(Class<T> additionalDataType) {
        if (additionalDataType.isAssignableFrom(this.getAdditionalData().getClass())) {
            return (T)this.getAdditionalData();
        }
        return null;
    }

    @Override
    public QueryResult<ResultType> run() {
        try {
            return this.run(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOGGER.log(Level.SEVERE, "Got a TimeoutException that should never happen: ", e);
            return null;
        }
    }

    @Override
    public QueryResult<ResultType> run(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return this.processQuery(unit.toMillis(timeout));
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "The query processing got interrupted.", e);
            return null;
        }
    }

    private QueryResult<ResultType> processQuery(long timeoutInMillis) throws InterruptedException, TimeoutException {
        this.state = QueryState.RUNNING;
        long startTime = System.nanoTime();
        this.startWorking();
        this.waitTillWorkIsDone(timeoutInMillis);
        long endTime = System.nanoTime();
        this.logOccuredFailuresAndThrowSevereFailure();
        long calculationTimeInNanos = endTime - startTime;
        Map results = this.resultReceiver.getResult();
        QueryResultState resultState = this.state.asResultState();
        if (this.stringMessages != null && this.locale != null) {
            AdditionalResultDataBuilder additionalDataBuilder = new OverwritingResultDataBuilder();
            additionalDataBuilder = this.firstProcessor.getAdditionalResultData(additionalDataBuilder);
            return new QueryResultImpl<ResultType>(resultState, this.getResultType(), results, additionalDataBuilder.build(calculationTimeInNanos, this.stringMessages, this.locale));
        }
        return new QueryResultImpl<ResultType>(resultState, this.getResultType(), results);
    }

    private void startWorking() {
        this.workingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessorQuery.this.firstProcessor.processElement(ProcessorQuery.this.dataSource);
                    ProcessorQuery.this.firstProcessor.finish();
                }
                catch (InterruptedException e) {
                    if (ProcessorQuery.this.state == QueryState.TIMED_OUT) {
                        LOGGER.log(Level.INFO, "The query processing timed out.");
                    }
                    if (ProcessorQuery.this.state == QueryState.ABORTED) {
                        LOGGER.log(Level.INFO, "The query processing got aborted.");
                    }
                    if (ProcessorQuery.this.state == QueryState.ERROR) {
                        LOGGER.log(Level.INFO, "A severe failure occured during the query processing.");
                    }
                    LOGGER.log(Level.WARNING, "The query processing got interrupted.", e);
                }
            }
        });
        this.workingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTillWorkIsDone(long timeoutInMillis) throws InterruptedException, TimeoutException {
        this.setUpTimeoutTimer(timeoutInMillis);
        Object object = this.monitorObject;
        synchronized (object) {
            while (this.getState() == QueryState.RUNNING) {
                this.monitorObject.wait();
                if (!this.processingHasToBeAborted()) continue;
                this.firstProcessor.abort();
                this.workingThread.interrupt();
                if (this.state != QueryState.TIMED_OUT) break;
                throw new TimeoutException("The query processing timed out");
            }
        }
    }

    private boolean processingHasToBeAborted() {
        return this.state == QueryState.TIMED_OUT || this.state == QueryState.ABORTED || this.state == QueryState.ERROR;
    }

    private void setUpTimeoutTimer(long timeoutInMillis) {
        if (timeoutInMillis > 0L) {
            Timer timeoutTimer = new Timer();
            timeoutTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ProcessorQuery.this.monitorObject;
                    synchronized (object) {
                        ProcessorQuery.this.state = QueryState.TIMED_OUT;
                        ProcessorQuery.this.monitorObject.notify();
                    }
                }
            }, timeoutInMillis);
        }
    }

    private void logOccuredFailuresAndThrowSevereFailure() {
        for (Throwable failure : this.resultReceiver.getOccuredFailures()) {
            LOGGER.log(Level.SEVERE, "A failure occured during the processing of an instruction: ", failure);
        }
        if (this.state == QueryState.ERROR) {
            throw new RuntimeException("An error occured during the processing of an instruction", this.resultReceiver.getSevereFailure());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.monitorObject;
        synchronized (object) {
            LOGGER.log(Level.INFO, "Aborting the query processing");
            this.state = this.state == QueryState.RUNNING || this.state == QueryState.NOT_STARTED ? QueryState.ABORTED : this.state;
            this.monitorObject.notify();
        }
    }

    public Processor<Map<GroupKey, ResultType>, Void> getResultReceiver() {
        return this.resultReceiver;
    }

    private class ProcessResultReceiver
    implements Processor<Map<GroupKey, ResultType>, Void> {
        private final ReentrantLock resultsLock = new ReentrantLock();
        private Map<GroupKey, ResultType> results = new HashMap();
        private List<Throwable> occuredFailures = new ArrayList<Throwable>();
        private Throwable severeFailure;

        @Override
        public boolean canProcessElements() {
            return true;
        }

        @Override
        public void processElement(Map<GroupKey, ResultType> groupedAggregations) {
            this.resultsLock.lock();
            try {
                this.results.putAll(groupedAggregations);
            }
            finally {
                this.resultsLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(Throwable failure) {
            if (this.isSevereFailure(failure)) {
                this.severeFailure = failure;
                Object object = ProcessorQuery.this.monitorObject;
                synchronized (object) {
                    ProcessorQuery.this.state = QueryState.ERROR;
                    ProcessorQuery.this.monitorObject.notify();
                }
            } else {
                ProcessorQuery.this.state = QueryState.FAILURE;
                this.occuredFailures.add(failure);
            }
        }

        private boolean isSevereFailure(Throwable failure) {
            return !(failure instanceof Exception) || failure instanceof RejectedExecutionException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() throws InterruptedException {
            Object object = ProcessorQuery.this.monitorObject;
            synchronized (object) {
                ProcessorQuery.this.state = ProcessorQuery.this.state == QueryState.RUNNING ? QueryState.NORMAL : ProcessorQuery.this.state;
                ProcessorQuery.this.monitorObject.notify();
            }
        }

        @Override
        public boolean isFinished() {
            return false;
        }

        @Override
        public void abort() {
            this.results = new HashMap();
            this.occuredFailures = new ArrayList<Throwable>();
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        public Map<GroupKey, ResultType> getResult() {
            return this.results;
        }

        public List<Throwable> getOccuredFailures() {
            return this.occuredFailures;
        }

        public Throwable getSevereFailure() {
            return this.severeFailure;
        }

        @Override
        public AdditionalResultDataBuilder getAdditionalResultData(AdditionalResultDataBuilder additionalDataBuilder) {
            return additionalDataBuilder;
        }

        @Override
        public Class<Map<GroupKey, ResultType>> getInputType() {
            return Map.class;
        }

        @Override
        public Class<Void> getResultType() {
            return Void.class;
        }
    }
}

