/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl;

import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.StatisticQueryDefinition;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.impl.components.DataRetrieverLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ModifiableStatisticQueryDefinition<DataSourceType, DataType, ExtractedType, ResultType>
implements StatisticQueryDefinition<DataSourceType, DataType, ExtractedType, ResultType> {
    private final Locale locale;
    private final DataRetrieverChainDefinition<DataSourceType, DataType> retrieverChain;
    private final Map<DataRetrieverLevel<?, ?>, SerializableSettings> retrieverSettings;
    private final Map<DataRetrieverLevel<?, ?>, Map<Function<?>, Collection<?>>> filterSelection;
    private final List<Function<?>> dimensionsToGroupBy;
    private final Function<ExtractedType> statisticToCalculate;
    private final AggregationProcessorDefinition<ExtractedType, ResultType> aggregatorDefinition;

    public ModifiableStatisticQueryDefinition(Locale locale, DataRetrieverChainDefinition<DataSourceType, DataType> retrieverChain, Function<ExtractedType> statisticToCalculate, AggregationProcessorDefinition<ExtractedType, ResultType> aggregatorDefinition) {
        this.locale = locale;
        this.retrieverChain = retrieverChain;
        this.retrieverSettings = new HashMap();
        this.filterSelection = new HashMap();
        this.dimensionsToGroupBy = new ArrayList();
        this.statisticToCalculate = statisticToCalculate;
        this.aggregatorDefinition = aggregatorDefinition;
    }

    @Override
    public Class<DataSourceType> getDataSourceType() {
        return this.retrieverChain.getDataSourceType();
    }

    @Override
    public Class<DataType> getDataType() {
        return this.retrieverChain.getRetrievedDataType();
    }

    @Override
    public Class<ExtractedType> getExtractedType() {
        return this.aggregatorDefinition.getExtractedType();
    }

    @Override
    public Class<ResultType> getResultType() {
        return this.aggregatorDefinition.getAggregatedType();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public DataRetrieverChainDefinition<DataSourceType, DataType> getDataRetrieverChainDefinition() {
        return this.retrieverChain;
    }

    @Override
    public Map<DataRetrieverLevel<?, ?>, SerializableSettings> getRetrieverSettings() {
        return this.retrieverSettings;
    }

    @Override
    public Map<DataRetrieverLevel<?, ?>, Map<Function<?>, Collection<?>>> getFilterSelection() {
        return this.filterSelection;
    }

    @Override
    public List<Function<?>> getDimensionsToGroupBy() {
        return this.dimensionsToGroupBy;
    }

    @Override
    public Function<ExtractedType> getStatisticToCalculate() {
        return this.statisticToCalculate;
    }

    @Override
    public AggregationProcessorDefinition<ExtractedType, ResultType> getAggregatorDefinition() {
        return this.aggregatorDefinition;
    }

    public void setRetrieverSettings(DataRetrieverLevel<?, ?> retrieverLevel, SerializableSettings settings) {
        this.retrieverSettings.put(retrieverLevel, settings);
    }

    public void setFilterSelection(DataRetrieverLevel<?, ?> retrieverLevel, Function<?> dimensionToFilterBy, Collection<?> filterSelection) {
        if (!this.filterSelection.containsKey(retrieverLevel)) {
            this.filterSelection.put(retrieverLevel, new HashMap());
        }
        this.filterSelection.get(retrieverLevel).put(dimensionToFilterBy, filterSelection);
    }

    public void addDimensionToGroupBy(Function<?> dimensionToGroupBy) {
        this.dimensionsToGroupBy.add(dimensionToGroupBy);
    }
}

