/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.DataMiningBundleService;
import com.sap.sse.datamining.DataMiningPredefinedQueryService;
import com.sap.sse.datamining.DataMiningServer;
import com.sap.sse.datamining.DataSourceProvider;
import com.sap.sse.datamining.ModifiableDataMiningServer;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.impl.DataMiningExecutorService;
import com.sap.sse.datamining.impl.DataMiningServerImpl;
import com.sap.sse.datamining.impl.components.aggregators.ParallelGroupedDataCountAggregationProcessor;
import com.sap.sse.datamining.impl.components.aggregators.ParallelGroupedDataCountDistinctAggregationProcessor;
import com.sap.sse.datamining.impl.components.aggregators.ParallelGroupedNumberDataAverageAggregationProcessor;
import com.sap.sse.datamining.impl.components.aggregators.ParallelGroupedNumberDataMaxAggregationProcessor;
import com.sap.sse.datamining.impl.components.aggregators.ParallelGroupedNumberDataMedianAggregationProcessor;
import com.sap.sse.datamining.impl.components.aggregators.ParallelGroupedNumberDataMinAggregationProcessor;
import com.sap.sse.datamining.impl.components.aggregators.ParallelGroupedNumberDataSumAggregationProcessor;
import com.sap.sse.datamining.impl.components.aggregators.ParallelGroupedNumberPairAverageAggregationProcessor;
import com.sap.sse.datamining.impl.components.aggregators.ParallelGroupedNumberPairCollectingProcessor;
import com.sap.sse.datamining.impl.components.management.AggregationProcessorDefinitionManager;
import com.sap.sse.datamining.impl.components.management.DataRetrieverChainDefinitionManager;
import com.sap.sse.datamining.impl.components.management.DataSourceProviderManager;
import com.sap.sse.datamining.impl.components.management.FunctionManager;
import com.sap.sse.datamining.impl.components.management.QueryDefinitionDTOManager;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.PredefinedQueryIdentifier;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.i18n.impl.ResourceBundleStringMessagesImpl;
import com.sap.sse.util.ThreadPoolUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DataMiningFrameworkActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(DataMiningFrameworkActivator.class.getName());
    private static final String STRING_MESSAGES_BASE_NAME = "stringmessages/StringMessages";
    private static final int THREAD_POOL_SIZE = ThreadPoolUtil.INSTANCE.getReasonableThreadPoolSize();
    private static DataMiningFrameworkActivator INSTANCE;
    private ServiceTracker<DataMiningBundleService, DataMiningBundleService> dataMiningBundleServiceTracker;
    private ServiceTracker<DataMiningPredefinedQueryService, DataMiningPredefinedQueryService> dataMiningPredefinedQueryServiceTracker;
    private final Collection<ServiceRegistration<?>> serviceRegistrations;
    private final Map<ClassLoader, Set<DataMiningBundleService>> dataMiningBundleServicesByTheirClassLoaders;
    private final ModifiableDataMiningServer dataMiningServer = this.createDataMiningServer();

    public DataMiningFrameworkActivator() {
        this.serviceRegistrations = new HashSet();
        this.dataMiningBundleServicesByTheirClassLoaders = new HashMap<ClassLoader, Set<DataMiningBundleService>>();
    }

    private ModifiableDataMiningServer createDataMiningServer() {
        DataMiningExecutorService executor = new DataMiningExecutorService(THREAD_POOL_SIZE);
        FunctionManager functionRegistry = new FunctionManager();
        DataSourceProviderManager dataSourceProviderRegistry = new DataSourceProviderManager();
        DataRetrieverChainDefinitionManager dataRetrieverChainDefinitionRegistry = new DataRetrieverChainDefinitionManager();
        AggregationProcessorDefinitionManager aggregationProcessorDefinitionRegistry = new AggregationProcessorDefinitionManager();
        QueryDefinitionDTOManager queryDefinitionRegistry = new QueryDefinitionDTOManager();
        DataMiningServerImpl dataMiningServer = new DataMiningServerImpl(executor, functionRegistry, dataSourceProviderRegistry, dataRetrieverChainDefinitionRegistry, aggregationProcessorDefinitionRegistry, queryDefinitionRegistry);
        dataMiningServer.addStringMessages((ResourceBundleStringMessages)new ResourceBundleStringMessagesImpl(STRING_MESSAGES_BASE_NAME, this.getClass().getClassLoader(), StandardCharsets.UTF_8.name()));
        for (AggregationProcessorDefinition<?, ?> aggregationProcessorDefinition : this.getDefaultAggregationProcessors()) {
            dataMiningServer.registerAggregationProcessor(aggregationProcessorDefinition);
        }
        return dataMiningServer;
    }

    private Iterable<AggregationProcessorDefinition<?, ?>> getDefaultAggregationProcessors() {
        HashSet defaultAggregationProcessors = new HashSet();
        defaultAggregationProcessors.add(ParallelGroupedDataCountDistinctAggregationProcessor.getDefinition());
        defaultAggregationProcessors.add(ParallelGroupedDataCountAggregationProcessor.getDefinition());
        defaultAggregationProcessors.add(ParallelGroupedNumberDataAverageAggregationProcessor.getDefinition());
        defaultAggregationProcessors.add(ParallelGroupedNumberPairAverageAggregationProcessor.getDefinition());
        defaultAggregationProcessors.add(ParallelGroupedNumberPairCollectingProcessor.getDefinition());
        defaultAggregationProcessors.add(ParallelGroupedNumberDataMaxAggregationProcessor.getDefinition());
        defaultAggregationProcessors.add(ParallelGroupedNumberDataMedianAggregationProcessor.getDefinition());
        defaultAggregationProcessors.add(ParallelGroupedNumberDataMinAggregationProcessor.getDefinition());
        defaultAggregationProcessors.add(ParallelGroupedNumberDataSumAggregationProcessor.getDefinition());
        return defaultAggregationProcessors;
    }

    public void start(final BundleContext context) throws Exception {
        INSTANCE = this;
        this.dataMiningBundleServiceTracker = new ServiceTracker(context, DataMiningBundleService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<DataMiningBundleService, DataMiningBundleService>(){

            public DataMiningBundleService addingService(ServiceReference<DataMiningBundleService> reference) {
                DataMiningBundleService dataMiningBundleService = (DataMiningBundleService)context.getService(reference);
                DataMiningFrameworkActivator.this.registerDataMiningBundle(dataMiningBundleService);
                return dataMiningBundleService;
            }

            public void modifiedService(ServiceReference<DataMiningBundleService> reference, DataMiningBundleService service) {
            }

            public void removedService(ServiceReference<DataMiningBundleService> reference, DataMiningBundleService dataMiningBundleService) {
                DataMiningFrameworkActivator.this.unregisterDataMiningBundle(dataMiningBundleService);
            }
        });
        this.dataMiningBundleServiceTracker.open();
        this.dataMiningPredefinedQueryServiceTracker = new ServiceTracker(context, DataMiningPredefinedQueryService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<DataMiningPredefinedQueryService, DataMiningPredefinedQueryService>(){

            public DataMiningPredefinedQueryService addingService(ServiceReference<DataMiningPredefinedQueryService> reference) {
                DataMiningPredefinedQueryService predefinedQueryService = (DataMiningPredefinedQueryService)context.getService(reference);
                for (Map.Entry<PredefinedQueryIdentifier, StatisticQueryDefinitionDTO> predefinedQueryEntry : predefinedQueryService.getPredefinedQueries().entrySet()) {
                    DataMiningFrameworkActivator.this.dataMiningServer.registerPredefinedQueryDefinition(predefinedQueryEntry.getKey(), predefinedQueryEntry.getValue());
                }
                return predefinedQueryService;
            }

            public void modifiedService(ServiceReference<DataMiningPredefinedQueryService> reference, DataMiningPredefinedQueryService service) {
            }

            public void removedService(ServiceReference<DataMiningPredefinedQueryService> reference, DataMiningPredefinedQueryService predefinedQueryService) {
                for (Map.Entry<PredefinedQueryIdentifier, StatisticQueryDefinitionDTO> predefinedQueryEntry : predefinedQueryService.getPredefinedQueries().entrySet()) {
                    DataMiningFrameworkActivator.this.dataMiningServer.unregisterPredefinedQueryDefinition(predefinedQueryEntry.getKey(), predefinedQueryEntry.getValue());
                }
            }
        });
        this.dataMiningPredefinedQueryServiceTracker.open();
        this.serviceRegistrations.add(context.registerService(DataMiningServer.class, (Object)this.dataMiningServer, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDataMiningBundle(DataMiningBundleService dataMiningBundleService) {
        logger.info("Registering data mining bundle " + dataMiningBundleService);
        Map<ClassLoader, Set<DataMiningBundleService>> map = this.dataMiningBundleServicesByTheirClassLoaders;
        synchronized (map) {
            ClassLoader classLoader = dataMiningBundleService.getClassLoader();
            Util.addToValueSet(this.dataMiningBundleServicesByTheirClassLoaders, (Object)classLoader, (Object)dataMiningBundleService);
            if (this.dataMiningBundleServicesByTheirClassLoaders.get(classLoader).size() == 1) {
                this.dataMiningServer.addDataMiningBundleClassLoader(classLoader);
            }
        }
        this.dataMiningServer.addStringMessages(dataMiningBundleService.getStringMessages());
        this.dataMiningServer.registerAllClasses(dataMiningBundleService.getClassesWithMarkedMethods());
        for (DataSourceProvider<?> dataSourceProvider : dataMiningBundleService.getDataSourceProviders()) {
            this.dataMiningServer.registerDataSourceProvider(dataSourceProvider);
        }
        for (DataRetrieverChainDefinition dataRetrieverChainDefinition : dataMiningBundleService.getDataRetrieverChainDefinitions()) {
            this.dataMiningServer.registerDataRetrieverChainDefinition(dataRetrieverChainDefinition);
        }
        for (AggregationProcessorDefinition aggregationProcessorDefinition : dataMiningBundleService.getAggregationProcessorDefinitions()) {
            this.dataMiningServer.registerAggregationProcessor(aggregationProcessorDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterDataMiningBundle(DataMiningBundleService dataMiningBundleService) {
        logger.info("Unregistering data mining bundle " + dataMiningBundleService);
        Map<ClassLoader, Set<DataMiningBundleService>> map = this.dataMiningBundleServicesByTheirClassLoaders;
        synchronized (map) {
            ClassLoader classLoader = dataMiningBundleService.getClassLoader();
            if (this.dataMiningBundleServicesByTheirClassLoaders.get(classLoader).size() == 1) {
                this.dataMiningServer.removeDataMiningBundleClassLoader(dataMiningBundleService.getClassLoader());
            }
            Util.removeFromValueSet(this.dataMiningBundleServicesByTheirClassLoaders, (Object)classLoader, (Object)dataMiningBundleService);
        }
        this.dataMiningServer.removeStringMessages(dataMiningBundleService.getStringMessages());
        this.dataMiningServer.unregisterAllFunctionsOf(dataMiningBundleService.getClassesWithMarkedMethods());
        for (DataSourceProvider<?> dataSourceProvider : dataMiningBundleService.getDataSourceProviders()) {
            this.dataMiningServer.unregisterDataSourceProvider(dataSourceProvider);
        }
        for (DataRetrieverChainDefinition dataRetrieverChainDefinition : dataMiningBundleService.getDataRetrieverChainDefinitions()) {
            this.dataMiningServer.unregisterDataRetrieverChainDefinition(dataRetrieverChainDefinition);
        }
        for (AggregationProcessorDefinition aggregationProcessorDefinition : dataMiningBundleService.getAggregationProcessorDefinitions()) {
            this.dataMiningServer.unregisterAggregationProcessor(aggregationProcessorDefinition);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.dataMiningBundleServiceTracker.close();
        this.dataMiningPredefinedQueryServiceTracker.close();
        for (ServiceRegistration<?> serviceRegistration : this.serviceRegistrations) {
            context.ungetService(serviceRegistration.getReference());
        }
    }

    public static DataMiningFrameworkActivator getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new DataMiningFrameworkActivator();
        }
        return INSTANCE;
    }
}

