/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import smile.data.Attribute;
import smile.data.NumericAttribute;
import smile.math.Math;

public class AttributeVector {
    private Attribute attribute;
    private double[] vector;
    private String[] names;

    public AttributeVector(Attribute attribute, double[] vector) {
        this.attribute = attribute;
        this.vector = vector;
    }

    public AttributeVector(Attribute attribute, double[] vector, String[] names) {
        this.attribute = attribute;
        this.vector = vector;
        this.names = names;
    }

    public Attribute attribute() {
        return this.attribute;
    }

    public double[] vector() {
        return this.vector;
    }

    public String[] names() {
        return this.names;
    }

    public int size() {
        return this.vector.length;
    }

    public String toString() {
        int n = 10;
        String s = this.head(n);
        if (this.vector.length <= n) {
            return s;
        }
        return s + "\n" + (this.vector.length - n) + " more values...";
    }

    public String head(int n) {
        return this.toString(0, n);
    }

    public String tail(int n) {
        return this.toString(this.vector.length - n, this.vector.length);
    }

    public String toString(int from, int to) {
        StringBuilder sb = new StringBuilder();
        sb.append('\t');
        sb.append(this.attribute.getName());
        int end = Math.min((int)this.vector.length, (int)to);
        for (int i = from; i < end; ++i) {
            sb.append(System.getProperty("line.separator"));
            if (this.names != null) {
                sb.append(this.names[i]);
            } else {
                sb.append('[');
                sb.append(i + 1);
                sb.append(']');
            }
            sb.append('\t');
            if (this.attribute.getType() == Attribute.Type.NUMERIC) {
                sb.append(String.format("%1.4f", this.vector[i]));
                continue;
            }
            sb.append(this.attribute.toString(this.vector[i]));
        }
        return sb.toString();
    }

    public AttributeVector summary() {
        NumericAttribute attr = new NumericAttribute(this.attribute.getName() + " Summary");
        String[] names = new String[]{"min", "q1", "median", "mean", "q3", "max"};
        double[] stat = new double[]{Math.min((double[])this.vector), Math.q1((double[])this.vector), Math.median((double[])this.vector), Math.mean((double[])this.vector), Math.q3((double[])this.vector), Math.max((double[])this.vector)};
        return new AttributeVector(attr, stat, names);
    }
}

