/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.Chunk;
import difflib.Delta;
import difflib.PatchFailedException;
import java.util.List;

public class InsertDelta<T>
extends Delta<T> {
    public InsertDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        List lines = this.getRevised().getLines();
        int i = 0;
        while (i < lines.size()) {
            target.add(position + i, lines.get(i));
            ++i;
        }
    }

    @Override
    public void restore(List<T> target) {
        int position = this.getRevised().getPosition();
        int size = this.getRevised().size();
        int i = 0;
        while (i < size) {
            target.remove(position);
            ++i;
        }
    }

    @Override
    public void verify(List<T> target) throws PatchFailedException {
        if (this.getOriginal().getPosition() > target.size()) {
            throw new PatchFailedException("Incorrect patch for delta: delta original position > target size");
        }
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.INSERT;
    }

    public String toString() {
        return "[InsertDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getRevised().getLines() + "]";
    }
}

