/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.jaxrs.client;

import com.sap.sailing.polars.ReplicablePolarService;
import com.sap.sse.util.LaxRedirectStrategyForAllRedirectResponseCodes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.parser.ParseException;

public class PolarDataClient {
    private static final Logger logger = Logger.getLogger(PolarDataClient.class.getName());
    private static final String RESOURCE = "polars/api/polar_data";
    private final ReplicablePolarService polarDataService;
    private final String polarDataSourceURL;
    private final Optional<String> polarDataBearerToken;

    public PolarDataClient(String polarDataSourceURL, ReplicablePolarService polarDataService, Optional<String> polarDataBearerToken) {
        this.polarDataService = polarDataService;
        this.polarDataSourceURL = polarDataSourceURL;
        this.polarDataBearerToken = polarDataBearerToken;
    }

    public void updatePolarDataRegressions() throws IOException, ParseException, InterruptedException, ClassNotFoundException {
        try {
            logger.log(Level.INFO, "Loading polar regression data from remote server " + this.polarDataSourceURL);
            InputStream inputStream = this.getContentFromResponse();
            this.polarDataService.clearReplicaState();
            this.polarDataService.initiallyFillFrom(inputStream);
            logger.log(Level.INFO, "Loading polar regression data from remote server " + this.polarDataSourceURL + " succeeded");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to load polar regression data from remote server " + this.polarDataSourceURL + ", " + e.getMessage() + "; resetting polar data miner");
            this.polarDataService.resetState();
        }
    }

    private String getAPIString() {
        return String.valueOf(this.polarDataSourceURL) + (this.polarDataSourceURL.endsWith("/") ? "" : "/") + RESOURCE;
    }

    protected InputStream getContentFromResponse() throws IOException, ParseException {
        CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
        HttpGet getProcessor = new HttpGet(this.getAPIString());
        this.polarDataBearerToken.ifPresent(bearerToken -> getProcessor.setHeader("Authorization", "Bearer " + bearerToken));
        HttpResponse processorResponse = client.execute((HttpUriRequest)getProcessor);
        if (processorResponse.getStatusLine().getStatusCode() >= 300) {
            throw new IOException("Error trying to load polar data from " + this.getAPIString() + ": " + processorResponse.getStatusLine().getReasonPhrase() + " (" + processorResponse.getStatusLine().getStatusCode() + ")");
        }
        return processorResponse.getEntity().getContent();
    }
}

