/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprintRegistry;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.impl.AbstractRaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.TracTracRaceTracker;
import com.sap.sailing.domain.tractracadapter.impl.TracTracRaceTrackerImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.tractrac.model.lib.api.ModelLocator;
import com.tractrac.model.lib.api.event.CreateModelException;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.subscription.lib.api.SubscriberInitializationException;
import com.tractrac.util.lib.api.exceptions.TimeOutException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;

public class RaceTrackingConnectivityParametersImpl
extends AbstractRaceTrackingConnectivityParameters {
    private static final long serialVersionUID = 5088282956033068149L;
    private static final Logger logger = Logger.getLogger(RaceTrackingConnectivityParametersImpl.class.getName());
    public static final String TYPE = "TRAC_TRAC";
    private final URL paramURL;
    private final URI liveURI;
    private final URI liveURIFromConfiguration;
    private final URI storedURI;
    private final URI storedURIFromConfiguration;
    private final URI updateURI;
    private final TimePoint startOfTracking;
    private final TimePoint endOfTracking;
    private final transient RaceLogStore raceLogStore;
    private final transient RegattaLogStore regattaLogStore;
    private final transient DomainFactory domainFactory;
    private final long delayToLiveInMillis;
    private final Duration offsetToStartTimeOfSimulatedRace;
    private final String tracTracApiToken;
    private final String raceStatus;
    private final String raceVisibility;
    private final boolean useInternalMarkPassingAlgorithm;
    private final boolean preferReplayIfAvailable;
    private final int timeoutInMillis;
    private final boolean useOfficialEventsToUpdateRaceLog;

    public RaceTrackingConnectivityParametersImpl(URL paramURL, URI liveURI, URI storedURI, URI updateURI, TimePoint startOfTracking, TimePoint endOfTracking, long delayToLiveInMillis, Duration offsetToStartTimeOfSimulatedRace, boolean useInternalMarkPassingAlgorithm, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, DomainFactory domainFactory, String tracTracApiToken, String raceStatus, String raceVisibility, boolean trackWind, boolean correctWindDirectionByMagneticDeclination, boolean preferReplayIfAvailable, int timeoutInMillis, boolean useOfficialEventsToUpdateRaceLog, URI liveURIFromConfiguration, URI storedURIFromConfiguration) throws Exception {
        super(trackWind, correctWindDirectionByMagneticDeclination);
        this.useOfficialEventsToUpdateRaceLog = useOfficialEventsToUpdateRaceLog;
        this.paramURL = paramURL;
        this.timeoutInMillis = timeoutInMillis;
        this.tracTracApiToken = tracTracApiToken;
        IRace tractracRace = this.getTractracRace();
        if (preferReplayIfAvailable && this.isReplayRace(tractracRace) && (!Util.equalsWithNull((Object)liveURI, (Object)tractracRace.getLiveURI()) || !Util.equalsWithNull((Object)storedURI, (Object)tractracRace.getStoredURI()))) {
            logger.info("Replay format available and preferred for race " + tractracRace.getName() + "; using storedURI " + tractracRace.getStoredURI() + " instead of " + storedURI + " and liveURI " + tractracRace.getLiveURI() + " instead of " + liveURI);
            this.liveURI = tractracRace.getLiveURI();
            this.storedURI = tractracRace.getStoredURI();
        } else {
            this.liveURI = liveURI;
            this.storedURI = storedURI;
        }
        this.updateURI = updateURI;
        this.startOfTracking = startOfTracking;
        this.endOfTracking = endOfTracking;
        this.delayToLiveInMillis = delayToLiveInMillis;
        this.domainFactory = domainFactory;
        this.offsetToStartTimeOfSimulatedRace = offsetToStartTimeOfSimulatedRace;
        this.raceLogStore = raceLogStore;
        this.regattaLogStore = regattaLogStore;
        this.raceStatus = raceStatus;
        this.raceVisibility = raceVisibility;
        this.useInternalMarkPassingAlgorithm = useInternalMarkPassingAlgorithm;
        this.preferReplayIfAvailable = preferReplayIfAvailable;
        this.liveURIFromConfiguration = liveURIFromConfiguration;
        this.storedURIFromConfiguration = storedURIFromConfiguration;
    }

    public boolean isReplayRace(IRace tractracRace) {
        return tractracRace.getStoredURI() != null && tractracRace.getStoredURI().toString().toLowerCase().endsWith(".mtb");
    }

    public IRace getTractracRace() throws CreateModelException, URISyntaxException, TimeOutException {
        IRace result = this.getTimeoutInMillis() == -1 ? ModelLocator.getEventFactory().createRace(this.tracTracApiToken, new URI(this.paramURL.toString())) : ModelLocator.getEventFactory().createRace(this.tracTracApiToken, new URI(this.paramURL.toString()), this.getTimeoutInMillis());
        return result;
    }

    public String getTypeIdentifier() {
        return TYPE;
    }

    public RaceTracker createRaceTracker(TrackedRegattaRegistry trackedRegattaRegistry, WindStore windStore, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry, ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry) throws URISyntaxException, CreateModelException, SubscriberInitializationException, IOException, InterruptedException, TimeOutException {
        TracTracRaceTracker tracker = this.domainFactory.createRaceTracker(this.raceLogStore, this.regattaLogStore, windStore, trackedRegattaRegistry, raceLogResolver, leaderboardGroupResolver, this, timeoutInMilliseconds, raceTrackingHandler, markPassingRaceFingerprintRegistry, maneuverRaceFingerprintRegistry);
        return tracker;
    }

    public RaceTracker createRaceTracker(Regatta regatta, TrackedRegattaRegistry trackedRegattaRegistry, WindStore windStore, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry, ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry) throws Exception {
        RaceTracker tracker = this.domainFactory.createRaceTracker(regatta, this.raceLogStore, this.regattaLogStore, windStore, trackedRegattaRegistry, raceLogResolver, leaderboardGroupResolver, this, timeoutInMilliseconds, raceTrackingHandler, markPassingRaceFingerprintRegistry, maneuverRaceFingerprintRegistry);
        return tracker;
    }

    public Object getTrackerID() {
        return TracTracRaceTrackerImpl.createID(this.paramURL, this.liveURI, this.storedURI);
    }

    public long getDelayToLiveInMillis() {
        return this.delayToLiveInMillis;
    }

    public URL getParamURL() {
        return this.paramURL;
    }

    public URI getLiveURI() {
        return this.liveURI;
    }

    public URI getStoredURI() {
        return this.storedURI;
    }

    public URI getLiveURIFromConfiguration() {
        return this.liveURIFromConfiguration;
    }

    public URI getStoredURIFromConfiguration() {
        return this.storedURIFromConfiguration;
    }

    public URI getUpdateURI() {
        return this.updateURI;
    }

    public TimePoint getStartOfTracking() {
        return this.startOfTracking;
    }

    public TimePoint getEndOfTracking() {
        return this.endOfTracking;
    }

    public Duration getOffsetToStartTimeOfSimulatedRace() {
        return this.offsetToStartTimeOfSimulatedRace;
    }

    public String getTracTracApiToken() {
        return this.tracTracApiToken;
    }

    public String getRaceStatus() {
        return this.raceStatus;
    }

    public String getRaceVisibility() {
        return this.raceVisibility;
    }

    public boolean isUseInternalMarkPassingAlgorithm() {
        return this.useInternalMarkPassingAlgorithm;
    }

    public boolean isPreferReplayIfAvailable() {
        return this.preferReplayIfAvailable;
    }

    public int getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public boolean isUseOfficialEventsToUpdateRaceLog() {
        return this.useOfficialEventsToUpdateRaceLog;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " for " + this.paramURL + ", liveURI: " + this.liveURI + ", storedURI: " + this.storedURI + ", useOfficialEventsToUpdateRaceLog: " + this.useOfficialEventsToUpdateRaceLog;
    }
}

