/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.impl.AbstractReceiverWithQueue;
import com.sap.sailing.domain.tractracadapter.impl.Simulator;
import com.sap.sse.common.Util;
import com.tractrac.model.lib.api.data.IPosition;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.map.IPositionedItem;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.map.IPositionedItemPositionListener;
import java.util.logging.Logger;

public class MarkPositionReceiver
extends AbstractReceiverWithQueue<IPositionedItem, IPosition, Void> {
    private static final Logger logger = Logger.getLogger(MarkPositionReceiver.class.getName());
    private int received;
    private final IRace tractracRace;
    final IPositionedItemPositionListener listener;
    private boolean singleMarksEnsuredAlready;

    public MarkPositionReceiver(DynamicTrackedRegatta trackedRegatta, IEvent tractracEvent, IRace tractracRace, Simulator simulator, DomainFactory domainFactory, IEventSubscriber eventSubscriber, IRaceSubscriber raceSubscriber, long timeoutInMilliseconds) {
        super(domainFactory, tractracEvent, trackedRegatta, simulator, eventSubscriber, raceSubscriber, timeoutInMilliseconds);
        this.tractracRace = tractracRace;
        if (tractracEvent.getRaces().isEmpty()) {
            throw new IllegalArgumentException("Can't receive mark positions from event " + tractracEvent.getName() + " that has no race");
        }
        this.listener = new IPositionedItemPositionListener(){

            public void gotPositionedItemPosition(IPositionedItem mark, IPosition position) {
                MarkPositionReceiver.this.enqueue(new Util.Triple((Object)mark, (Object)position, null));
            }
        };
    }

    @Override
    public void subscribe() {
        this.getRaceSubscriber().subscribePositionedItemPositions(this.listener);
        this.startThread();
    }

    @Override
    protected void unsubscribe() {
        this.getRaceSubscriber().unsubscribePositionedItemPositions(this.listener);
    }

    @Override
    protected void handleEvent(Util.Triple<IPositionedItem, IPosition, Void> event) {
        String markCourseArea = event.getA() == null ? null : ((IPositionedItem)event.getA()).getCourseArea();
        String raceCourseArea = this.tractracRace.getCourseArea();
        if (markCourseArea == null || raceCourseArea == null || markCourseArea.equals(raceCourseArea)) {
            if (this.received++ % 1000 == 0) {
                System.out.print("M");
                if ((this.received / 1000 + 1) % 80 == 0) {
                    System.out.println();
                }
            }
            if (!this.singleMarksEnsuredAlready) {
                this.singleMarksEnsuredAlready = true;
                this.ensureAllSingleMarksOfCourseAreaAreCreated(this.tractracRace);
            }
            Mark mark = this.getDomainFactory().getMark((IPositionedItem)event.getA());
            DynamicTrackedRace trackedRace = this.getTrackedRace(this.tractracRace);
            if (trackedRace != null) {
                GPSFixMoving markPosition = this.getDomainFactory().createGPSFixMoving((IPosition)event.getB());
                if (this.getSimulator() != null) {
                    this.getSimulator().scheduleMarkPosition(mark, markPosition);
                } else {
                    trackedRace.recordFix(mark, (GPSFix)markPosition);
                }
            } else {
                logger.warning("Couldn't find tracked race for race " + this.tractracRace.getName() + ". Dropping mark position event " + event);
            }
        }
    }
}

