/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasRaceOfCompetitorContext;
import com.sap.sailing.datamining.data.HasTrackedRaceContext;
import com.sap.sailing.datamining.impl.data.RaceOfCompetitorWithContext;
import com.sap.sailing.datamining.shared.TackTypeSegmentsDataMiningSettings;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class RaceOfCompetitorRetrievalProcessor
extends AbstractRetrievalProcessor<HasTrackedRaceContext, HasRaceOfCompetitorContext> {
    private final TackTypeSegmentsDataMiningSettings settings;

    public RaceOfCompetitorRetrievalProcessor(ExecutorService executor, Collection<Processor<HasRaceOfCompetitorContext, ?>> resultReceivers, TackTypeSegmentsDataMiningSettings settings, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasTrackedRaceContext.class, HasRaceOfCompetitorContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
        this.settings = settings;
    }

    protected Iterable<HasRaceOfCompetitorContext> retrieveData(HasTrackedRaceContext element) {
        ArrayList<HasRaceOfCompetitorContext> raceOfCompetitorsWithContext = new ArrayList<HasRaceOfCompetitorContext>();
        if (element.getTrackedRace() != null) {
            for (Competitor competitor : element.getTrackedRace().getRace().getCompetitors()) {
                if (this.isAborted()) break;
                Subject subject = SecurityUtils.getSubject();
                if (!subject.isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC))) continue;
                RaceOfCompetitorWithContext raceOfCompetitorWithContext = new RaceOfCompetitorWithContext(element, competitor, this.settings);
                raceOfCompetitorsWithContext.add(raceOfCompetitorWithContext);
            }
        }
        return raceOfCompetitorsWithContext;
    }
}

