/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.sensordata.BravoSensorDataMetadata;
import com.sap.sailing.domain.common.sensordata.ColumnMetadata;
import com.sap.sailing.domain.common.tracking.BravoFix;
import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.common.tracking.impl.SensorFixImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.impl.DegreeBearingImpl;

public class BravoFixImpl
extends SensorFixImpl
implements BravoFix {
    private static final long serialVersionUID = 2033254212013221160L;

    public BravoFixImpl(DoubleVectorFix fix) {
        super(fix);
    }

    @Override
    protected ColumnMetadata resolveMetadataFromValueName(String valueName) {
        return BravoSensorDataMetadata.byColumnName(valueName);
    }

    @Override
    public Distance getRideHeight() {
        Double rideHeightPortHullAsDouble = this.fix.get(BravoSensorDataMetadata.RIDE_HEIGHT_PORT_HULL.getColumnIndex());
        Double rideHeightStarboardHullAsDouble = this.fix.get(BravoSensorDataMetadata.RIDE_HEIGHT_STBD_HULL.getColumnIndex());
        return rideHeightPortHullAsDouble == null ? (rideHeightStarboardHullAsDouble == null ? null : new MeterDistance(rideHeightStarboardHullAsDouble)) : (rideHeightStarboardHullAsDouble == null ? new MeterDistance(rideHeightPortHullAsDouble) : new MeterDistance(Math.min(rideHeightPortHullAsDouble, rideHeightStarboardHullAsDouble)));
    }

    @Override
    public Distance getRideHeightPortHull() {
        double rideHeightPortHullasDouble = this.fix.get(BravoSensorDataMetadata.RIDE_HEIGHT_PORT_HULL.getColumnIndex());
        return new MeterDistance(rideHeightPortHullasDouble);
    }

    @Override
    public Distance getRideHeightStarboardHull() {
        double rideHeightStarboardHullasDouble = this.fix.get(BravoSensorDataMetadata.RIDE_HEIGHT_STBD_HULL.getColumnIndex());
        return new MeterDistance(rideHeightStarboardHullasDouble);
    }

    @Override
    public boolean isFoiling() {
        return this.isFoiling(MIN_FOILING_HEIGHT_THRESHOLD);
    }

    @Override
    public boolean isFoiling(Distance minimumRideHeight) {
        Distance rideHeight = this.getRideHeight();
        return rideHeight != null && rideHeight.compareTo((Object)minimumRideHeight) >= 0;
    }

    @Override
    public Bearing getPitch() {
        Double bearingDeg = this.fix.get(BravoSensorDataMetadata.PITCH.getColumnIndex());
        return bearingDeg == null ? null : new DegreeBearingImpl(bearingDeg.doubleValue());
    }

    @Override
    public Bearing getHeel() {
        Double bearingDeg = this.fix.get(BravoSensorDataMetadata.HEEL.getColumnIndex());
        return bearingDeg == null ? null : new DegreeBearingImpl(bearingDeg.doubleValue());
    }
}

