/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;

public class WindImpl
extends KnotSpeedWithBearingImpl
implements Wind {
    private static final long serialVersionUID = 5431592324949471980L;
    private final Position position;
    private final TimePoint timepoint;

    public WindImpl(Position p, TimePoint at, SpeedWithBearing windSpeedWithBearing) {
        super(windSpeedWithBearing.getKnots(), windSpeedWithBearing.getBearing());
        this.position = p;
        this.timepoint = at;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public TimePoint getTimePoint() {
        return this.timepoint;
    }

    @Override
    public Bearing getFrom() {
        return this.getBearing().reverse();
    }

    public static int hashCode(double latDeg, double lngDeg, long timePointAsMillis) {
        return 31 * (int)(timePointAsMillis & Integer.MAX_VALUE) ^ (int)(Math.round(latDeg) * Math.round(lngDeg));
    }

    @Override
    public int hashCode() {
        return WindImpl.hashCode(this.position.getLatDeg(), this.position.getLngDeg(), this.timepoint == null ? 0L : this.timepoint.asMillis());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Wind)) {
            return false;
        }
        Wind other = (Wind)obj;
        if (this.position == null ? other.getPosition() != null : !this.position.equals(other.getPosition())) {
            return false;
        }
        return !(this.timepoint == null ? other.getTimePoint() != null : !this.timepoint.equals(other.getTimePoint()));
    }

    @Override
    public String toString() {
        return this.getTimePoint() + "@" + this.getPosition() + ": " + this.getKnots() + "kn from " + this.getFrom();
    }
}

