/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.domain.common.Wind;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;

public class TargetTimeInfoImpl
implements TargetTimeInfo {
    private final Iterable<TargetTimeInfo.LegTargetTimeInfo> legInfos;

    public TargetTimeInfoImpl(Iterable<TargetTimeInfo.LegTargetTimeInfo> legInfos) {
        this.legInfos = legInfos;
    }

    @Override
    public TimePoint getExpectedStartTimePoint() {
        return Util.isEmpty(this.legInfos) ? null : this.legInfos.iterator().next().getExpectedStartTimePoint();
    }

    @Override
    public Duration getExpectedDuration() {
        Duration result = Duration.NULL;
        for (TargetTimeInfo.LegTargetTimeInfo legInfo : this.legInfos) {
            result = result.plus(legInfo.getExpectedDuration());
        }
        return result;
    }

    @Override
    public Iterable<TargetTimeInfo.LegTargetTimeInfo> getLegTargetTimes() {
        return this.legInfos;
    }

    @Override
    public Duration getExpectedDuration(LegType spentInLegsOfType) {
        Duration result = Duration.NULL;
        for (TargetTimeInfo.LegTargetTimeInfo legInfo : this.legInfos) {
            if (legInfo.getLegType() != spentInLegsOfType) continue;
            result = result.plus(legInfo.getExpectedDuration());
        }
        return result;
    }

    public String toString() {
        return "TargetTimeInfoImpl [legInfos=" + this.legInfos + "]";
    }

    @Override
    public Distance getExpectedDistance() {
        Distance.NullDistance result = Distance.NULL;
        for (TargetTimeInfo.LegTargetTimeInfo legInfo : this.legInfos) {
            result = result.add(legInfo.getExpectedDistance());
        }
        return result;
    }

    public static class LegTargetTimeInfoImpl
    implements TargetTimeInfo.LegTargetTimeInfo {
        private final Distance distance;
        private final Wind wind;
        private final Bearing legBearing;
        private final Duration expectedDuration;
        private final TimePoint expectedStartTimePoint;
        private final LegType legType;
        private Distance expectedDistance;

        public LegTargetTimeInfoImpl(Distance distance, Wind wind, Bearing legBearing, Duration expectedDuration, TimePoint expectedStartTimePoint, LegType legType, Distance expectedDistance) {
            this.distance = distance;
            this.wind = wind;
            this.legBearing = legBearing;
            this.expectedDistance = expectedDistance;
            this.expectedDuration = expectedDuration;
            this.expectedStartTimePoint = expectedStartTimePoint;
            this.legType = legType;
        }

        @Override
        public Distance getDistance() {
            return this.distance;
        }

        @Override
        public Wind getWind() {
            return this.wind;
        }

        @Override
        public Bearing getLegBearing() {
            return this.legBearing;
        }

        @Override
        public Bearing getTrueWindAngleToLeg() {
            return this.getLegBearing().getDifferenceTo(this.getWind().getBearing().reverse());
        }

        @Override
        public Duration getExpectedDuration() {
            return this.expectedDuration;
        }

        @Override
        public TimePoint getExpectedStartTimePoint() {
            return this.expectedStartTimePoint;
        }

        @Override
        public LegType getLegType() {
            return this.legType;
        }

        public String toString() {
            return "LegTargetTimeInfoImpl [distance=" + this.distance + ", wind=" + this.wind + ", legBearing=" + this.legBearing + ", expectedDuration=" + this.expectedDuration + ", expectedStartTimePoint=" + this.expectedStartTimePoint + ", legType=" + (Object)((Object)this.legType) + "]";
        }

        @Override
        public Distance getExpectedDistance() {
            return this.expectedDistance;
        }
    }
}

