/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.apachelog;

import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.util.apachelog.LogEntry;
import com.sap.sse.util.apachelog.PerHostnameEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class UniqueIPsPerReferrer {
    private static final String GZIP_EXTENSION = ".gz";
    private static final Logger logger = Logger.getLogger(UniqueIPsPerReferrer.class.getName());
    private static final String HOSTNAME_FILE_EXTENSION = ".ips";
    private static final String UNIQUE_SUFFIX = ".unique";
    private static final String MONTH_AND_YEAR_TOTALS_SUFFIX = "_totals";
    private static final char YEAR_MONTH_SEPARATOR = '_';
    private final File CACHE;
    private final File VISITED_FILES;
    private final File STATS;
    private final File OUTPUT;
    private final File MONTHS;
    private final File YEARS;
    private final File TOTALS;
    private final File EVENTTOTALS;
    private final File TOTALS_UNIQUE;

    public UniqueIPsPerReferrer() {
        this("/var/log/old/cache/unique-ips-per-referrer/test");
    }

    public UniqueIPsPerReferrer(String cacheDir) {
        this.CACHE = new File(cacheDir);
        this.VISITED_FILES = new File(this.CACHE + "/visited");
        this.STATS = new File(this.CACHE + "/stats");
        this.OUTPUT = new File(this.STATS + "/results");
        this.MONTHS = new File(this.OUTPUT + "/permonth");
        this.YEARS = new File(this.OUTPUT + "/peryear");
        this.TOTALS = new File(this.OUTPUT + "/totals.gz");
        this.EVENTTOTALS = new File(this.OUTPUT + "/eventtotals.gz");
        this.TOTALS_UNIQUE = new File(this.OUTPUT + "/totals" + UNIQUE_SUFFIX);
        this.ensureDirectoriesExist();
    }

    public static void main(String[] args) throws IOException, ParseException {
        TimePoint started = MillisecondsTimePoint.now();
        String[] logfilenames = new String[args.length - 1];
        System.arraycopy(args, 1, logfilenames, 0, logfilenames.length);
        new UniqueIPsPerReferrer(args[0]).analyze(logfilenames);
        logger.info("Finished. Took " + started.until(MillisecondsTimePoint.now()));
    }

    public void analyze(String ... filenames) throws IOException, ParseException {
        this.appendHitsToHostnameSpecificFiles(filenames);
        this.cleanUpOldResults();
        this.computePerMonthPerYearPerEventAndTotals();
        this.countUniqueEventOccurrencesPerMonthAndPerYearAndOverall();
        this.countTotalHits();
    }

    private void ensureDirectoriesExist() {
        this.CACHE.mkdirs();
        this.STATS.mkdirs();
        this.OUTPUT.mkdirs();
        this.MONTHS.mkdirs();
        this.YEARS.mkdirs();
    }

    private Set<String> getVisitedFileNames() throws IOException {
        HashSet<String> result = new HashSet<String>();
        if (this.VISITED_FILES.exists()) {
            String visitedFileName;
            BufferedReader br = new BufferedReader(new FileReader(this.VISITED_FILES));
            while ((visitedFileName = br.readLine()) != null) {
                result.add(visitedFileName);
            }
            br.close();
        }
        return result;
    }

    private void appendHitsToHostnameSpecificFiles(String ... filenames) throws IOException {
        Set<String> visitedFileNames = this.getVisitedFileNames();
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (!this.containsIgnoringDifferenceInCompression(visitedFileNames, filename)) {
                logger.info("Analyzing log file " + filename);
                this.appendHitsToHostnameSpecificFiles(new File(filename));
                visitedFileNames.add(filename);
                this.addVisitedFile(filename);
            } else {
                logger.info("Not analyzing log file " + filename + " as it has already been analyzed before");
            }
            ++n2;
        }
    }

    private boolean containsIgnoringDifferenceInCompression(Set<String> visitedFileNames, String filename) {
        return filename.toLowerCase().endsWith(GZIP_EXTENSION) && (visitedFileNames.contains(filename) || visitedFileNames.contains(filename.substring(0, filename.length() - GZIP_EXTENSION.length()))) || !filename.toLowerCase().endsWith(GZIP_EXTENSION) && (visitedFileNames.contains(filename) || visitedFileNames.contains(String.valueOf(filename) + GZIP_EXTENSION));
    }

    private void cleanUpOldResults() throws IOException {
        logger.info("Cleaning up old results");
        this.deleteDirectoryContentsRecursively(this.MONTHS.toPath(), "...._..\\.gz");
        this.deleteDirectoryContentsRecursively(this.YEARS.toPath(), "....\\.gz");
        this.EVENTTOTALS.delete();
        this.TOTALS.delete();
    }

    private void computePerMonthPerYearPerEventAndTotals() throws IOException, ParseException {
        HashMap<String, Writer> monthFileWritersPerFileBaseName = new HashMap<String, Writer>();
        HashMap<String, Writer> yearFileWritersPerFileBaseName = new HashMap<String, Writer>();
        HashMap<String, Writer> monthTotalsFileWritersPerFileBaseName = new HashMap<String, Writer>();
        HashMap<String, Writer> yearTotalsFileWritersPerFileBaseName = new HashMap<String, Writer>();
        OutputStreamWriter eventTotalsWriter = new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.EVENTTOTALS)));
        OutputStreamWriter totalsWriter = new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.TOTALS)));
        File[] fileArray = this.getAllHostnameFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File perHostnameFile = fileArray[n2];
            String hostname = perHostnameFile.getName().substring(0, perHostnameFile.getName().length() - HOSTNAME_FILE_EXTENSION.length());
            logger.info("Extracting per-month and per-year stats for hostname " + hostname);
            try (BufferedReader r = new BufferedReader(new FileReader(perHostnameFile));){
                String line;
                while ((line = r.readLine()) != null) {
                    PerHostnameEntry entry = new PerHostnameEntry(line);
                    String combinedLine = String.valueOf(hostname) + " " + line + "\n";
                    if (entry.getYear() != 0) {
                        String monthFileBasename = String.format("%04d_%02d", entry.getYear(), entry.getZeroBasedMonth() + 1);
                        Writer monthFileWriter = this.getFileWriter(monthFileBasename, monthFileWritersPerFileBaseName, this::getMonthFileCompressed, true, false);
                        monthFileWriter.write(combinedLine);
                        String monthTotalsFileBasename = String.valueOf(monthFileBasename) + MONTH_AND_YEAR_TOTALS_SUFFIX;
                        Writer monthTotalsFileWriter = this.getFileWriter(monthTotalsFileBasename, monthTotalsFileWritersPerFileBaseName, this::getMonthFileCompressed, true, false);
                        monthTotalsFileWriter.write(String.valueOf(line) + "\n");
                        String yearFileBasename = String.format("%04d", entry.getYear());
                        Writer yearFileWriter = this.getFileWriter(yearFileBasename, yearFileWritersPerFileBaseName, this::getYearFileCompressed, true, false);
                        yearFileWriter.write(combinedLine);
                        String yearTotalsFileBasename = String.valueOf(yearFileBasename) + MONTH_AND_YEAR_TOTALS_SUFFIX;
                        Writer yearTotalsFileWriter = this.getFileWriter(yearTotalsFileBasename, yearTotalsFileWritersPerFileBaseName, this::getYearFileCompressed, true, false);
                        yearTotalsFileWriter.write(String.valueOf(line) + "\n");
                    }
                    eventTotalsWriter.write(combinedLine);
                    totalsWriter.write(String.valueOf(line) + "\n");
                }
            }
            ++n2;
        }
        for (Writer monthFileWriter : monthFileWritersPerFileBaseName.values()) {
            monthFileWriter.close();
        }
        for (Writer yearFileWriter : yearFileWritersPerFileBaseName.values()) {
            yearFileWriter.close();
        }
        for (Writer monthTotalsFileWriter : monthTotalsFileWritersPerFileBaseName.values()) {
            monthTotalsFileWriter.close();
        }
        for (Writer yearTotalsFileWriter : yearTotalsFileWritersPerFileBaseName.values()) {
            yearTotalsFileWriter.close();
        }
        ((Writer)eventTotalsWriter).close();
        ((Writer)totalsWriter).close();
    }

    private File getMonthFileCompressed(String monthFileBaseName) {
        return new File(this.MONTHS, String.valueOf(monthFileBaseName) + GZIP_EXTENSION);
    }

    private File getYearFileCompressed(String yearFileBaseName) {
        return new File(this.YEARS, String.valueOf(yearFileBaseName) + GZIP_EXTENSION);
    }

    private void countUniqueEventOccurrencesPerMonthAndPerYearAndOverall() throws IOException {
        logger.info("Counting unique visitors per host for per-month files");
        this.countUniqueVisitorsPerHostname(this.MONTHS.listFiles((dir, filename) -> filename.matches("...._..\\.gz")));
        logger.info("Counting unique visitors per host for per-year files");
        this.countUniqueVisitorsPerHostname(this.YEARS.listFiles((dir, filename) -> filename.matches("....\\.gz")));
        logger.info("Counting unique visitors per host for event totals");
        this.countUniqueVisitorsPerHostname(new File[]{this.EVENTTOTALS});
    }

    private void countUniqueVisitorsPerHostname(File[] gzippedFiles) throws IOException {
        File[] fileArray = gzippedFiles;
        int n = gzippedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File gzippedFile = fileArray[n2];
            String canonicalPathOfGzippedFile = gzippedFile.getCanonicalPath();
            String canonicalPathWithoutGzipExtension = canonicalPathOfGzippedFile.substring(0, canonicalPathOfGzippedFile.length() - GZIP_EXTENSION.length());
            File uniqueFile = new File(String.valueOf(canonicalPathWithoutGzipExtension) + UNIQUE_SUFFIX);
            Set<String> uniqueLinesFromFile = this.readDistinctLinesFromGzippedFile(gzippedFile);
            FileWriter uniqueFileWriter = new FileWriter(uniqueFile);
            HashMap<String, Integer> hostnameCounts = new HashMap<String, Integer>();
            for (String string : uniqueLinesFromFile) {
                String hostname = string.split(" ")[0];
                this.inc(hostnameCounts, hostname);
            }
            for (Map.Entry entry : hostnameCounts.entrySet()) {
                uniqueFileWriter.write(String.valueOf((String)entry.getKey()) + " " + entry.getValue() + "\n");
            }
            uniqueFileWriter.close();
            ++n2;
        }
    }

    private void inc(Map<String, Integer> hostnameCountsForMonth, String hostname) {
        Integer count = hostnameCountsForMonth.get(hostname);
        count = count == null ? 1 : count + 1;
        hostnameCountsForMonth.put(hostname, count);
    }

    private void countTotalHits() throws IOException {
        logger.info("Counting total numbers of unique visitors for all, months, and years");
        this.countUniqueTotals(this.TOTALS, this.TOTALS_UNIQUE);
        File[] fileArray = this.MONTHS.listFiles((dir, filename) -> filename.endsWith("_totals.gz"));
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File monthGzippedTotals = fileArray[n2];
            this.countUniqueTotals(monthGzippedTotals, new File(monthGzippedTotals.getParentFile(), String.valueOf(monthGzippedTotals.getName().substring(0, monthGzippedTotals.getName().length() - GZIP_EXTENSION.length())) + UNIQUE_SUFFIX));
            ++n2;
        }
        fileArray = this.YEARS.listFiles((dir, filename) -> filename.endsWith("_totals.gz"));
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            File yearGzippedTotals = fileArray[n2];
            this.countUniqueTotals(yearGzippedTotals, new File(yearGzippedTotals.getParentFile(), String.valueOf(yearGzippedTotals.getName().substring(0, yearGzippedTotals.getName().length() - GZIP_EXTENSION.length())) + UNIQUE_SUFFIX));
            ++n2;
        }
    }

    private void countUniqueTotals(File gzippedEntriesWithoutHostname, File uniqueCount) throws IOException {
        FileWriter totalsCountWriter = new FileWriter(uniqueCount);
        Set<String> uniqueTotalLines = this.readDistinctLinesFromGzippedFile(gzippedEntriesWithoutHostname);
        totalsCountWriter.write(String.valueOf(uniqueTotalLines.size()) + "\n");
        totalsCountWriter.close();
    }

    private Set<String> readDistinctLinesFromGzippedFile(File gzippedFile) throws IOException {
        HashSet<String> result = new HashSet<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(gzippedFile))));){
            String line;
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
        }
        return result;
    }

    private void deleteDirectoryContentsRecursively(final Path directory, final String fileNameRegexpPattern) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (fileNameRegexpPattern == null || file.getName(file.getNameCount() - 1).toString().matches(fileNameRegexpPattern)) {
                    Files.delete(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!dir.equals(directory)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void addVisitedFile(String filename) throws IOException {
        FileWriter visitedFilesWriter = new FileWriter(this.VISITED_FILES, true);
        visitedFilesWriter.write(String.valueOf(filename) + "\n");
        visitedFilesWriter.close();
    }

    private void appendHitsToHostnameSpecificFiles(File logfileWhichMayUseGzipCompression) throws IOException {
        InputStreamReader reader = logfileWhichMayUseGzipCompression.getName().toLowerCase().endsWith(GZIP_EXTENSION) ? new InputStreamReader(new GZIPInputStream(new FileInputStream(logfileWhichMayUseGzipCompression))) : new FileReader(logfileWhichMayUseGzipCompression);
        this.appendHitsToHostnameSpecificFiles(reader);
    }

    private void appendHitsToHostnameSpecificFiles(Reader logfileReader) throws IOException {
        String line;
        HashMap<String, Writer> fileWritersPerHostname = new HashMap<String, Writer>();
        BufferedReader br = new BufferedReader(logfileReader);
        while ((line = br.readLine()) != null) {
            try {
                LogEntry entry = new LogEntry(line);
                String hostname = entry.getHostname();
                Writer fileWriterForHostname = this.getFileWriter(hostname, fileWritersPerHostname, this::getHostnameSpecificFile, false, true);
                String dateString = entry.getDateString();
                String requestorIpString = entry.getRequestorIpString();
                String userAgent = entry.getUserAgent();
                if (dateString == null || requestorIpString == null || userAgent == null) continue;
                fileWriterForHostname.write(String.valueOf(requestorIpString) + " " + dateString + " " + userAgent + "\n");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to parse log line \"" + line + "\". Skipping.", e);
            }
        }
        for (Writer fw : fileWritersPerHostname.values()) {
            fw.close();
        }
    }

    private Writer getFileWriter(String key, Map<String, Writer> fileWriterCache, Function<String, File> fileConstructor, boolean gzipCompressed, boolean append) throws IOException {
        Writer fileWriterForHostname;
        assert (!gzipCompressed || !append);
        if (fileWriterCache.containsKey(key)) {
            fileWriterForHostname = fileWriterCache.get(key);
        } else {
            File file = fileConstructor.apply(key);
            fileWriterForHostname = gzipCompressed ? new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(file))) : new FileWriter(file, append);
            fileWriterCache.put(key, fileWriterForHostname);
        }
        return fileWriterForHostname;
    }

    private File getHostnameSpecificFile(String hostname) {
        return new File(this.STATS, String.valueOf(hostname) + HOSTNAME_FILE_EXTENSION);
    }

    private File[] getAllHostnameFiles() {
        return this.STATS.listFiles((dir, filename) -> filename.endsWith(HOSTNAME_FILE_EXTENSION));
    }
}

