/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription.chargebee;

import com.sap.sse.common.Util;
import java.util.logging.Logger;

public class ChargebeeConfiguration {
    private static final Logger logger = Logger.getLogger(ChargebeeConfiguration.class.getName());
    private static final String CHARGEBEE_SITE = "chargebee.site";
    private static final String CHARGEBEE_APIKEY = "chargebee.apikey";
    private static ChargebeeConfiguration instance;
    private final String site;
    private final String apiKey;

    protected ChargebeeConfiguration(String site, String apiKey) {
        this.site = site;
        this.apiKey = apiKey;
    }

    public static ChargebeeConfiguration getInstance() {
        if (instance == null) {
            String site = System.getProperty(CHARGEBEE_SITE);
            String apiKey = System.getProperty(CHARGEBEE_APIKEY);
            logger.info("Chargebee site: " + site);
            if (Util.hasLength((String)site) && Util.hasLength((String)apiKey)) {
                instance = new ChargebeeConfiguration(site, apiKey);
                logger.info("Activating Chargebee Configuration and service");
            } else {
                logger.info("No chargebee.site and chargebee.apikey system properties provided. Not activating Chargebee service");
            }
        }
        return instance;
    }

    public String getSite() {
        return this.site;
    }

    public String getApiKey() {
        return this.apiKey;
    }
}

