/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.common.mail.MailException;
import com.sap.sse.common.media.TakedownNoticeRequestContext;
import com.sap.sse.replication.ReplicableWithObjectInputStream;
import com.sap.sse.security.Action;
import com.sap.sse.security.PermissionChangeListener;
import com.sap.sse.security.SecurityInitializationCustomizer;
import com.sap.sse.security.impl.ReplicableSecurityService;
import com.sap.sse.security.impl.SecurityServiceImpl;
import com.sap.sse.security.interfaces.Credential;
import com.sap.sse.security.operations.SecurityOperation;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.RolePrototype;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.UserGroupManagementException;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.LockingAndBanning;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.subscription.Subscription;
import com.sap.sse.security.shared.subscription.SubscriptionPlan;
import com.sap.sse.shared.classloading.ClassLoaderRegistry;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.ServletContext;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.SecurityManager;

public interface SecurityService
extends ReplicableWithObjectInputStream<ReplicableSecurityService, SecurityOperation<?>> {
    public static final String ALL_USERNAME = "<all>";
    public static final String TENANT_SUFFIX = "-tenant";
    public static final String REPLICABLE_FULLY_QUALIFIED_CLASSNAME = SecurityServiceImpl.class.getName();
    public static final Duration DEFAULT_CLIENT_IP_BASED_USER_CREATION_LOCKING_DURATION = Duration.ONE_MINUTE;

    public SecurityManager getSecurityManager();

    public OwnershipAnnotation getOwnership(QualifiedObjectIdentifier var1);

    public Iterable<AccessControlListAnnotation> getAccessControlLists();

    public AccessControlListAnnotation getAccessControlList(QualifiedObjectIdentifier var1);

    public AccessControlList overrideAccessControlList(QualifiedObjectIdentifier var1, Map<UserGroup, Set<String>> var2);

    public AccessControlList overrideAccessControlList(QualifiedObjectIdentifier var1, Map<UserGroup, Set<String>> var2, String var3);

    public AccessControlList addToAccessControlList(QualifiedObjectIdentifier var1, UserGroup var2, String var3);

    public AccessControlList removeFromAccessControlList(QualifiedObjectIdentifier var1, UserGroup var2, String var3);

    public void deleteAccessControlList(QualifiedObjectIdentifier var1);

    public Ownership setOwnership(QualifiedObjectIdentifier var1, User var2, UserGroup var3);

    public Ownership setOwnership(QualifiedObjectIdentifier var1, User var2, UserGroup var3, String var4);

    public void deleteOwnership(QualifiedObjectIdentifier var1);

    public Iterable<UserGroup> getUserGroupList();

    public Iterable<UserGroup> getUserGroupsWithRoleDefinition(RoleDefinition var1);

    public UserGroup getUserGroup(UUID var1);

    public UserGroup getUserGroupByName(String var1);

    public Iterable<UserGroup> getUserGroupsOfUser(User var1);

    public UserGroup createUserGroup(UUID var1, String var2) throws UserGroupManagementException;

    public void addUserToUserGroup(UserGroup var1, User var2);

    public void removeUserFromUserGroup(UserGroup var1, User var2);

    public void putRoleDefinitionToUserGroup(UserGroup var1, RoleDefinition var2, boolean var3);

    public void removeRoleDefintionFromUserGroup(UserGroup var1, RoleDefinition var2);

    public void deleteUserGroup(UserGroup var1) throws UserGroupManagementException;

    public Iterable<User> getUserList();

    public User getUserByName(String var1);

    public User getUserByEmail(String var1);

    public Iterable<User> getUsersWithPermissions(WildcardPermission var1);

    public User getCurrentUser();

    public String login(String var1, String var2) throws UserManagementException;

    public String getAuthenticationUrl(Credential var1) throws UserManagementException;

    public User verifySocialUser(Credential var1) throws UserManagementException;

    public void logout();

    public User createSimpleUser(String var1, String var2, String var3, String var4, String var5, Locale var6, String var7, UserGroup var8, String var9, boolean var10) throws UserManagementException, MailException, UserGroupManagementException;

    public void updateSimpleUserPassword(String var1, String var2) throws UserManagementException;

    public void updateSimpleUserEmail(String var1, String var2, String var3) throws UserManagementException;

    public void updateUserProperties(String var1, String var2, String var3, Locale var4) throws UserManagementException;

    public void deleteUser(String var1) throws UserManagementException;

    public RoleDefinition createRoleDefinition(UUID var1, String var2);

    public void deleteRoleDefinition(RoleDefinition var1);

    public void updateRoleDefinition(RoleDefinition var1);

    public Iterable<RoleDefinition> getRoleDefinitions();

    public RoleDefinition getRoleDefinition(UUID var1);

    public void addRoleForUser(User var1, Role var2);

    public void addRoleForUser(String var1, Role var2);

    public void removeRoleFromUser(User var1, Role var2);

    public void removeRoleFromUser(String var1, Role var2);

    public void removePermissionFromUser(String var1, WildcardPermission var2);

    public void addPermissionForUser(String var1, WildcardPermission var2);

    public void addSetting(String var1, Class<?> var2) throws UserManagementException;

    public boolean setSetting(String var1, Object var2);

    public Map<String, Object> getAllSettings();

    public Map<String, Class<?>> getAllSettingTypes();

    public void refreshSecurityConfig(ServletContext var1);

    public CacheManager getCacheManager();

    public void sendMail(String var1, String var2, String var3) throws MailException;

    public boolean checkPassword(String var1, String var2) throws UserManagementException;

    public boolean checkPasswordResetSecret(String var1, String var2) throws UserManagementException;

    public void resetPassword(String var1, String var2) throws UserManagementException, MailException;

    public boolean validateEmail(String var1, String var2) throws UserManagementException;

    public void setPreference(String var1, String var2, String var3);

    public void setPreferenceObject(String var1, String var2, Object var3);

    public void unsetPreference(String var1, String var2);

    public String getPreference(String var1, String var2);

    public <T> T getPreferenceObject(String var1, String var2);

    public <T> Map<String, T> getPreferenceObjectsByKey(String var1);

    public Map<String, String> getAllPreferences(String var1);

    public String createAccessToken(String var1);

    public String getAccessToken(String var1);

    public String getOrCreateAccessToken(String var1);

    public String getOrCreateTargetServerBearerToken(String var1, String var2, String var3, String var4);

    public User getUserByAccessToken(String var1);

    public void removeAccessToken(String var1);

    public UserGroup getServerGroup();

    public <T> T setOwnershipCheckPermissionForObjectCreationAndRevertOnError(HasPermissions var1, TypeRelativeObjectIdentifier var2, String var3, Callable<T> var4);

    public void setOwnershipCheckPermissionForObjectCreationAndRevertOnError(HasPermissions var1, TypeRelativeObjectIdentifier var2, String var3, Action var4);

    public User getAllUser();

    public void checkPermissionAndDeleteOwnershipForObjectRemoval(WithQualifiedObjectIdentifier var1, Action var2);

    public <T> T checkPermissionAndDeleteOwnershipForObjectRemoval(WithQualifiedObjectIdentifier var1, Callable<T> var2);

    public void deleteAllDataForRemovedObject(QualifiedObjectIdentifier var1);

    public <T extends WithQualifiedObjectIdentifier> void filterObjectsWithPermissionForCurrentUser(HasPermissions.Action var1, Iterable<T> var2, Consumer<T> var3);

    public <T extends WithQualifiedObjectIdentifier> void filterObjectsWithAnyPermissionForCurrentUser(HasPermissions.Action[] var1, Iterable<T> var2, Consumer<T> var3);

    public <T extends WithQualifiedObjectIdentifier, R> List<R> mapAndFilterByReadPermissionForCurrentUser(Iterable<T> var1, Function<T, R> var2);

    public <T extends WithQualifiedObjectIdentifier, R> List<R> mapAndFilterByAnyExplicitPermissionForCurrentUser(HasPermissions var1, HasPermissions.Action[] var2, Iterable<T> var3, Function<T, R> var4);

    public boolean hasCurrentUserReadPermission(WithQualifiedObjectIdentifier var1);

    public boolean hasCurrentUserUpdatePermission(WithQualifiedObjectIdentifier var1);

    public boolean hasCurrentUserDeletePermission(WithQualifiedObjectIdentifier var1);

    public boolean hasCurrentUserExplicitPermissions(WithQualifiedObjectIdentifier var1, HasPermissions.Action ... var2);

    public boolean hasCurrentUserOneOfExplicitPermissions(WithQualifiedObjectIdentifier var1, HasPermissions.Action ... var2);

    public void checkCurrentUserReadPermission(WithQualifiedObjectIdentifier var1);

    public void checkCurrentUserUpdatePermission(WithQualifiedObjectIdentifier var1);

    public void checkCurrentUserDeletePermission(WithQualifiedObjectIdentifier var1);

    public void checkCurrentUserDeletePermission(QualifiedObjectIdentifier var1);

    public void checkCurrentUserExplicitPermissions(WithQualifiedObjectIdentifier var1, HasPermissions.Action ... var2);

    public void checkCurrentUserHasOneOfExplicitPermissions(WithQualifiedObjectIdentifier var1, HasPermissions.Action ... var2);

    public void assumeOwnershipMigrated(String var1);

    public boolean migrateOwnership(WithQualifiedObjectIdentifier var1);

    public boolean migrateOwnership(QualifiedObjectIdentifier var1, String var2);

    public void migrateUser(User var1);

    public void migratePermission(User var1, WildcardPermission var2, Function<WildcardPermission, WildcardPermission> var3);

    public void migrateServerObject();

    public void checkMigration(Iterable<? extends HasPermissions> var1);

    public boolean hasCurrentUserMetaPermission(WildcardPermission var1, Ownership var2);

    public boolean hasCurrentUserMetaPermissionWithOwnershipLookup(WildcardPermission var1);

    public void setOwnershipIfNotSet(QualifiedObjectIdentifier var1, User var2, UserGroup var3);

    public UserGroup getDefaultTenantForCurrentUser();

    public void setTemporaryDefaultTenant(UUID var1);

    public boolean hasUserAllWildcardPermissionsForAlreadyRealizedQualifications(RoleDefinition var1, Iterable<WildcardPermission> var2);

    public void setDefaultTenantForCurrentServerForUser(String var1, UUID var2);

    public void copyUsersAndRoleAssociations(UserGroup var1, UserGroup var2, RoleCopyListener var3);

    public User checkPermissionForUserCreationAndRevertOnErrorForUserCreation(String var1, Callable<User> var2) throws UserManagementException;

    public <T> T checkPermissionAndDeleteOwnershipForObjectRemoval(QualifiedObjectIdentifier var1, Callable<T> var2);

    public void checkPermissionAndDeleteOwnershipForObjectRemoval(QualifiedObjectIdentifier var1, Action var2);

    public <T> T doWithTemporaryDefaultTenant(UserGroup var1, Callable<T> var2);

    public void initialize();

    public boolean hasCurrentUserMetaPermissionsOfRoleDefinitionWithQualification(RoleDefinition var1, Ownership var2);

    public boolean hasCurrentUserMetaPermissionsOfRoleDefinitionsWithQualification(Set<RoleDefinition> var1, Ownership var2);

    public boolean isInitialOrMigration();

    public boolean isNewServer();

    public RoleDefinition getOrCreateRoleDefinitionFromPrototype(RolePrototype var1, boolean var2);

    public void setDefaultOwnership(QualifiedObjectIdentifier var1, String var2);

    public void setDefaultOwnershipIfNotSet(QualifiedObjectIdentifier var1);

    public boolean hasCurrentUserAnyPermission(WildcardPermission var1);

    public <T> T setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(HasPermissions var1, TypeRelativeObjectIdentifier var2, String var3, Callable<T> var4);

    public void setOwnershipWithoutCheckPermissionForObjectCreationAndRevertOnError(HasPermissions var1, TypeRelativeObjectIdentifier var2, String var3, Action var4);

    public boolean hasCurrentUserServerPermission(SecuredSecurityTypes.ServerActions var1);

    public void checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions var1);

    public String getSharedAcrossSubdomainsOf();

    public String getBaseUrlForCrossDomainStorage();

    public void registerCustomizer(SecurityInitializationCustomizer var1);

    public void updateUserSubscription(String var1, Subscription var2) throws UserManagementException;

    public void addPermissionChangeListener(WildcardPermission var1, PermissionChangeListener var2);

    public void removePermissionChangeListener(WildcardPermission var1, PermissionChangeListener var2);

    public Iterable<? extends HasPermissions> getAllHasPermissions();

    public Map<Serializable, SubscriptionPlan> getAllSubscriptionPlans();

    public SubscriptionPlan getSubscriptionPlanById(String var1);

    default public HasPermissions getHasPermissionsByName(String securedTypeName) {
        return (HasPermissions)Util.first((Iterable)Util.filter(this.getAllHasPermissions(), hp -> hp.getName().equals(securedTypeName)));
    }

    public ClassLoaderRegistry getInitialLoadClassLoaderRegistry();

    public Role[] getSubscriptionPlanUserRoles(User var1, SubscriptionPlan var2);

    public SubscriptionPlan getSubscriptionPlanByItemPriceId(String var1);

    public void updateSubscriptionPlanPrices(Map<String, BigDecimal> var1);

    public Role createRoleFromIDs(UUID var1, UUID var2, String var3, boolean var4) throws UserManagementException;

    public Role getOrThrowRoleFromIDsAndCheckMetaPermissions(UUID var1, UUID var2, String var3, boolean var4) throws UserManagementException;

    public void lockSubscriptionsForUser(User var1);

    public void unlockSubscriptionsForUser(User var1);

    public void setCORSFilterConfigurationToWildcard(String var1);

    public void setCORSFilterConfigurationAllowedOrigins(String var1, String ... var2) throws IllegalArgumentException;

    public Util.Pair<Boolean, Set<String>> getCORSFilterConfiguration(String var1);

    public LockingAndBanning failedPasswordAuthentication(User var1);

    public void successfulPasswordAuthentication(User var1);

    public LockingAndBanning failedBearerTokenAuthentication(String var1);

    public void successfulBearerTokenAuthentication(String var1);

    public boolean isClientIPLockedForBearerTokenAuthentication(String var1);

    public void fileTakedownNotice(TakedownNoticeRequestContext var1) throws MailException;

    public Iterable<User> getUsersToInformAboutReplicaSet(String var1, Optional<HasPermissions.Action> var2);

    public static interface RoleCopyListener {
        public void onRoleCopy(User var1, Role var2, Role var3);
    }
}

