/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.components;

import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.datamining.data.HasSessionContext;
import com.sap.sse.security.datamining.data.impl.SessionWithContext;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.User;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;

public class SecuritySessionsRetrievalProcessor
extends AbstractRetrievalProcessor<SecurityService, HasSessionContext> {
    public SecuritySessionsRetrievalProcessor(ExecutorService executor, Collection<Processor<HasSessionContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(SecurityService.class, HasSessionContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasSessionContext> retrieveData(SecurityService securityService) {
        HashSet<HasSessionContext> data = new HashSet<HasSessionContext>();
        CacheManager cacheManager = securityService.getCacheManager();
        Cache activeSessionCache = cacheManager.getCache("shiro-activeSessionCache");
        block0: for (Object i : activeSessionCache.values()) {
            if (this.isAborted()) break;
            if (!(i instanceof Session)) continue;
            Session session = (Session)i;
            for (Object attributeKey : session.getAttributeKeys()) {
                User user;
                PrincipalCollection pc;
                Object attributeValue = session.getAttribute(attributeKey);
                if (!(attributeValue instanceof PrincipalCollection) || (pc = (PrincipalCollection)attributeValue) == null || pc.getPrimaryPrincipal() == null || (user = securityService.getUserByName((String)pc.getPrimaryPrincipal())) == null || !securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)user)) continue;
                data.add(new SessionWithContext(securityService, session, user));
                continue block0;
            }
        }
        return data;
    }
}

