/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining;

import com.sap.sse.datamining.DataSourceProvider;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.impl.AbstractDataMiningActivator;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.i18n.impl.ResourceBundleStringMessagesImpl;
import com.sap.sse.security.datamining.SecurityDataRetrievalChainDefinitions;
import com.sap.sse.security.datamining.SecurityServiceProvider;
import com.sap.sse.security.datamining.data.HasPermissionOfUserContext;
import com.sap.sse.security.datamining.data.HasPermissionOfUserInUserGroupContext;
import com.sap.sse.security.datamining.data.HasPreferenceOfUserContext;
import com.sap.sse.security.datamining.data.HasPreferenceOfUserInUserGroupContext;
import com.sap.sse.security.datamining.data.HasRoleOfUserContext;
import com.sap.sse.security.datamining.data.HasRoleOfUserGroupContext;
import com.sap.sse.security.datamining.data.HasRoleOfUserInUserGroupContext;
import com.sap.sse.security.datamining.data.HasSessionContext;
import com.sap.sse.security.datamining.data.HasSubscriptionContext;
import com.sap.sse.security.datamining.data.HasUserContext;
import com.sap.sse.security.datamining.data.HasUserGroupContext;
import com.sap.sse.security.datamining.data.HasUserInUserGroupContext;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractDataMiningActivator {
    private static final String STRING_MESSAGES_BASE_NAME = "stringmessages/SecurityDataMining_StringMessages";
    private static Activator INSTANCE;
    private BundleContext context = null;
    private final ResourceBundleStringMessages sailingServerStringMessages;
    private final SecurityDataRetrievalChainDefinitions dataRetrieverChainDefinitions = new SecurityDataRetrievalChainDefinitions();
    private Collection<DataSourceProvider<?>> dataSourceProviders;
    private boolean dataSourceProvidersHaveBeenInitialized;

    public Activator() {
        this.sailingServerStringMessages = new ResourceBundleStringMessagesImpl(STRING_MESSAGES_BASE_NAME, this.getClassLoader(), StandardCharsets.UTF_8.name());
    }

    public void start(BundleContext context) throws Exception {
        INSTANCE = this;
        this.context = context;
        this.dataSourceProvidersHaveBeenInitialized = false;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
        INSTANCE = null;
        super.stop(context);
    }

    public ResourceBundleStringMessages getStringMessages() {
        return this.sailingServerStringMessages;
    }

    public Iterable<Class<?>> getClassesWithMarkedMethods() {
        HashSet internalClasses = new HashSet();
        internalClasses.add(HasUserGroupContext.class);
        internalClasses.add(HasUserInUserGroupContext.class);
        internalClasses.add(HasRoleOfUserGroupContext.class);
        internalClasses.add(HasPermissionOfUserInUserGroupContext.class);
        internalClasses.add(HasPermissionOfUserContext.class);
        internalClasses.add(HasUserContext.class);
        internalClasses.add(HasRoleOfUserContext.class);
        internalClasses.add(HasRoleOfUserInUserGroupContext.class);
        internalClasses.add(HasPreferenceOfUserContext.class);
        internalClasses.add(HasPreferenceOfUserInUserGroupContext.class);
        internalClasses.add(HasSessionContext.class);
        internalClasses.add(HasSubscriptionContext.class);
        return internalClasses;
    }

    public Iterable<DataRetrieverChainDefinition<?, ?>> getDataRetrieverChainDefinitions() {
        return this.dataRetrieverChainDefinitions.getDataRetrieverChainDefinitions();
    }

    public Iterable<DataSourceProvider<?>> getDataSourceProviders() {
        if (!this.dataSourceProvidersHaveBeenInitialized) {
            this.initializeDataSourceProviders();
            this.dataSourceProvidersHaveBeenInitialized = true;
        }
        return this.dataSourceProviders;
    }

    public Iterable<AggregationProcessorDefinition<?, ?>> getAggregationProcessorDefinitions() {
        HashSet aggregators = new HashSet();
        return aggregators;
    }

    private void initializeDataSourceProviders() {
        this.dataSourceProviders = new HashSet();
        this.dataSourceProviders.add((DataSourceProvider<?>)new SecurityServiceProvider(this.context));
    }

    public static Activator getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new Activator();
        }
        return INSTANCE;
    }
}

