/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.impl.MongoRaceLogStoreVisitor;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class MongoRaceLogStoreImpl
implements RaceLogStore {
    private static final Logger logger = Logger.getLogger(MongoRaceLogStoreImpl.class.getName());
    private final MongoObjectFactory mongoObjectFactory;
    private final DomainObjectFactory domainObjectFactory;
    private final Map<RaceLogIdentifier, RaceLog> raceLogCache;
    private final WeakHashMap<RaceLog, MongoRaceLogStoreVisitor> listeners;

    public MongoRaceLogStoreImpl(MongoObjectFactory mongoObjectFactory, DomainObjectFactory domainObjectFactory) {
        this.mongoObjectFactory = mongoObjectFactory;
        this.domainObjectFactory = domainObjectFactory;
        this.raceLogCache = new HashMap<RaceLogIdentifier, RaceLog>();
        this.listeners = new WeakHashMap();
    }

    public RaceLog getRaceLog(RaceLogIdentifier identifier, boolean ignoreCache) {
        RaceLog result;
        if (!ignoreCache && this.raceLogCache.containsKey(identifier)) {
            result = this.raceLogCache.get(identifier);
        } else {
            result = this.domainObjectFactory.loadRaceLog(identifier);
            this.addListener(identifier, result);
            this.raceLogCache.put(identifier, result);
        }
        return result;
    }

    private void addListener(RaceLogIdentifier identifier, RaceLog raceLog) {
        MongoRaceLogStoreVisitor listener = new MongoRaceLogStoreVisitor(identifier, this.mongoObjectFactory);
        this.listeners.put(raceLog, listener);
        raceLog.addListener((Object)listener);
    }

    public void removeRaceLog(RaceLogIdentifier identifier) {
        logger.info("Removing race log " + identifier + " from the database");
        this.raceLogCache.remove(identifier);
        this.mongoObjectFactory.removeRaceLog(identifier);
    }

    public void removeListenersAddedByStoreFrom(RaceLog raceLog) {
        RaceLogEventVisitor visitor = this.listeners.get(raceLog);
        if (visitor != null) {
            raceLog.removeListener((Object)visitor);
        }
    }

    public void addImportedRaceLog(RaceLog raceLog, RaceLogIdentifier identifier) {
        this.addListener(identifier, raceLog);
        this.raceLogCache.put(identifier, raceLog);
    }

    public void clear() {
        this.mongoObjectFactory.removeAllRaceLogs();
        this.raceLogCache.clear();
    }
}

