/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence;

import com.mongodb.client.MongoDatabase;
import com.sap.sailing.domain.anniversary.DetailedRaceInfo;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.base.SailingServerConfiguration;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprint;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprint;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.Document;

public interface MongoObjectFactory {
    public void addWindTrackDumper(TrackedRegatta var1, TrackedRace var2, WindSource var3);

    public void storeLeaderboard(Leaderboard var1);

    public void removeLeaderboard(String var1);

    public void storeLeaderboardGroup(LeaderboardGroup var1);

    public void removeLeaderboardGroup(UUID var1);

    public void renameLeaderboardGroup(UUID var1, String var2);

    public void storeEvent(Event var1);

    public void renameEvent(Serializable var1, String var2);

    public void removeEvent(Serializable var1);

    public void storeServerConfiguration(SailingServerConfiguration var1);

    public void storeSailingServer(RemoteSailingServerReference var1);

    public void updateSailingServer(String var1, boolean var2, Set<UUID> var3);

    public void removeSailingServer(String var1);

    public void storeRegatta(Regatta var1);

    public void removeRegatta(Regatta var1);

    public void storeRegattaForRaceID(String var1, Regatta var2);

    public void removeRegattaForRaceID(String var1, Regatta var2);

    public void storeCompetitor(Competitor var1);

    public void storeCompetitors(Iterable<? extends Competitor> var1);

    public void removeAllCompetitors();

    public void removeCompetitor(Competitor var1);

    public void storeBoat(Boat var1);

    public void storeBoats(Iterable<? extends Boat> var1);

    public void removeAllBoats();

    public void removeBoat(Boat var1);

    public MongoDatabase getDatabase();

    public void storeDeviceConfiguration(DeviceConfiguration var1);

    public void removeDeviceConfiguration(UUID var1);

    public void removeRaceLog(RaceLogIdentifier var1);

    public void removeAllRaceLogs();

    public void removeRegattaLog(RegattaLikeIdentifier var1);

    public void removeAllRegattaLogs();

    public void storeResultUrl(String var1, URL var2);

    public void removeResultUrl(String var1, URL var2);

    public void removeConnectivityParametersForRaceToRestore(RaceTrackingConnectivityParameters var1) throws MalformedURLException;

    public void addConnectivityParametersForRaceToRestore(RaceTrackingConnectivityParameters var1);

    public void removeAllConnectivityParametersForRacesToRestore();

    public void storeAnniversaryData(ConcurrentHashMap<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> var1);

    public Document storeWind(Wind var1);

    public void storeMarkPassings(RaceIdentifier var1, MarkPassingRaceFingerprint var2, Map<Competitor, Map<Waypoint, MarkPassing>> var3, Course var4);

    public void removeMarkPassings(RaceIdentifier var1);

    public void storeManeuvers(RaceIdentifier var1, ManeuverRaceFingerprint var2, Course var3, Map<Competitor, List<Maneuver>> var4);

    public void removeManeuvers(RaceIdentifier var1);
}

