/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.anniversary.DetailedRaceInfo;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.RegattaRegistry;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.base.SailingServerConfiguration;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.domain.leaderboard.EventResolver;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.leaderboard.LeaderboardRegistry;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithEliminations;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprint;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprint;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParametersHandler;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.bson.Document;

public interface DomainObjectFactory {
    public WindTrack loadWindTrack(String var1, RaceDefinition var2, WindSource var3, long var4);

    public Leaderboard loadLeaderboard(String var1, RegattaRegistry var2, LeaderboardRegistry var3);

    public RaceIdentifier loadRaceIdentifier(Document var1);

    public LeaderboardGroup loadLeaderboardGroup(String var1, RegattaRegistry var2, LeaderboardRegistry var3);

    public Iterable<LeaderboardGroup> getAllLeaderboardGroups(RegattaRegistry var1, LeaderboardRegistry var2);

    public Iterable<Leaderboard> getLeaderboardsNotInGroup(RegattaRegistry var1, LeaderboardRegistry var2);

    public Map<? extends WindSource, ? extends WindTrack> loadWindTracks(String var1, RaceDefinition var2, long var3);

    public Event loadEvent(String var1);

    public Iterable<Util.Pair<Event, Boolean>> loadAllEvents();

    public void loadLeaderboardGroupLinksForEvents(EventResolver var1, LeaderboardGroupResolver var2);

    public SailingServerConfiguration loadServerConfiguration();

    public Iterable<RemoteSailingServerReference> loadAllRemoteSailingServerReferences();

    public Regatta loadRegatta(String var1, TrackedRegattaRegistry var2);

    public Iterable<Regatta> loadAllRegattas(TrackedRegattaRegistry var1);

    public Map<String, Regatta> loadRaceIDToRegattaAssociations(RegattaRegistry var1);

    public RaceLog loadRaceLog(RaceLogIdentifier var1);

    public RegattaLog loadRegattaLog(RegattaLikeIdentifier var1);

    public Iterable<CompetitorWithBoat> migrateLegacyCompetitorsIfRequired();

    public Collection<DynamicCompetitor> loadAllCompetitors();

    public Collection<DynamicBoat> loadAllBoats();

    public DomainFactory getBaseDomainFactory();

    public Iterable<DeviceConfiguration> loadAllDeviceConfigurations();

    public Map<String, Set<URL>> loadResultUrls();

    public ConnectivityParametersLoadingResult loadConnectivityParametersForRacesToRestore(Consumer<RaceTrackingConnectivityParameters> var1);

    public RegattaLeaderboardWithEliminations loadRegattaLeaderboardWithEliminations(Document var1, String var2, String var3, LeaderboardRegistry var4);

    public Map<? extends Integer, ? extends Util.Pair<DetailedRaceInfo, AnniversaryType>> getAnniversaryData() throws MalformedURLException;

    public TypeBasedServiceFinder<RaceTrackingConnectivityParametersHandler> getRaceTrackingConnectivityParamsServiceFinder();

    public Wind loadWind(Document var1);

    public Map<RaceIdentifier, MarkPassingRaceFingerprint> loadFingerprintsForMarkPassingHashes();

    public Map<RaceIdentifier, ManeuverRaceFingerprint> loadFingerprintsForManeuverHashes();

    public Map<Competitor, Map<Waypoint, MarkPassing>> loadMarkPassings(RaceIdentifier var1, Course var2);

    public Map<Competitor, List<Maneuver>> loadManeuvers(TrackedRace var1, Course var2);

    public static interface ConnectivityParametersLoadingResult {
        public long getNumberOfParametersToLoad();

        public void waitForCompletionOfCallbacksForAllParameters() throws InterruptedException, ExecutionException;
    }
}

