/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.interfaces.impl;

import com.sap.sse.common.Util;
import com.sap.sse.replication.ReplicaDescriptor;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.replication.ReplicationStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ReplicationStatusImpl
implements ReplicationStatus {
    private final boolean isReplica;
    private final String serverName;
    private final boolean isReplicationStarting;
    private final boolean isSuspended;
    private final boolean isStopped;
    private final long messageQueueLength;
    private final Map<String, Boolean> isInitialLoadRunning;
    private final Map<String, Integer> operationQueueLengths;
    private final ReplicationMasterDescriptor masterDescriptor;
    private final Iterable<ReplicaDescriptor> replicaDescriptors;
    private final String outboundExchangeName;
    private final int outboundMessagingPort;

    public ReplicationStatusImpl(boolean isReplica, String serverName, boolean isReplicationStarting, boolean isSuspended, boolean isStopped, long messageQueueLength, Map<String, Boolean> isInitialLoadRunning, Map<String, Integer> operationQueueLengths, ReplicationMasterDescriptor masterDescriptor, Iterable<ReplicaDescriptor> replicaDescriptors, String outboundExchangeName, int outboundMessagingPort) {
        this.isReplica = isReplica;
        this.serverName = serverName;
        this.isReplicationStarting = isReplicationStarting;
        this.isSuspended = isSuspended;
        this.isStopped = isStopped;
        this.messageQueueLength = messageQueueLength;
        this.isInitialLoadRunning = isInitialLoadRunning;
        this.operationQueueLengths = operationQueueLengths;
        this.masterDescriptor = masterDescriptor;
        this.replicaDescriptors = replicaDescriptors;
        this.outboundExchangeName = outboundExchangeName;
        this.outboundMessagingPort = outboundMessagingPort;
    }

    @Override
    public boolean isReplica() {
        return this.isReplica;
    }

    @Override
    public boolean isReplicationStarting() {
        return this.isReplicationStarting;
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    @Override
    public boolean isStopped() {
        return this.isStopped;
    }

    @Override
    public long getMessageQueueLength() {
        return this.messageQueueLength;
    }

    @Override
    public Iterable<String> getReplicableIdsAsStrings() {
        return Collections.unmodifiableMap(this.isInitialLoadRunning).keySet();
    }

    @Override
    public Integer getOperationQueueLength(String replicableIdAsString) {
        return this.operationQueueLengths.get(replicableIdAsString);
    }

    @Override
    public int getTotalOperationQueueLength() {
        int result = 0;
        for (Map.Entry<String, Integer> e : this.operationQueueLengths.entrySet()) {
            result += e.getValue().intValue();
        }
        return result;
    }

    @Override
    public Boolean isInitialLoadRunning(String replicableIdAsString) {
        return this.isInitialLoadRunning.get(replicableIdAsString);
    }

    @Override
    public boolean isAvailable() {
        return !this.isReplica() || !this.isReplicationStarting() && !this.isInitialLoadRunning();
    }

    private boolean isInitialLoadRunning() {
        boolean result = false;
        for (boolean initialLoadRunning : this.isInitialLoadRunning.values()) {
            result |= initialLoadRunning;
        }
        return result;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject result = new JSONObject();
        JSONArray replicablesJSON = new JSONArray();
        result.put((Object)"replica", (Object)this.isReplica());
        result.put((Object)"servername", (Object)this.serverName);
        result.put((Object)"replicationstarting", (Object)this.isReplicationStarting());
        result.put((Object)"suspended", (Object)this.isSuspended());
        result.put((Object)"stopped", (Object)this.isStopped());
        result.put((Object)"messagequeuelength", (Object)this.getMessageQueueLength());
        result.put((Object)"totaloperationqueuelength", (Object)this.getTotalOperationQueueLength());
        result.put((Object)"outboundmessagingname", (Object)this.outboundExchangeName);
        result.put((Object)"outboundmessagingport", (Object)this.outboundMessagingPort);
        for (String replicableIdAsString : this.getReplicableIdsAsStrings()) {
            Boolean initialLoadRunning = this.isInitialLoadRunning(replicableIdAsString);
            if (initialLoadRunning == null) continue;
            JSONObject replicableJSON = new JSONObject();
            replicableJSON.put((Object)"id", (Object)replicableIdAsString);
            replicableJSON.put((Object)"initialloadrunning", (Object)initialLoadRunning);
            Integer operationQueueLength = this.getOperationQueueLength(replicableIdAsString);
            replicableJSON.put((Object)"operationqueuelength", (Object)(operationQueueLength == null ? 0 : operationQueueLength));
            replicableJSON.put((Object)"replicatedfrom", (Object)this.getReplicatedFromAsJSON(replicableIdAsString));
            replicableJSON.put((Object)"replicatedby", (Object)this.getReplicatedByAsJSON(replicableIdAsString));
            replicablesJSON.add((Object)replicableJSON);
        }
        result.put((Object)"replicables", (Object)replicablesJSON);
        result.put((Object)"available", (Object)this.isAvailable());
        return result;
    }

    private JSONObject getReplicatedFromAsJSON(String replicableIdAsString) {
        JSONObject result = this.masterDescriptor != null && Util.contains((Iterable)Util.map(this.masterDescriptor.getReplicables(), r -> r.getId().toString()), (Object)replicableIdAsString) ? this.serializeMasterDescriptorAsJSON() : null;
        return result;
    }

    private JSONObject serializeMasterDescriptorAsJSON() {
        JSONObject result = new JSONObject();
        result.put((Object)"exchange", (Object)this.masterDescriptor.getExchangeName());
        result.put((Object)"hostname", (Object)this.masterDescriptor.getHostname());
        result.put((Object)"port", (Object)this.masterDescriptor.getServletPort());
        result.put((Object)"messaginghostname", (Object)this.masterDescriptor.getMessagingHostname());
        result.put((Object)"messagingport", (Object)this.masterDescriptor.getMessagingPort());
        return result;
    }

    private JSONArray getReplicatedByAsJSON(String replicableIdAsString) {
        JSONArray result = new JSONArray();
        for (ReplicaDescriptor replicaDescriptor : this.replicaDescriptors) {
            if (!Arrays.asList(replicaDescriptor.getReplicableIdsAsStrings()).contains(replicableIdAsString)) continue;
            result.add((Object)this.serializeReplicaDescriptorAsJSON(replicaDescriptor));
        }
        return result;
    }

    private JSONObject serializeReplicaDescriptorAsJSON(ReplicaDescriptor replicaDescriptor) {
        JSONObject result = new JSONObject();
        result.put((Object)"id", (Object)replicaDescriptor.getUuid().toString());
        result.put((Object)"registrationtimemillis", (Object)replicaDescriptor.getRegistrationTime().asMillis());
        result.put((Object)"port", (Object)replicaDescriptor.getPort());
        result.put((Object)"address", (Object)replicaDescriptor.getIpAddress().getHostAddress());
        result.put((Object)"additionalinformation", (Object)replicaDescriptor.getAdditionalInformation());
        return result;
    }
}

