/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.impl;

import com.sap.sse.common.Util;
import com.sap.sse.security.shared.PermissionChecker;
import com.sap.sse.security.shared.SecurityAccessControlList;
import com.sap.sse.security.shared.SecurityUserGroup;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.UserGroup;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAccessControlList<G extends SecurityUserGroup<?>>
implements SecurityAccessControlList<G> {
    private static final long serialVersionUID = -8587238587604749862L;
    private Map<G, Set<WildcardPermission>> allowedActionsByUserGroup = new HashMap<G, Set<WildcardPermission>>();
    private Map<G, Set<WildcardPermission>> deniedActionsByUserGroup = new HashMap<G, Set<WildcardPermission>>();

    protected AbstractAccessControlList(Map<G, Set<String>> permissionMap) {
        for (Map.Entry<G, Set<String>> permissionMapEntry : permissionMap.entrySet()) {
            this.setPermissions((SecurityUserGroup)permissionMapEntry.getKey(), permissionMapEntry.getValue());
        }
    }

    @Override
    public PermissionChecker.PermissionState hasPermission(String action, Iterable<G> groupsOfWhichUserIsMember) {
        PermissionChecker.PermissionState result = PermissionChecker.PermissionState.NONE;
        WildcardPermission requestedAction = new WildcardPermission(action);
        if (this.allowedActionsByUserGroup.containsKey(null) && this.doesAnyPermissionImplyRequestedAction(this.allowedActionsByUserGroup.get(null), requestedAction)) {
            result = PermissionChecker.PermissionState.GRANTED;
        }
        if (this.deniedActionsByUserGroup.containsKey(null) && this.doesAnyPermissionImplyRequestedAction(this.deniedActionsByUserGroup.get(null), requestedAction)) {
            result = PermissionChecker.PermissionState.REVOKED;
        } else {
            for (SecurityUserGroup userGroupOfWhichUserIsMember : groupsOfWhichUserIsMember) {
                if (result == PermissionChecker.PermissionState.NONE && this.doesAnyPermissionImplyRequestedAction(this.allowedActionsByUserGroup.get(userGroupOfWhichUserIsMember), requestedAction)) {
                    result = PermissionChecker.PermissionState.GRANTED;
                }
                if (!this.doesAnyPermissionImplyRequestedAction(this.deniedActionsByUserGroup.get(userGroupOfWhichUserIsMember), requestedAction)) continue;
                result = PermissionChecker.PermissionState.REVOKED;
                break;
            }
        }
        return result;
    }

    private boolean doesAnyPermissionImplyRequestedAction(Set<WildcardPermission> permissions, WildcardPermission requestedAction) {
        if (permissions != null) {
            for (WildcardPermission allowedOrDeniedAction : permissions) {
                if (!allowedOrDeniedAction.implies(requestedAction)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<G, Set<String>> getActionsByUserGroup() {
        HashMap result = new HashMap();
        for (Map.Entry<G, Set<WildcardPermission>> allowedEntry : this.allowedActionsByUserGroup.entrySet()) {
            for (WildcardPermission permission : allowedEntry.getValue()) {
                Util.addToValueSet(result, (Object)((SecurityUserGroup)allowedEntry.getKey()), (Object)permission.toString());
            }
        }
        for (Map.Entry<G, Set<WildcardPermission>> allowedEntry : this.deniedActionsByUserGroup.entrySet()) {
            for (WildcardPermission permission : allowedEntry.getValue()) {
                Util.addToValueSet(result, (Object)((SecurityUserGroup)allowedEntry.getKey()), (Object)this.invertAction(permission.toString()));
            }
        }
        return result;
    }

    @Override
    public Set<String> getAllowedActions(UserGroup group) {
        return Util.asSet((Iterable)Util.map(this.allowedActionsByUserGroup.get(group) == null ? Collections.emptySet() : (Iterable)this.allowedActionsByUserGroup.get(group), wp -> wp.toString()));
    }

    @Override
    public Map<G, Set<WildcardPermission>> getAllowedActions() {
        return Collections.unmodifiableMap(this.allowedActionsByUserGroup);
    }

    @Override
    public Set<String> getDeniedActions(UserGroup group) {
        return Util.asSet((Iterable)Util.map(this.deniedActionsByUserGroup.get(group) == null ? Collections.emptySet() : (Iterable)this.deniedActionsByUserGroup.get(group), wp -> wp.toString()));
    }

    @Override
    public Map<G, Set<WildcardPermission>> getDeniedActions() {
        return Collections.unmodifiableMap(this.deniedActionsByUserGroup);
    }

    @Override
    private boolean isDeniedAction(String action) {
        return SecurityAccessControlList.isDeniedAction(action);
    }

    @Override
    private String invertAction(String action) {
        return SecurityAccessControlList.invertAction(action);
    }

    private boolean denyPermission(G userGroup, String action) {
        boolean result = this.isDeniedAction(action) ? this.addPermission(userGroup, this.invertAction(action)) : Util.addToValueSet(this.deniedActionsByUserGroup, userGroup, (Object)new WildcardPermission(action));
        return result;
    }

    @Override
    public boolean addPermission(G userGroup, String action) {
        boolean result = this.isDeniedAction(action) ? this.denyPermission(userGroup, this.invertAction(action)) : Util.addToValueSet(this.allowedActionsByUserGroup, userGroup, (Object)new WildcardPermission(action));
        return result;
    }

    @Override
    public boolean removePermission(G userGroup, String action) {
        boolean result = this.isDeniedAction(action) ? this.removeDenial(userGroup, this.invertAction(action)) : Util.removeFromValueSet(this.allowedActionsByUserGroup, userGroup, (Object)new WildcardPermission(action));
        return result;
    }

    private boolean removeDenial(G userGroup, String action) {
        boolean result = this.isDeniedAction(action) ? this.removeDenial(userGroup, this.invertAction(action)) : Util.removeFromValueSet(this.deniedActionsByUserGroup, userGroup, (Object)new WildcardPermission(action));
        return result;
    }

    @Override
    public void setPermissions(G userGroup, Set<String> actions) {
        this.allowedActionsByUserGroup.remove(userGroup);
        this.deniedActionsByUserGroup.remove(userGroup);
        for (String actionAsString : actions) {
            if (this.isDeniedAction(actionAsString)) {
                this.denyPermission(userGroup, this.invertAction(actionAsString));
                continue;
            }
            this.addPermission(userGroup, actionAsString);
        }
    }

    public String toString() {
        return "AccessControlList [actionsByUserGroup=" + this.getActionsByUserGroup() + "]";
    }
}

